/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import weblogic.jdbc.common.internal.JDBCOutputStream;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class JDBCOutputStreamStub
extends OutputStream
implements JDBCOutputStream,
Serializable,
StubDelegateInfo {
    JDBCOutputStream remoteOs;
    boolean verbose = false;
    byte[] bytes = null;
    private int currpos = 0;
    boolean closed = false;
    int block_size;

    public JDBCOutputStreamStub(JDBCOutputStream jDBCOutputStream, boolean bl, int n) {
        this.remoteOs = jDBCOutputStream;
        this.verbose = bl;
        this.block_size = n;
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        if (this.bytes == null) {
            this.bytes = new byte[this.block_size];
        }
        if (this.currpos >= this.block_size) {
            this.flush();
        }
        this.bytes[this.currpos++] = (byte)n;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        if (this.bytes != null && this.currpos > 0) {
            if (this.currpos >= this.block_size) {
                this.writeBlock(this.bytes);
                this.currpos = 0;
                this.remoteOs.flush();
            } else {
                byte[] byArray = new byte[this.currpos];
                System.arraycopy(this.bytes, 0, byArray, 0, byArray.length);
                this.writeBlock(byArray);
                this.currpos = 0;
                this.remoteOs.flush();
            }
        } else {
            this.remoteOs.flush();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Stream has been closed and cannot be used");
        }
        if (byArray == null || n < 0 || n > n2 || n2 < 0 || n2 > byArray.length) {
            throw new IOException("ERROR parameters are incorrect - no data or offset or length are incorrect");
        }
        if (n == 0 && n2 == byArray.length) {
            this.writeBlock(byArray);
        } else if (n2 == 1 || byArray.length == 1) {
            this.write(byArray[n]);
        } else if (n > 0 || n2 < byArray.length) {
            int n3 = n2 - n;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n, byArray2, 0, n3);
            this.writeBlock(byArray2);
        }
    }

    public void write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR stream has been closed and cannot be used");
        }
        if (byArray == null) {
            throw new IOException("ERROR cannot accept null input");
        }
        try {
            this.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.remoteOs.close();
        this.closed = true;
    }

    public void writeBlock(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.remoteOs.writeBlock(byArray);
    }

    public Object getStubDelegate() {
        return this.remoteOs;
    }
}

