/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.security.AccessController;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import weblogic.application.ApplicationAccess;
import weblogic.common.internal.PeerInfo;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionEnv;
import weblogic.jdbc.common.internal.ConnectionPoolManager;
import weblogic.jdbc.common.internal.JDBCHelper;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.RmiDataSource;
import weblogic.jdbc.rmi.SerialConnection;
import weblogic.jdbc.rmi.internal.ConnectionImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.jndi.Alias;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.protocol.configuration.ChannelHelper;
import weblogic.rmi.extensions.RemoteHelper;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityManager;
import weblogic.security.service.SecurityServiceManager;
import weblogic.t3.srvr.T3Srvr;

public class JDBCServerHelperImpl
extends JDBCHelper {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean remoteEnabled = new Boolean(System.getProperty("weblogic.jdbc.remoteEnabled", "true"));
    private static final UnsupportedOperationException remoteUnsupportedException = new UnsupportedOperationException("Remote JDBC disabled");
    private static ServerMBean localServerMBean = null;

    public Object interopReplace(weblogic.jdbc.wrapper.Connection connection, PeerInfo peerInfo) {
        if (!remoteEnabled) {
            throw remoteUnsupportedException;
        }
        RmiDataSource rmiDataSource = connection.getRMIDataSource();
        try {
            RmiDriverSettings rmiDriverSettings;
            Properties properties;
            if (rmiDataSource != null) {
                properties = rmiDataSource.getDriverProperties();
                rmiDriverSettings = rmiDataSource.getDriverSettings();
            } else {
                properties = new Properties();
                rmiDriverSettings = new RmiDriverSettings();
            }
            ConnectionImpl connectionImpl = (ConnectionImpl)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.ConnectionImpl", (Object)connection, (boolean)true);
            connectionImpl.init((Connection)connection, properties, rmiDriverSettings, connection.getPoolName());
            try {
                connectionImpl.addPeerGoneListener();
            }
            catch (Exception exception) {
                JDBCLogger.logStackTrace((Throwable)exception);
            }
            return new SerialConnection((Connection)((Object)connectionImpl));
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this;
        }
    }

    public boolean getAutoConnectionClose() {
        if (KernelStatus.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
            String string = serverMBean.getAutoJDBCConnectionClose();
            return !string.equalsIgnoreCase("false");
        }
        return true;
    }

    public String getDefaultURL() {
        return ChannelHelper.getDefaultURL();
    }

    public String getCurrentApplicationName() {
        return ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
    }

    public String getDomainName() {
        return ManagementService.getRuntimeAccess(KERNEL_ID).getDomainName();
    }

    public String getServerName() {
        return ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getName();
    }

    public boolean isServerShuttingDown() {
        int n = T3Srvr.getT3Srvr().getRunState();
        return n == 18 || n == 7;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return DocumentBuilderFactory.newInstance();
    }

    public Object createJNDIAlias(String string, Object object) {
        return new Alias(string);
    }

    public boolean isProductionModeEnabled() {
        return ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().isProductionModeEnabled();
    }

    public String getXAMultiPoolName(JDBCDataSourceBean jDBCDataSourceBean) {
        JDBCDataSourceBean jDBCDataSourceBean2;
        int n;
        String string = null;
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().getJDBCSystemResources();
        for (n = 0; n < jDBCSystemResourceMBeanArray.length; ++n) {
            String string2;
            jDBCDataSourceBean2 = jDBCSystemResourceMBeanArray[n].getJDBCResource();
            if (jDBCDataSourceBean2 == null || (string2 = jDBCDataSourceBean2.getJDBCDataSourceParams().getDataSourceList()) == null || !string2.contains(jDBCDataSourceBean.getName())) continue;
            if (JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean2) == 0) {
                if (jDBCDataSourceBean2.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("None")) continue;
                return jDBCDataSourceBean2.getName();
            }
            string = jDBCDataSourceBean2.getName();
            break;
        }
        if (string == null) {
            return null;
        }
        for (n = 0; n < jDBCSystemResourceMBeanArray.length; ++n) {
            jDBCDataSourceBean2 = jDBCSystemResourceMBeanArray[n].getJDBCResource();
            if (jDBCDataSourceBean2 == null || JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean2) != 4 || !string.equals(JDBCMBeanConverter.getInternalProperty(jDBCDataSourceBean2, "LegacyPoolName"))) continue;
            return string;
        }
        return null;
    }

    public List dsToList(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = stringTokenizer.countTokens();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public boolean isRACPool(String string, String string2, String string3) {
        try {
            ConnectionEnv connectionEnv = ConnectionPoolManager.reserve((String)string, (String)string2, (String)string3, (int)-2);
            DatabaseMetaData databaseMetaData = connectionEnv.conn.jconn.getMetaData();
            if (databaseMetaData != null) {
                String string4 = databaseMetaData.getDatabaseProductVersion();
                int n = 0;
                n = string4.indexOf("Real Application Clusters");
                return n != -1;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isLLRPool(JDBCDataSourceBean jDBCDataSourceBean) {
        return jDBCDataSourceBean != null && jDBCDataSourceBean.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("LoggingLastResource");
    }

    public boolean isLLRTablePerDataSource(String string) {
        String string2 = "weblogic.llr.table." + string;
        String string3 = System.getProperty(string2);
        return string3 != null;
    }

    public String getJDBCLLRTableName(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupServer(string);
        return serverMBean.getJDBCLLRTableName();
    }

    public Boolean isUseFusionForLLR(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupServer(string);
        return serverMBean.isUseFusionForLLR();
    }

    public int getJDBCLLRTableXIDColumnSize(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupServer(string);
        return serverMBean.getJDBCLLRTableXIDColumnSize();
    }

    public int getJDBCLLRTablePoolColumnSize(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupServer(string);
        return serverMBean.getJDBCLLRTablePoolColumnSize();
    }

    public int getJDBCLLRTableRecordColumnSize(String string) {
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().lookupServer(string);
        return serverMBean.getJDBCLLRTableRecordColumnSize();
    }

    public boolean isJNDIEnabled() {
        return true;
    }

    public static boolean isExalogicOptimizationsEnabled() {
        return ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().isExalogicOptimizationsEnabled();
    }

    public void addRMIContext(Object object) throws Exception {
        if (JDBCServerHelperImpl.rmiSecure()) {
            EndPoint endPoint = RemoteHelper.getEndPoint((Object)object);
            if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                JdbcDebug.JDBCRMI.debug("setting security context for remote endpoint " + endPoint);
            }
            AuthenticatedSubject authenticatedSubject = null;
            authenticatedSubject = RemoteDomainSecurityHelper.getSubject(endPoint);
            if (authenticatedSubject == null) {
                byte by = KERNEL_ID.getQOS();
                if (by == 103) {
                    if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                        JdbcDebug.JDBCRMI.debug("Admin QOS present");
                    }
                    authenticatedSubject = KERNEL_ID;
                } else if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("Not setting security context, no admin channel");
                }
            }
            if (authenticatedSubject != null) {
                if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("setting security context " + authenticatedSubject);
                }
                SecurityManager.pushSubject((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject);
            }
        }
    }

    public void removeRMIContext(Object object) throws Exception {
        AuthenticatedSubject authenticatedSubject;
        if (JDBCServerHelperImpl.rmiSecure() && (SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)(authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID))) || RemoteDomainSecurityHelper.getSubject(RemoteHelper.getEndPoint((Object)object)) != null)) {
            if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                JdbcDebug.JDBCRMI.debug("removing subject " + authenticatedSubject);
            }
            SecurityManager.popSubject((AuthenticatedSubject)KERNEL_ID);
        }
    }

    public boolean isRMISecure() {
        return JDBCServerHelperImpl.rmiSecure();
    }

    public static boolean rmiSecure() {
        ServerMBean serverMBean = JDBCServerHelperImpl.getLocalServerMBean();
        return serverMBean != null && "Secure".equals(serverMBean.getDataSource().getRmiJDBCSecurity());
    }

    private static ServerMBean getLocalServerMBean() {
        RuntimeAccess runtimeAccess;
        if (localServerMBean == null && (runtimeAccess = ManagementService.getRuntimeAccess(KERNEL_ID)) != null) {
            localServerMBean = runtimeAccess.getServer();
        }
        return localServerMBean;
    }
}

