/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.DriverManager;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import weblogic.application.ApplicationFactoryManager;
import weblogic.common.ResourceException;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.diagnostics.image.ImageManager;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ConnectionPoolManager;
import weblogic.jdbc.common.internal.ConnectionPoolRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.DataSourceManager;
import weblogic.jdbc.common.internal.DataSourceRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.DataSourceService;
import weblogic.jdbc.common.internal.DataSourceServiceFullImpl;
import weblogic.jdbc.common.internal.DriverRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.HAConnectionPool;
import weblogic.jdbc.common.internal.HAUtil;
import weblogic.jdbc.common.internal.HAUtilImpl;
import weblogic.jdbc.common.internal.JDBCHelper;
import weblogic.jdbc.common.internal.JDBCImageSource;
import weblogic.jdbc.common.internal.JDBCServerHelperImpl;
import weblogic.jdbc.common.internal.MultiDataSourceRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.MultiPool;
import weblogic.jdbc.common.internal.OracleDataSourceRuntimeImpl;
import weblogic.jdbc.common.internal.ServiceRuntimeMBeanImpl;
import weblogic.jdbc.module.JDBCApplicationModuleFactory;
import weblogic.jdbc.module.JDBCDataSourceFactory;
import weblogic.jdbc.module.JDBCDeploymentFactory;
import weblogic.jdbc.module.JDBCDeploymentListener;
import weblogic.jdbc.module.JDBCEditCompatibilityObserver;
import weblogic.jdbc.module.JDBCModuleFactory;
import weblogic.logging.LoggingOutputStream;
import weblogic.logging.LoggingPrintStream;
import weblogic.logging.WLLevel;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.JDBCDataSourceFactoryMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.JDBCDataSourceRuntimeMBean;
import weblogic.management.runtime.JDBCDriverRuntimeMBean;
import weblogic.management.runtime.JDBCMultiDataSourceRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class JDBCService
extends AbstractServerService {
    private boolean isResumed = false;
    private ServerMBean serverMBean;
    private static ConnectionPoolManager cpMgr;
    private static DataSourceManager dsMgr;
    private ServiceRuntimeMBeanImpl serviceRTMBean;
    private static HashMap dsRTMBeans;
    private static HashMap cpRTMBeans;
    private static HashMap mdsRTMBeans;
    private static HashMap driverRTMBeans;
    private JDBCDeploymentListener deploymentListener;
    private static final AuthenticatedSubject KERNELID;

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    private void initialize() throws ServiceFailureException {
        JDBCLogger.logInit();
        try {
            this.serverMBean = ManagementService.getRuntimeAccess(KERNELID).getServer();
            dsRTMBeans = new HashMap();
            cpRTMBeans = new HashMap();
            mdsRTMBeans = new HashMap();
            driverRTMBeans = new HashMap();
            JDBCHelper.setHelper((JDBCHelper)new JDBCServerHelperImpl());
            DataSourceManager.setDataSourceService((DataSourceService)new DataSourceServiceFullImpl());
            HAUtil.setInstance((HAUtil)new HAUtilImpl());
            this.createRuntimeMBean();
            int n = this.serverMBean.getJDBCLoginTimeoutSeconds();
            if (n > 0) {
                DriverManager.setLoginTimeout(n);
                JDBCLogger.logSetLoginTimeout((int)n);
            }
            ImageManager.getInstance().registerImageSource("JDBC", new JDBCImageSource());
            this.initLog();
            cpMgr = new ConnectionPoolManager();
            dsMgr = DataSourceManager.getInstance();
            this.initFactories();
            this.setupConfigurationHandlers();
            HealthMonitorService.register("JDBC", this.serviceRTMBean, true);
        }
        catch (Exception exception) {
            String string = JDBCLogger.logInitFailed2();
            JDBCLogger.logStackTraceId((String)string, (Throwable)exception);
            throw new ServiceFailureException(string, (Throwable)exception);
        }
        JDBCLogger.logInitDone();
    }

    public String getVersion() {
        return "JSR-221, JDBC 4.0";
    }

    public void start() throws ServiceFailureException {
        this.initialize();
        JDBCLogger.logResume();
        if (this.isResumed) {
            JDBCLogger.logResumeOpInvalid();
            return;
        }
        this.isResumed = true;
        try {
            cpMgr.resume();
            Iterator iterator = ConnectionPoolManager.getConnectionPools();
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)iterator.next();
                JDBCService.createConnectionPoolRuntimeMBean(connectionPool, connectionPool.getAppName(), connectionPool.getModuleName());
                JDBCService.createDataSourceRuntimeMBean(connectionPool, connectionPool.getAppName(), connectionPool.getModuleName(), connectionPool.getJDBCDataSource());
            }
            dsMgr.resume();
        }
        catch (Exception exception) {
            String string = JDBCLogger.logResumeFailed();
            JDBCLogger.logStackTraceId((String)string, (Throwable)exception);
            throw new ServiceFailureException((Throwable)exception);
        }
        JDBCLogger.logResumeDone();
    }

    public void stop() throws ServiceFailureException {
        JDBCLogger.logSuspend();
        try {
            if (dsMgr != null) {
                dsMgr.suspend(true);
            }
            if (cpMgr != null) {
                cpMgr.suspend(true);
            }
            this.isResumed = false;
            this.destroyRuntimeMBeans();
        }
        catch (Exception exception) {
            String string = JDBCLogger.logSuspendFailed();
            JDBCLogger.logStackTraceId((String)string, (Throwable)exception);
            throw new ServiceFailureException(string, (Throwable)exception);
        }
        JDBCLogger.logSuspendDone();
        this.shutdown();
    }

    public void halt() throws ServiceFailureException {
        JDBCLogger.logFSuspend();
        try {
            if (dsMgr != null) {
                dsMgr.forceSuspend(true);
            }
            if (cpMgr != null) {
                cpMgr.forceSuspend(true);
            }
            this.isResumed = false;
        }
        catch (Exception exception) {
            String string = JDBCLogger.logFSuspendFailed();
            JDBCLogger.logStackTraceId((String)string, (Throwable)exception);
        }
        JDBCLogger.logFSuspendDone();
        this.shutdown();
    }

    public void shutdown() throws ServiceFailureException {
        JDBCLogger.logShutdown2();
        try {
            HealthMonitorService.unregister("JDBC");
            this.removeConfigurationHandlers();
            if (dsMgr != null) {
                dsMgr.shutdown();
            }
            if (cpMgr != null) {
                cpMgr.shutdown();
            }
            this.destroyRuntimeMBeans();
        }
        catch (Exception exception) {
            String string = JDBCLogger.logShutdownFailed();
            JDBCLogger.logStackTraceId((String)string, (Throwable)exception);
            throw new ServiceFailureException((Throwable)exception);
        }
        JDBCLogger.logShutdownDone();
    }

    public static ConnectionPoolManager getConnectionPoolManager() {
        return cpMgr;
    }

    public static DataSourceManager getDataSourceManager() {
        return dsMgr;
    }

    public static synchronized JDBCDataSourceRuntimeMBean[] getJDBCDataSourceRuntimeMBeans() {
        Object[] objectArray = dsRTMBeans.values().toArray();
        JDBCDataSourceRuntimeMBean[] jDBCDataSourceRuntimeMBeanArray = new JDBCDataSourceRuntimeMBean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            jDBCDataSourceRuntimeMBeanArray[i] = (JDBCDataSourceRuntimeMBean)objectArray[i];
        }
        return jDBCDataSourceRuntimeMBeanArray;
    }

    public static synchronized JDBCMultiDataSourceRuntimeMBean[] getJDBCMultiDataSourceRuntimeMBeans() {
        Object[] objectArray = mdsRTMBeans.values().toArray();
        JDBCMultiDataSourceRuntimeMBean[] jDBCMultiDataSourceRuntimeMBeanArray = new JDBCMultiDataSourceRuntimeMBean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            jDBCMultiDataSourceRuntimeMBeanArray[i] = (JDBCMultiDataSourceRuntimeMBean)objectArray[i];
        }
        return jDBCMultiDataSourceRuntimeMBeanArray;
    }

    public static synchronized void addJDBCDriverRuntimeMBean(JDBCDriverRuntimeMBean jDBCDriverRuntimeMBean, String string) {
        driverRTMBeans.put(string, jDBCDriverRuntimeMBean);
    }

    public static synchronized void removeJDBCDriverRuntimeMBean(String string) {
        driverRTMBeans.remove(string);
    }

    public static synchronized JDBCDriverRuntimeMBean getJDBCDriverRuntimeMBean(String string) {
        return (JDBCDriverRuntimeMBean)driverRTMBeans.get(string);
    }

    public static synchronized JDBCDriverRuntimeMBean[] getJDBCDriverRuntimeMBeans() {
        Object[] objectArray = driverRTMBeans.values().toArray();
        JDBCDriverRuntimeMBean[] jDBCDriverRuntimeMBeanArray = new JDBCDriverRuntimeMBean[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            jDBCDriverRuntimeMBeanArray[i] = (JDBCDriverRuntimeMBean)objectArray[i];
        }
        return jDBCDriverRuntimeMBeanArray;
    }

    public HealthState getHealthState() {
        Object object;
        String[] stringArray;
        int n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ConnectionPoolManager.getConnectionPools();
        while (iterator.hasNext()) {
            f += 1.0f;
            stringArray = (String[])iterator.next();
            object = stringArray.getDerivedState();
            if (((String)object).equals("Unhealthy")) {
                f2 += 1.0f;
                stringBuffer.append("Connection Pool Name = " + this.getPresentationName((ConnectionPool)stringArray) + ", State = " + "Unhealthy" + "\n");
                continue;
            }
            if (!((String)object).equals("Overloaded")) continue;
            f3 += 1.0f;
            stringBuffer.append("Connection Pool Name = " + this.getPresentationName((ConnectionPool)stringArray) + ", State = " + "Overloaded" + "\n");
        }
        if (f2 > 0.0f) {
            n = f2 == f ? 3 : (f2 >= f / 2.0f ? 2 : 1);
        } else if (f3 > 0.0f) {
            n = 4;
        }
        stringArray = new String[]{stringBuffer.toString()};
        object = new HealthState(n, stringArray);
        return object;
    }

    private void createRuntimeMBean() throws Exception {
        this.serviceRTMBean = new ServiceRuntimeMBeanImpl(this);
        ManagementService.getRuntimeAccess(KERNELID).getServerRuntime().setJDBCServiceRuntime(this.serviceRTMBean);
    }

    private void destroyRuntimeMBeans() throws ManagementException {
        JDBCService.unregister(dsRTMBeans.values());
        JDBCService.unregister(cpRTMBeans.values());
        JDBCService.unregister(mdsRTMBeans.values());
        JDBCService.unregister(this.serviceRTMBean);
    }

    private static void unregister(Collection collection) throws ManagementException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            JDBCService.unregister((RuntimeMBeanDelegate)iterator.next());
        }
        collection.clear();
    }

    private void initFactories() {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        JDBCDataSourceFactoryMBean[] jDBCDataSourceFactoryMBeanArray = runtimeAccess.getDomain().getJDBCDataSourceFactories();
        for (int i = 0; i < jDBCDataSourceFactoryMBeanArray.length; ++i) {
            JDBCDataSourceFactory.addDataSourceFactory(jDBCDataSourceFactoryMBeanArray[i]);
        }
        ApplicationFactoryManager applicationFactoryManager = ApplicationFactoryManager.getApplicationFactoryManager();
        applicationFactoryManager.addWLAppModuleFactory(new JDBCApplicationModuleFactory());
        applicationFactoryManager.addWblogicModuleFactory(new JDBCModuleFactory());
        applicationFactoryManager.addDeploymentFactory(new JDBCDeploymentFactory());
    }

    private void initLog() {
        DebugLogger debugLogger = DebugLogger.getDebugLogger((String)"DebugJDBCDriverLogging");
        if (debugLogger.isDebugEnabled() || this.serverMBean.isJDBCLoggingEnabled()) {
            try {
                DriverManager.setLogStream(new LoggingPrintStream(new LoggingOutputStream("JDBCDriverLogging", WLLevel.DEBUG, true)));
                DriverManager.println("JDBC log stream started at " + new Date().toString());
            }
            catch (Exception exception) {
                JDBCLogger.logErrorLogInit((String)exception.toString());
            }
        }
        debugLogger = null;
    }

    private void setupConfigurationHandlers() throws DeploymentException {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        runtimeAccess.addAccessCallbackClass(JDBCEditCompatibilityObserver.class.getName());
        this.deploymentListener = new JDBCDeploymentListener();
        DeploymentEventManager.addVetoableDeploymentListener(this.deploymentListener);
        DeploymentEventManager.addVetoableSystemResourceDeploymentListener(this.deploymentListener);
    }

    private void removeConfigurationHandlers() {
        if (this.deploymentListener != null) {
            DeploymentEventManager.removeVetoableDeploymentListener(this.deploymentListener);
            DeploymentEventManager.removeVetoableSystemResourceDeploymentListener(this.deploymentListener);
        }
    }

    private static void registerMBeansWithService(ConnectionPool connectionPool, JDBCDataSourceRuntimeMBean jDBCDataSourceRuntimeMBean, String string) throws ManagementException {
        if (JDBCService.getJDBCDriverRuntimeMBean(string) == null) {
            DriverRuntimeMBeanImpl driverRuntimeMBeanImpl = new DriverRuntimeMBeanImpl(string);
            JDBCService.addJDBCDriverRuntimeMBean(driverRuntimeMBeanImpl, string);
            ((DataSourceRuntimeMBeanImpl)jDBCDataSourceRuntimeMBean).setJDBCDriverRuntime(driverRuntimeMBeanImpl);
        } else {
            ((DataSourceRuntimeMBeanImpl)jDBCDataSourceRuntimeMBean).setJDBCDriverRuntime(JDBCService.getJDBCDriverRuntimeMBean(string));
        }
    }

    public static synchronized ComponentRuntimeMBean createJDBCMultiDataSourceRuntimeMBean(MultiPool multiPool, String string, String string2) throws ManagementException {
        RuntimeMBean runtimeMBean = JDBCService.getParent(string);
        String string3 = JDBCService.qualifiedName(string, string2, multiPool.getName());
        MultiDataSourceRuntimeMBeanImpl multiDataSourceRuntimeMBeanImpl = new MultiDataSourceRuntimeMBeanImpl(multiPool, string3, runtimeMBean, (DescriptorBean)multiPool.getDataSourceBean());
        mdsRTMBeans.put(string3, multiDataSourceRuntimeMBeanImpl);
        return multiDataSourceRuntimeMBeanImpl;
    }

    public static synchronized void destroyMultiDataSourceRuntimeMBean(String string, String string2, String string3) throws ManagementException {
        String string4 = JDBCService.qualifiedName(string, string2, string3);
        MultiDataSourceRuntimeMBeanImpl multiDataSourceRuntimeMBeanImpl = (MultiDataSourceRuntimeMBeanImpl)mdsRTMBeans.remove(string4);
        JDBCService.unregister(multiDataSourceRuntimeMBeanImpl);
    }

    public static ComponentRuntimeMBean createConnectionPoolRuntimeMBean(ConnectionPool connectionPool, String string, String string2) throws ManagementException {
        RuntimeMBean runtimeMBean = JDBCService.getParent(string);
        String string3 = JDBCService.qualifiedName(string, string2, connectionPool.getName());
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl = new ConnectionPoolRuntimeMBeanImpl(connectionPool, string3, runtimeMBean);
        cpRTMBeans.put(string3, connectionPoolRuntimeMBeanImpl);
        return connectionPoolRuntimeMBeanImpl;
    }

    public static void destroyConnectionPoolRuntimeMBean(String string, String string2, String string3) throws ManagementException {
        String string4 = JDBCService.qualifiedName(string, string2, string3);
        ConnectionPoolRuntimeMBeanImpl connectionPoolRuntimeMBeanImpl = (ConnectionPoolRuntimeMBeanImpl)cpRTMBeans.remove(string4);
        JDBCService.unregister(connectionPoolRuntimeMBeanImpl);
    }

    public static OracleDataSourceRuntimeImpl createHADataSourceRuntimeMBean(HAConnectionPool hAConnectionPool, String string, String string2, JDBCDataSourceBean jDBCDataSourceBean) throws ManagementException {
        RuntimeMBean runtimeMBean = JDBCService.getParent(string);
        String string3 = JDBCService.qualifiedName(string, string2, hAConnectionPool.getName());
        OracleDataSourceRuntimeImpl oracleDataSourceRuntimeImpl = new OracleDataSourceRuntimeImpl((ConnectionPool)hAConnectionPool, string3, runtimeMBean, (DescriptorBean)jDBCDataSourceBean);
        dsRTMBeans.put(string3, oracleDataSourceRuntimeImpl);
        return oracleDataSourceRuntimeImpl;
    }

    public static DataSourceRuntimeMBeanImpl createDataSourceRuntimeMBean(ConnectionPool connectionPool, String string, String string2, JDBCDataSourceBean jDBCDataSourceBean) throws ManagementException {
        RuntimeMBean runtimeMBean = JDBCService.getParent(string);
        String string3 = JDBCService.qualifiedName(string, string2, connectionPool.getName());
        DataSourceRuntimeMBeanImpl dataSourceRuntimeMBeanImpl = new DataSourceRuntimeMBeanImpl(connectionPool, string3, runtimeMBean, (DescriptorBean)jDBCDataSourceBean);
        dsRTMBeans.put(string3, dataSourceRuntimeMBeanImpl);
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        String string4 = runtimeAccess.getDomainName() + "_" + runtimeAccess.getServerName() + "_" + connectionPool.getDriverVersion();
        JDBCService.registerMBeansWithService(connectionPool, dataSourceRuntimeMBeanImpl, string4);
        return dataSourceRuntimeMBeanImpl;
    }

    public static void destroyDataSourceRuntimeMBean(final String string, String string2, String string3, String string4) throws ResourceException {
        string4 = JDBCService.qualifiedName(string2, string3, string4);
        final DataSourceRuntimeMBeanImpl dataSourceRuntimeMBeanImpl = (DataSourceRuntimeMBeanImpl)dsRTMBeans.remove(string4);
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)KERNELID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DriverRuntimeMBeanImpl driverRuntimeMBeanImpl = (DriverRuntimeMBeanImpl)JDBCService.getJDBCDriverRuntimeMBean(string);
                    if (driverRuntimeMBeanImpl != null) {
                        JDBCService.removeJDBCDriverRuntimeMBean(driverRuntimeMBeanImpl.getName());
                        driverRuntimeMBeanImpl.unregister();
                    }
                    if (dataSourceRuntimeMBeanImpl != null) {
                        dataSourceRuntimeMBeanImpl.unregister();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ResourceException(privilegedActionException.toString());
        }
    }

    private static String qualifiedName(String string, String string2, String string3) {
        if (string != null) {
            string3 = string + "@" + string2 + "@" + string3;
        }
        return string3;
    }

    private String getPresentationName(ConnectionPool connectionPool) {
        return (connectionPool.getAppName() != null ? connectionPool.getAppName() + ":" : "") + (connectionPool.getModuleName() != null ? connectionPool.getModuleName() + ":" : "") + connectionPool.getName();
    }

    private static RuntimeMBean getParent(String string) {
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(KERNELID);
        return runtimeAccess.getServerRuntime().lookupApplicationRuntime(string);
    }

    private static void unregister(final RuntimeMBeanDelegate runtimeMBeanDelegate) throws ManagementException {
        try {
            SecurityServiceManager.runAs((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)KERNELID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (runtimeMBeanDelegate != null) {
                        runtimeMBeanDelegate.unregister();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new ManagementException(privilegedActionException.toString());
        }
    }

    static {
        KERNELID = JDBCService.getKernelID();
    }
}

