/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import weblogic.jdbc.common.internal.JDBCWriter;
import weblogic.jdbc.common.internal.JDBCWriterStub;
import weblogic.rmi.extensions.server.SmartStubInfo;
import weblogic.rmi.server.UnicastRemoteObject;

public class JDBCWriterImpl
extends Writer
implements JDBCWriter,
SmartStubInfo {
    Writer t2_wtr;
    boolean verbose = false;
    boolean closed = false;
    int block_size;
    private transient JDBCWriterStub wtrstub = null;

    public JDBCWriterImpl(Writer writer, boolean bl, int n) {
        this.block_size = n;
        this.verbose = bl;
        this.t2_wtr = writer;
    }

    public void writeBlock(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        this.t2_wtr.write(cArray);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        this.t2_wtr.write(cArray, n, n2);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        this.t2_wtr.flush();
    }

    public void close() throws IOException {
        try {
            UnicastRemoteObject.unexportObject((Object)this, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        if (this.closed) {
            return;
        }
        this.t2_wtr.close();
        this.closed = true;
        this.t2_wtr = null;
        this.wtrstub = null;
    }

    public Object getSmartStub(Object object) {
        if (this.wtrstub == null) {
            this.wtrstub = new JDBCWriterStub((JDBCWriter)object, this.verbose, this.block_size);
        }
        return this.wtrstub;
    }
}

