/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import weblogic.jdbc.common.internal.JDBCWriter;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class JDBCWriterStub
extends Writer
implements JDBCWriter,
Serializable,
StubDelegateInfo {
    JDBCWriter remoteWtr;
    boolean verbose = false;
    char[] chars = null;
    private int currpos = 0;
    boolean closed = false;
    int block_size;

    public JDBCWriterStub(JDBCWriter jDBCWriter, boolean bl, int n) {
        this.remoteWtr = jDBCWriter;
        this.block_size = n;
        this.verbose = bl;
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        this.remoteWtr.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        if (this.chars != null && this.currpos > 0) {
            if (this.currpos >= this.block_size) {
                this.writeBlock(this.chars);
                this.remoteWtr.flush();
                this.currpos = 0;
            } else {
                char[] cArray = new char[this.currpos];
                System.arraycopy(this.chars, 0, cArray, 0, cArray.length);
                this.writeBlock(cArray);
                this.remoteWtr.flush();
                this.currpos = 0;
            }
        } else {
            this.remoteWtr.flush();
        }
    }

    public void writeBlock(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        this.remoteWtr.writeBlock(cArray);
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        if (this.chars == null) {
            this.chars = new char[this.block_size];
        }
        if (this.currpos >= this.block_size) {
            this.flush();
        }
        this.chars[this.currpos++] = (char)n;
    }

    public void write(String string) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        if (string == null) {
            throw new IOException("ERROR cannot accept null input");
        }
        char[] cArray = string.toCharArray();
        try {
            this.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        if (string == null) {
            throw new IOException("ERROR cannot accept null input");
        }
        if (n >= n2) {
            throw new IOException("ERROR offset (" + n + ") cannot exceed length " + n2);
        }
        if (n2 > string.length()) {
            throw new IOException("ERROR offset (" + n2 + ") cannot exceed input length" + string.length());
        }
        char[] cArray = string.toCharArray();
        try {
            this.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void write(char[] cArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        if (cArray == null) {
            throw new IOException("ERROR cannot accept null input");
        }
        try {
            this.write(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR Writer has been closed and cannot be used");
        }
        if (cArray == null || n < 0 || n > n2 || n2 < 0 || n2 > cArray.length) {
            throw new IOException("ERROR parameters are incorrect - no data or offset or length are incorrct");
        }
        if (n == 0 && n2 == cArray.length) {
            this.writeBlock(cArray);
        } else if (n2 == 1 || cArray.length == 1) {
            this.write(cArray[n]);
        } else if (n > 0 || n2 < cArray.length) {
            int n3 = n2 - n;
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
            this.writeBlock(cArray2);
        }
    }

    public Object getStubDelegate() {
        return this.remoteWtr;
    }
}

