/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.util.ArrayList;
import java.util.List;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ONSDaemonRuntimeImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ONSClientRuntimeMBean;
import weblogic.management.runtime.ONSDaemonRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public class ONSClientRuntimeImpl
extends RuntimeMBeanDelegate
implements ONSClientRuntimeMBean {
    JDBCDataSourceBean dsBean;
    List<ONSDaemonRuntimeMBean> daemons = new ArrayList<ONSDaemonRuntimeMBean>();

    public ONSClientRuntimeImpl(JDBCDataSourceBean jDBCDataSourceBean, String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean, true);
        this.dsBean = jDBCDataSourceBean;
        this.createONSDaemons();
    }

    public ONSDaemonRuntimeMBean[] getONSDaemonRuntimes() {
        return this.daemons.toArray(new ONSDaemonRuntimeMBean[this.daemons.size()]);
    }

    private void createONSDaemons() throws NumberFormatException, ManagementException {
        String string = this.dsBean.getJDBCOracleParams().getOnsNodeList();
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = string.split("[\\s,]");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split("[\\s:]");
            if (stringArray2.length < 2) {
                if (!JdbcDebug.JDBCRAC.isDebugEnabled()) continue;
                JdbcDebug.JDBCRAC.debug("invalid ONS host/port: " + stringArray[i]);
                continue;
            }
            String string2 = this.name + "_" + i;
            ONSDaemonRuntimeImpl oNSDaemonRuntimeImpl = new ONSDaemonRuntimeImpl(stringArray2[0], Integer.valueOf(stringArray2[1]), this.dsBean.getJDBCOracleParams().getOnsWalletFile(), this.dsBean.getJDBCOracleParams().getOnsWalletPassword(), string2, this);
            if (JdbcDebug.JDBCRAC.isDebugEnabled()) {
                JdbcDebug.JDBCRAC.debug("created ONSDaemonRuntimeMBean " + string2);
            }
            this.daemons.add(oNSDaemonRuntimeImpl);
        }
    }
}

