/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.util.Date;
import weblogic.jdbc.common.internal.DataSourceUtil;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.management.ManagementException;
import weblogic.management.runtime.ONSDaemonRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.utils.StackTraceUtils;

public class ONSDaemonRuntimeImpl
extends RuntimeMBeanDelegate
implements ONSDaemonRuntimeMBean {
    private String host;
    private String wallet;
    private String password;
    private int port;
    private String status;

    public ONSDaemonRuntimeImpl(String string, int n, String string2, String string3, String string4, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string4, runtimeMBean, true);
        this.host = string;
        this.port = n;
        this.wallet = string2;
        this.password = string3;
        this.status = "Unknown";
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getStatus() {
        try {
            this.ping();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.status;
    }

    public void ping() {
        try {
            if (this.wallet != null && this.password != null) {
                DataSourceUtil.onsPing((String)this.host, (int)this.port, (String)this.wallet, (char[])this.password.toCharArray());
            } else {
                DataSourceUtil.onsPing((String)this.host, (int)this.port, null, null);
            }
            this.status = "Running";
        }
        catch (Exception exception) {
            this.status = exception.getMessage() == null ? "Failed " : exception.getMessage();
            this.status = this.status + " - " + new Date();
            if (JdbcDebug.JDBCRAC.isDebugEnabled()) {
                JdbcDebug.JDBCRAC.debug("ONS ping failed for " + this.host + ":" + this.port + " with: " + StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            throw new RuntimeException("ONS ping failed for " + this.host + ":" + this.port, exception);
        }
    }
}

