/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import weblogic.common.resourcepool.ResourcePoolGroup;
import weblogic.jdbc.common.internal.HAConnectionPool;
import weblogic.jdbc.common.internal.HADataSourceInstanceRuntime;
import weblogic.jdbc.common.internal.OracleDataSourceRuntimeImpl;
import weblogic.jdbc.common.rac.RACInstance;
import weblogic.jdbc.common.rac.RACModule;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JDBCOracleDataSourceInstanceRuntimeMBean;
import weblogic.management.runtime.JDBCOracleDataSourceRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;

public class OracleDataSourceInstanceRuntimeImpl
extends RuntimeMBeanDelegate
implements JDBCOracleDataSourceInstanceRuntimeMBean,
HADataSourceInstanceRuntime {
    ResourcePoolGroup group;
    String instanceName;
    HAConnectionPool hacp;
    String signature;

    public OracleDataSourceInstanceRuntimeImpl(ResourcePoolGroup resourcePoolGroup, RuntimeMBean runtimeMBean) throws ManagementException {
        super(resourcePoolGroup.getName(), runtimeMBean, true);
        this.group = resourcePoolGroup;
        this.instanceName = resourcePoolGroup.getName();
        this.hacp = (HAConnectionPool)((OracleDataSourceRuntimeImpl)runtimeMBean).pool;
        RACModule rACModule = this.hacp.getRACModule();
        RACInstance rACInstance = rACModule.getRACInstance(this.instanceName);
        this.signature = rACInstance == null ? "instance=" + this.instanceName + ",service=" + ((JDBCOracleDataSourceRuntimeMBean)runtimeMBean).getServiceName() : "instance=" + rACInstance.getInstance() + ",service=" + rACInstance.getService() + ",database=" + rACInstance.getDatabase() + ",host=" + rACInstance.getHost();
    }

    public ResourcePoolGroup getGroup() {
        return this.group;
    }

    public int getActiveConnectionsCurrentCount() {
        return this.group.getNumReserved();
    }

    public int getConnectionsTotalCount() {
        return this.group.getTotalNumAllocated();
    }

    public int getCurrCapacity() {
        return this.group.getCurrCapacity();
    }

    public int getCurrentWeight() {
        return this.hacp.getWeightForInstance(this.instanceName);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getNumAvailable() {
        return this.group.getNumAvailable();
    }

    public int getNumUnavailable() {
        return this.group.getNumUnavailable();
    }

    public long getReserveRequestCount() {
        return this.group.getNumReserveRequests();
    }

    public String getSignature() {
        return this.signature;
    }

    public String getState() {
        return this.group.getState();
    }

    public boolean isEnabled() {
        return this.group.isEnabled();
    }

    public boolean isAffEnabled() {
        return this.hacp.getAffForInstance(this.instanceName);
    }

    private void debug(String string) {
        System.out.println("OracleDataSourceInstanceRuntimeImpl: name=" + this.name + ": " + string);
    }
}

