/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.util.ArrayList;
import java.util.List;
import weblogic.common.resourcepool.ResourcePoolGroup;
import weblogic.descriptor.DescriptorBean;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.DataSourceRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.HAConnectionPool;
import weblogic.jdbc.common.internal.HADataSourceInstanceRuntime;
import weblogic.jdbc.common.internal.HADataSourceRuntime;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ONSClientRuntimeImpl;
import weblogic.jdbc.common.internal.OracleDataSourceInstanceRuntimeImpl;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JDBCOracleDataSourceInstanceRuntimeMBean;
import weblogic.management.runtime.JDBCOracleDataSourceRuntimeMBean;
import weblogic.management.runtime.ONSClientRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;

public class OracleDataSourceRuntimeImpl
extends DataSourceRuntimeMBeanImpl
implements JDBCOracleDataSourceRuntimeMBean,
HADataSourceRuntime {
    List<HADataSourceInstanceRuntime> racInstances = new ArrayList<HADataSourceInstanceRuntime>();
    ONSClientRuntimeMBean onsClient;

    public OracleDataSourceRuntimeImpl(ConnectionPool connectionPool, String string, RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) throws ManagementException {
        super(connectionPool, string, runtimeMBean, descriptorBean);
        ((HAConnectionPool)connectionPool).setHADataSourceRuntime((HADataSourceRuntime)this);
        List list = connectionPool.getGroups();
        for (ResourcePoolGroup resourcePoolGroup : list) {
            String string2 = resourcePoolGroup.getName();
            if (JdbcDebug.JDBCRAC.isDebugEnabled()) {
                JdbcDebug.JDBCRAC.debug("Creating runtime MBean for instance=" + string2);
            }
            this.createInstanceRuntime(resourcePoolGroup);
        }
        this.onsClient = new ONSClientRuntimeImpl(connectionPool.dsBean, string, this);
    }

    public HADataSourceInstanceRuntime createInstanceRuntime(ResourcePoolGroup resourcePoolGroup) throws ManagementException {
        if (JdbcDebug.JDBCRAC.isDebugEnabled()) {
            JdbcDebug.JDBCRAC.debug("Creating runtime MBean for instance=" + resourcePoolGroup.getName());
        }
        OracleDataSourceInstanceRuntimeImpl oracleDataSourceInstanceRuntimeImpl = new OracleDataSourceInstanceRuntimeImpl(resourcePoolGroup, this);
        this.racInstances.add(oracleDataSourceInstanceRuntimeImpl);
        return oracleDataSourceInstanceRuntimeImpl;
    }

    public boolean instanceExists(ResourcePoolGroup resourcePoolGroup) {
        for (HADataSourceInstanceRuntime hADataSourceInstanceRuntime : this.racInstances) {
            ResourcePoolGroup resourcePoolGroup2 = hADataSourceInstanceRuntime.getGroup();
            if (resourcePoolGroup2 == null || !resourcePoolGroup2.getName().equals(resourcePoolGroup.getName())) continue;
            return true;
        }
        return false;
    }

    public JDBCOracleDataSourceInstanceRuntimeMBean[] getInstances() {
        return this.racInstances.toArray(new JDBCOracleDataSourceInstanceRuntimeMBean[this.racInstances.size()]);
    }

    public ONSClientRuntimeMBean getONSClientRuntime() {
        return this.onsClient;
    }

    public String getServiceName() {
        return ((HAConnectionPool)this.pool).getServiceName();
    }

    public long getFailedAffinityBasedBorrowCount() {
        return ((HAConnectionPool)this.pool).getFailedAffinityBasedBorrowCount();
    }

    public long getFailedRCLBBasedBorrowCount() {
        return ((HAConnectionPool)this.pool).getFailedRCLBBasedBorrowCount();
    }

    public long getSuccessfulAffinityBasedBorrowCount() {
        return ((HAConnectionPool)this.pool).getSuccessfulAffinityBasedBorrowCount();
    }

    public long getSuccessfulRCLBBasedBorrowCount() {
        return ((HAConnectionPool)this.pool).getSuccessfulRCLBBasedBorrowCount();
    }
}

