/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.Reader;
import java.rmi.NoSuchObjectException;
import java.util.Hashtable;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderContainer;
import weblogic.rmi.server.UnicastRemoteObject;

public class ReaderBlockGetterImpl
implements ReaderBlockGetter {
    private int lastId = 0;
    private int block_size = 1024;
    private Hashtable readers = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(Reader reader, int n) {
        ReaderContainer readerContainer = new ReaderContainer(reader, n);
        ReaderBlockGetterImpl readerBlockGetterImpl = this;
        synchronized (readerBlockGetterImpl) {
            ++this.lastId;
            this.readers.put("" + this.lastId, readerContainer);
            return this.lastId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getReader(int n) {
        ReaderContainer readerContainer = null;
        Reader reader = null;
        ReaderBlockGetterImpl readerBlockGetterImpl = this;
        synchronized (readerBlockGetterImpl) {
            readerContainer = (ReaderContainer)this.readers.get("" + n);
        }
        if (readerContainer != null) {
            reader = readerContainer.rdr;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char[] getBlock(int n) {
        ReaderContainer readerContainer = null;
        Object object = this;
        synchronized (object) {
            readerContainer = (ReaderContainer)this.readers.get("" + n);
        }
        if (readerContainer == null) {
            return null;
        }
        object = readerContainer;
        synchronized (object) {
            char[] cArray = new char[readerContainer.block_size];
            int n2 = -1;
            try {
                n2 = readerContainer.rdr.read(cArray);
            }
            catch (IOException iOException) {
                JDBCLogger.logStackTrace((Throwable)iOException);
            }
            if (n2 < 0) {
                return null;
            }
            if (n2 >= readerContainer.block_size) {
                return cArray;
            }
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, 0, cArray2, 0, cArray2.length);
            return cArray2;
        }
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public boolean markSupported(int n) {
        Reader reader = this.getReader(n);
        return reader.markSupported();
    }

    public void mark(int n, int n2) throws IOException {
        Reader reader = this.getReader(n);
        reader.mark(n2);
    }

    public boolean ready(int n) throws IOException {
        Reader reader = this.getReader(n);
        return reader.ready();
    }

    public void reset(int n) throws IOException {
        Reader reader = this.getReader(n);
        reader.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) {
        block8: {
            ReaderContainer readerContainer = null;
            Object object = this;
            synchronized (object) {
                readerContainer = (ReaderContainer)this.readers.remove("" + n);
            }
            try {
                if (readerContainer == null) break block8;
                object = readerContainer;
                synchronized (object) {
                    readerContainer.rdr.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            UnicastRemoteObject.unexportObject((Object)this, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

