/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.Reader;
import java.rmi.RemoteException;
import weblogic.jdbc.common.internal.ReaderBlockGetter;

public final class ReaderHandler
extends Reader {
    private char[] chars = null;
    private int idx = 0;
    private boolean eof = false;
    private boolean closed = false;
    private ReaderBlockGetter rbg = null;
    private int id = 0;
    private boolean marked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReaderBlockGetter(ReaderBlockGetter readerBlockGetter, int n) {
        Object object = this.lock;
        synchronized (object) {
            this.rbg = readerBlockGetter;
            this.id = n;
        }
    }

    public int read(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new NullPointerException();
        }
        int n = -1;
        try {
            n = this.read(cArray, 0, cArray.length);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfClosed();
            if (this.eof) {
                return -1;
            }
            int n3 = 0;
            try {
                int n4 = n2 - n3;
                while (n4 > 0) {
                    this.refreshCacheIfNeeded();
                    if (this.eof) {
                        return n3;
                    }
                    int n5 = Math.min(this.chars.length - this.idx, n4);
                    System.arraycopy(this.chars, this.idx, cArray, n, n5);
                    this.idx += n5;
                    n += n5;
                    n4 = n2 - (n3 += n5);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfClosed();
            if (this.eof) {
                return -1;
            }
            this.refreshCacheIfNeeded();
            if (this.eof) {
                return -1;
            }
            return this.chars[this.idx++] & 0xFF;
        }
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        this.checkIfClosed();
        int n = 0;
        try {
            if (!this.eof) {
                while ((long)n < l && this.read() != -1) {
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return n;
    }

    public void mark(int n) throws IOException {
        try {
            if (this.rbg.markSupported(this.id)) {
                this.rbg.mark(this.id, n);
                this.marked = true;
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    public void reset() throws IOException {
        if (this.marked) {
            try {
                this.rbg.reset(this.id);
                this.resetCache();
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
        } else {
            throw new IOException("Reader was not marked.");
        }
    }

    public boolean markSupported() {
        if (this.rbg == null) {
            return false;
        }
        return this.rbg.markSupported(this.id);
    }

    public boolean ready() throws IOException {
        boolean bl = false;
        try {
            bl = this.rbg.ready(this.id);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return bl;
    }

    private void refreshCacheIfNeeded() throws IOException {
        if (this.chars == null || this.idx >= this.chars.length) {
            try {
                this.chars = this.rbg.getBlock(this.id);
                this.idx = 0;
                if (this.chars == null) {
                    this.eof = true;
                }
            }
            catch (RemoteException remoteException) {
                this.resetCache();
                throw new IOException(remoteException.toString());
            }
        }
    }

    private void resetCache() {
        this.chars = null;
        this.eof = false;
        this.closed = false;
        this.idx = 0;
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Reader already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.rbg.close(this.id);
            this.eof = true;
            this.chars = null;
            this.rbg = null;
        }
    }
}

