/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import weblogic.common.ResourceException;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.common.internal.ConnectionInfo;
import weblogic.jdbc.common.internal.ConnectionPoolConfig;
import weblogic.jdbc.common.internal.DataSourceUtil;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.common.internal.VendorId;
import weblogic.management.configuration.JDBCDataSourceFactoryMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class WLSMBeanConnectionPoolConfig
implements ConnectionPoolConfig {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private JDBCConnectionPoolBean cpBean;
    private JDBCDataSourceFactoryMBean factoryMBean;
    private JDBCDataSourceBean dsBean;
    private final String name;
    private String driver = null;
    private String url = null;
    private Properties driverProperties;
    private boolean removeInfectedConn = true;
    boolean credentialMappingEnabled = false;
    private boolean oldAppScopedPool;
    private boolean pinnedToThread = false;
    private boolean createConnectionInline = false;
    private ConnectionInfo defaultConnectionInfo = null;
    private boolean onePinnedConnectionOnly = false;
    boolean identityBasedConnectionPoolingEnabled = false;
    private boolean nativeXA = false;
    private String DD_XA_TX_GROUP_NAME = "XATransactionGroup";
    private int profileType;

    public WLSMBeanConnectionPoolConfig(JDBCConnectionPoolBean jDBCConnectionPoolBean, JDBCDataSourceFactoryMBean jDBCDataSourceFactoryMBean) {
        this.cpBean = jDBCConnectionPoolBean;
        this.factoryMBean = jDBCDataSourceFactoryMBean;
        this.oldAppScopedPool = true;
        this.name = null;
    }

    public Properties getPoolProperties() throws ResourceException {
        Properties properties;
        if (JDBCUtil.JDBCInternal.isDebugEnabled()) {
            JDBCUtil.JDBCInternal.debug(" > CP(" + this.name + "):doStart (10) oldAppScopedPool = " + Boolean.toString(this.oldAppScopedPool));
        }
        try {
            properties = (Properties)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WLSMBeanConnectionPoolConfig.this.initJDBCAndGetPoolParameters();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (JDBCUtil.JDBCInternal.isDebugEnabled()) {
                JDBCUtil.JDBCInternal.debug(" <* CP(" + this.name + "):doStart(30)");
            }
            throw new ResourceException(privilegedActionException.toString());
        }
        return properties;
    }

    private Properties initJDBCAndGetPoolParameters() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (JDBCUtil.JDBCInternal.isDebugEnabled()) {
            JDBCUtil.JDBCInternal.debug(" > CP(" + this.name + "):initJDBCAndGetPoolParams (10)");
        }
        Properties properties = new Properties();
        int n2 = 0;
        String string = null;
        if (this.driverProperties == null) {
            this.driverProperties = new Properties();
        }
        if (this.cpBean != null) {
            string = this.cpBean.getDataSourceJNDIName();
            if (string != null) {
                properties.setProperty("name", string);
            }
            if ((object4 = this.cpBean.getPoolParams()) != null) {
                properties.setProperty("createDelay", Integer.toString(object4.getLoginDelaySeconds()));
                properties.setProperty("DebugLevel", Integer.toString(object4.getJDBCXADebugLevel()));
                this.removeInfectedConn = object4.isRemoveInfectedConnectionsEnabled();
                object3 = object4.getSizeParams();
                if (object3 != null) {
                    properties.setProperty("maxCapacity", Integer.toString(object3.getMaxCapacity()));
                    properties.setProperty("capacityIncrement", Integer.toString(object3.getCapacityIncrement()));
                    properties.setProperty("initialCapacity", Integer.toString(object3.getInitialCapacity()));
                    properties.setProperty("maxWaiters", Integer.toString(object3.getHighestNumWaiters()));
                    properties.setProperty("maxUnavl", Integer.toString(object3.getHighestNumUnavailable()));
                    properties.setProperty("shrinkEnabled", Boolean.toString(object3.isShrinkingEnabled()));
                    properties.setProperty("shrinkFrequencySeconds", Integer.toString(object3.getShrinkPeriodMinutes() * 60));
                    n2 = object3.getShrinkFrequencySeconds();
                    if (n2 > 0) {
                        properties.setProperty("shrinkFrequencySeconds", Integer.toString(n2));
                    }
                }
                if ((object2 = object4.getConnectionCheckParams()) != null) {
                    string = object2.getTableName();
                    if (string != null) {
                        properties.setProperty("testName", string);
                    }
                    if ((string = object2.getInitSql()) != null) {
                        properties.setProperty("initName", string);
                    }
                    properties.setProperty("testOnReserve", Boolean.toString(object2.isCheckOnReserveEnabled()));
                    properties.setProperty("testOnRelease", Boolean.toString(object2.isCheckOnReleaseEnabled()));
                    properties.setProperty("testOnCreate", Boolean.toString(object2.isCheckOnCreateEnabled()));
                    properties.setProperty("resvTimeoutSeconds", Integer.toString(object2.getConnectionReserveTimeoutSeconds()));
                    properties.setProperty("resCreationRetrySeconds", Integer.toString(object2.getConnectionCreationRetryFrequencySeconds()));
                    properties.setProperty("inactiveResTimeoutSeconds", Integer.toString(object2.getInactiveConnectionTimeoutSeconds()));
                    properties.setProperty("testFrequencySeconds", Integer.toString(object2.getRefreshMinutes() * 60));
                    n2 = object2.getTestFrequencySeconds();
                    if (n2 > 0) {
                        properties.setProperty("testFrequencySeconds", Integer.toString(n2));
                    }
                }
                if ((object = object4.getXAParams()) != null) {
                    properties.setProperty("PSCacheSize", Integer.toString(object.getPreparedStatementCacheSize()));
                }
            }
            if ((object3 = this.cpBean.getDriverParams()) != null && (object2 = object3.getPreparedStatement()) != null) {
                properties.setProperty("PSCacheSize", Integer.toString(object2.getCacheSize()));
            }
            if ((object2 = this.cpBean.getConnectionFactory()) != null && (object = object2.getConnectionProperties()) != null) {
                string = object.getUrl();
                if (string != null) {
                    properties.setProperty("Url", string);
                }
                this.driver = object.getDriverClassName();
                string = object.getUserName();
                if (string != null) {
                    this.driverProperties.put("user", string);
                }
                if ((string = object.getPassword()) != null) {
                    this.driverProperties.put("password", string);
                }
            }
        }
        if (this.factoryMBean != null) {
            if (properties.getProperty("Url") == null && (string = this.factoryMBean.getURL()) != null) {
                properties.setProperty("Url", string);
            }
            if (this.driver == null) {
                this.driver = this.factoryMBean.getDriverClassName();
            }
            if (this.driverProperties.get("user") == null && (string = this.factoryMBean.getUserName()) != null) {
                this.driverProperties.put("user", string);
            }
            if (this.driverProperties.get("password") == null && (string = this.factoryMBean.getPassword()) != null) {
                this.driverProperties.put("password", string);
            }
            if ((object4 = this.factoryMBean.getProperties()) != null) {
                this.mergeDefaultProps((Map)object4);
            }
        }
        if ((string = this.driverProperties.getProperty("password")) != null) {
            object4 = SerializedSystemIni.getEncryptionService();
            object3 = new ClearOrEncryptedService((EncryptionService)object4);
            object2 = ((ClearOrEncryptedService)object3).decrypt(string);
            this.driverProperties.setProperty("password", (String)object2);
        }
        if (DataSourceUtil.isXADataSource((String)this.driver)) {
            properties.setProperty("UseXAInterface", "true");
        }
        if (this.driver.equals("oracle.jdbc.xa.client.OracleXADataSource") && ("true".equalsIgnoreCase(this.driverProperties.getProperty("nativeXA")) || "true".equalsIgnoreCase(this.driverProperties.getProperty("NativeXA")))) {
            this.pinnedToThread = true;
            properties.setProperty("maxCapacity", Integer.toString(Integer.MAX_VALUE));
            this.createConnectionInline = true;
            properties.setProperty("capacityIncrement", "1");
            properties.setProperty("initialCapacity", "0");
            this.nativeXA = true;
        } else {
            if ("true".equalsIgnoreCase((String)this.driverProperties.remove("PinnedToThread")) || "true".equalsIgnoreCase((String)this.driverProperties.remove("pinnedToThread"))) {
                this.pinnedToThread = true;
                properties.setProperty("maxCapacity", Integer.toString(Integer.MAX_VALUE));
            }
            if ("true".equalsIgnoreCase((String)this.driverProperties.remove("CreateConnectionInline")) || "true".equalsIgnoreCase((String)this.driverProperties.remove("createConnectionInline"))) {
                this.createConnectionInline = true;
                properties.setProperty("capacityIncrement", "1");
                properties.setProperty("initialCapacity", "0");
            }
        }
        object4 = this.driverProperties.getProperty("drivername");
        if (object4 == null || (n = VendorId.get((String)object4)) == -1) {
            n = VendorId.get((String)this.driver);
        }
        if (n == 8) {
            object2 = null;
            if (this.cpBean != null) {
                object2 = this.cpBean.getDataSourceJNDIName();
            } else if (this.factoryMBean != null) {
                object2 = this.factoryMBean.getName();
            }
            object = ManagementService.getRuntimeAccess(KERNEL_ID).getDomainName() + ":" + ManagementService.getRuntimeAccess(KERNEL_ID).getServerName() + ":" + (String)object2;
            this.driverProperties.put(this.DD_XA_TX_GROUP_NAME, object);
        }
        if (JDBCUtil.JDBCInternal.isDebugEnabled()) {
            JDBCUtil.JDBCInternal.debug(" < CP(" + this.name + "):initJDBCAndGetPoolParams (100)");
        }
        return properties;
    }

    public Properties getDriverProperties() {
        return this.driverProperties;
    }

    private void mergeDefaultProps(Map map) {
        if (this.driverProperties == null) {
            this.driverProperties = new Properties();
        }
        for (Object k : map.keySet()) {
            if (this.driverProperties.containsKey(k)) continue;
            this.driverProperties.put(k, map.get(k));
        }
    }

    public void setCredentialMappingEnabled(boolean bl) {
        this.credentialMappingEnabled = bl;
    }

    public boolean isCredentialMappingEnabled() {
        return this.credentialMappingEnabled;
    }

    public boolean isPinnedToThread() {
        return this.pinnedToThread;
    }

    public boolean isCreateConnectionInline() {
        return this.createConnectionInline;
    }

    public boolean isRemoveInfectedConnectionEnabled() {
        return this.removeInfectedConn;
    }

    public ConnectionInfo getDefaultConnectionInfo() {
        return this.defaultConnectionInfo;
    }

    public String getDriver() {
        return this.driver;
    }

    public boolean isNativeXA() {
        return this.nativeXA;
    }

    public String getURL() {
        return this.url;
    }

    public boolean isOnePinnedConnectionOnly() {
        return this.onePinnedConnectionOnly;
    }

    public int getProfileType() {
        return this.profileType;
    }

    public boolean isIdentityBasedConnectionPoolingEnabled() {
        return this.identityBasedConnectionPoolingEnabled;
    }

    public int getXaRetryDurationSeconds() {
        return this.cpBean.getPoolParams().getXAParams().getXaRetryDurationSeconds();
    }

    public int getStatementTimeout() {
        return 0;
    }

    public boolean isOracleEnableJavaNetFastPath() {
        return false;
    }

    public boolean isOracleOptimizeUtf8Conversion() {
        return false;
    }

    public boolean isWrapTypes() {
        return false;
    }

    public void setJDBCDataSourceBean(JDBCDataSourceBean jDBCDataSourceBean) {
        this.dsBean = jDBCDataSourceBean;
    }
}

