/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCStoreMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;

public class JDBCConfigurationProcessor
implements ConfigurationProcessor {
    JDBCDeploymentHelper helper = new JDBCDeploymentHelper();

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        JDBCSystemResourceMBean jDBCSystemResourceMBean = null;
        try {
            JDBCDataSourceMBean[] jDBCDataSourceMBeanArray;
            JDBCMultiPoolMBean[] jDBCMultiPoolMBeanArray;
            int n;
            JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = domainMBean.getJDBCConnectionPools();
            if (jDBCConnectionPoolMBeanArray != null) {
                for (n = 0; n < jDBCConnectionPoolMBeanArray.length; ++n) {
                    jDBCSystemResourceMBean = this.helper.createJDBCSystemResource(jDBCConnectionPoolMBeanArray[n], 1, domainMBean);
                    jDBCSystemResourceMBean.setTargets(jDBCConnectionPoolMBeanArray[n].getTargets());
                    this.fixJDBCConnectionPoolReferences(domainMBean, jDBCConnectionPoolMBeanArray[n], jDBCSystemResourceMBean);
                    domainMBean.destroyJDBCConnectionPool(jDBCConnectionPoolMBeanArray[n]);
                }
            }
            if ((jDBCMultiPoolMBeanArray = domainMBean.getJDBCMultiPools()) != null) {
                for (n = 0; n < jDBCMultiPoolMBeanArray.length; ++n) {
                    jDBCSystemResourceMBean = this.helper.createJDBCSystemResource(jDBCMultiPoolMBeanArray[n], 2, domainMBean);
                    jDBCSystemResourceMBean.setTargets(jDBCMultiPoolMBeanArray[n].getTargets());
                    domainMBean.destroyJDBCMultiPool(jDBCMultiPoolMBeanArray[n]);
                }
            }
            if ((jDBCDataSourceMBeanArray = domainMBean.getJDBCDataSources()) != null) {
                for (n = 0; n < jDBCDataSourceMBeanArray.length; ++n) {
                    jDBCSystemResourceMBean = this.helper.createJDBCSystemResource(jDBCDataSourceMBeanArray[n], 3, domainMBean);
                    jDBCSystemResourceMBean.setTargets(jDBCDataSourceMBeanArray[n].getTargets());
                    domainMBean.destroyJDBCDataSource(jDBCDataSourceMBeanArray[n]);
                }
            }
            JDBCTxDataSourceMBean[] jDBCTxDataSourceMBeanArray = domainMBean.getJDBCTxDataSources();
            if (jDBCDataSourceMBeanArray != null) {
                for (n = 0; n < jDBCTxDataSourceMBeanArray.length; ++n) {
                    jDBCSystemResourceMBean = this.helper.createJDBCSystemResource(jDBCTxDataSourceMBeanArray[n], 4, domainMBean);
                    jDBCSystemResourceMBean.setTargets(jDBCTxDataSourceMBeanArray[n].getTargets());
                    domainMBean.destroyJDBCTxDataSource(jDBCTxDataSourceMBeanArray[n]);
                }
            }
        }
        catch (Exception exception) {
            throw new UpdateException(exception.getMessage());
        }
    }

    private void fixJDBCConnectionPoolReferences(DomainMBean domainMBean, JDBCConnectionPoolMBean jDBCConnectionPoolMBean, JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCStoreMBean[] jDBCStoreMBeanArray = domainMBean.getJDBCStores();
        if (jDBCStoreMBeanArray != null) {
            JDBCConnectionPoolMBean jDBCConnectionPoolMBean2 = null;
            for (int i = 0; i < jDBCStoreMBeanArray.length; ++i) {
                jDBCConnectionPoolMBean2 = jDBCStoreMBeanArray[i].getConnectionPool();
                if (jDBCConnectionPoolMBean2 == null || !jDBCConnectionPoolMBean2.getName().equals(jDBCConnectionPoolMBean.getName())) continue;
                try {
                    jDBCStoreMBeanArray[i].setDataSource(jDBCSystemResourceMBean);
                    jDBCStoreMBeanArray[i].setConnectionPool(null);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

