/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;
import javax.sql.DataSource;
import weblogic.common.ResourceException;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.jdbc.module.LocalDataSource;
import weblogic.management.configuration.JDBCDataSourceFactoryMBean;

public class JDBCDataSourceFactory {
    private static JDBCDataSourceFactory defaultFactory = new JDBCDataSourceFactory();
    private static Map factoryMap = new Hashtable();
    private JDBCDataSourceFactoryMBean mbean;

    private JDBCDataSourceFactory() {
    }

    private JDBCDataSourceFactory(JDBCDataSourceFactoryMBean jDBCDataSourceFactoryMBean) {
        this.mbean = jDBCDataSourceFactoryMBean;
    }

    public static void addDataSourceFactory(JDBCDataSourceFactoryMBean jDBCDataSourceFactoryMBean) {
        JDBCDataSourceFactory jDBCDataSourceFactory = new JDBCDataSourceFactory(jDBCDataSourceFactoryMBean);
        factoryMap.put(jDBCDataSourceFactoryMBean.getFactoryName(), jDBCDataSourceFactory);
    }

    public static JDBCDataSourceFactory getDataSourceFactory() {
        return JDBCDataSourceFactory.getDataSourceFactory(null);
    }

    public static JDBCDataSourceFactory getDataSourceFactory(String string) {
        if (string == null) {
            return defaultFactory;
        }
        return (JDBCDataSourceFactory)factoryMap.get(string);
    }

    public DataSource createDataSource(String string, String string2, JDBCConnectionPoolBean jDBCConnectionPoolBean) throws ResourceException {
        LocalDataSource localDataSource = null;
        try {
            localDataSource = new LocalDataSource(jDBCConnectionPoolBean, string, string2, this.mbean);
        }
        catch (SQLException sQLException) {
            throw new ResourceException(sQLException.getMessage());
        }
        return localDataSource;
    }
}

