/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.io.File;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.internal.SingleModuleDeployment;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.jdbc.module.JDBCModule;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.SystemResourceMBean;

public final class JDBCDeployment
extends SingleModuleDeployment
implements Deployment {
    public JDBCDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        super(appDeploymentMBean, JDBCDeployment.createModule(appDeploymentMBean), file);
    }

    public JDBCDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        super(systemResourceMBean, JDBCDeployment.createModule(systemResourceMBean), file);
    }

    private static Module createModule(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        ComponentMBean[] componentMBeanArray = appDeploymentMBean.getAppMBean().getComponents();
        if (componentMBeanArray == null || componentMBeanArray.length == 0) {
            throw new DeploymentException("Application " + ApplicationVersionUtils.getDisplayName(appDeploymentMBean) + " does not have any Components in it.");
        }
        if (componentMBeanArray.length > 1) {
            throw new DeploymentException("Application" + ApplicationVersionUtils.getDisplayName(appDeploymentMBean) + " is a DAR file, but it contains > 1 component.");
        }
        return new JDBCModule(componentMBeanArray[0].getURI());
    }

    private static Module createModule(SystemResourceMBean systemResourceMBean) throws DeploymentException {
        String string = systemResourceMBean.getDescriptorFileName();
        if (string == null) {
            throw new DeploymentException("JDBCSystemResource " + ApplicationVersionUtils.getDisplayName(systemResourceMBean) + " does not have a descriptor file name");
        }
        return new JDBCModule(string);
    }
}

