/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.io.File;
import java.io.IOException;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.jdbc.module.JDBCDeployment;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.SystemResourceMBean;

public final class JDBCDeploymentFactory
implements DeploymentFactory {
    private boolean isJDBC(File file) throws IOException {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith("-jdbc.xml");
    }

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        try {
            return this.isJDBC(file) ? new JDBCDeployment(appDeploymentMBean, file) : null;
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        return systemResourceMBean instanceof JDBCSystemResourceMBean ? new JDBCDeployment(systemResourceMBean, file) : null;
    }
}

