/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.utils.classloaders.GenericClassLoader;

public class JDBCDeploymentHelper {
    private String uri = null;
    private AbstractDescriptorLoader2 jdbcDescriptor = null;
    private String appName = null;
    private String jdbcFileName;
    private final boolean debug = false;

    public JDBCDataSourceBean createJDBCDataSourceDescriptor(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) throws ModuleException {
        try {
            this.jdbcDescriptor = JDBCDeploymentHelper.createDescriptorLoader(inputStream, descriptorManager, list, bl);
            return this.getJDBCDataSourceBean();
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JDBCDataSourceBean createJDBCDataSourceDescriptor(String string) throws ModuleException {
        JDBCDataSourceBean jDBCDataSourceBean;
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        FileInputStream fileInputStream = null;
        try {
            try {
                this.jdbcDescriptor = JDBCDeploymentHelper.createDescriptorLoader(new File(string), null, null, null, string);
                jDBCDataSourceBean = this.getJDBCDataSourceBean();
                Object var5_5 = null;
            }
            catch (Exception exception) {
                throw new ModuleException(exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return jDBCDataSourceBean;
        }
        fileInputStream.close();
        return jDBCDataSourceBean;
    }

    public JDBCDataSourceBean createJDBCDataSourceDescriptor(ApplicationContextInternal applicationContextInternal, String string) throws ModuleException {
        this.uri = string;
        DeploymentPlanBean deploymentPlanBean = null;
        File file = null;
        if (string == null) {
            throw new ModuleException("Null URI specified");
        }
        AppDeploymentMBean appDeploymentMBean = applicationContextInternal.getAppDeploymentMBean();
        String string2 = null;
        String string3 = null;
        if (appDeploymentMBean != null) {
            deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
            if (appDeploymentMBean.getPlanDir() != null) {
                file = new File(appDeploymentMBean.getLocalPlanDir());
            }
            this.appName = appDeploymentMBean.getName();
            string2 = this.getModuleName(appDeploymentMBean, string);
            string3 = this.getModuleUri(appDeploymentMBean, string);
        }
        File file2 = null;
        String string4 = this.getCanonicalPath(applicationContextInternal, string);
        if (string4 != null) {
            file2 = new File(string4);
        }
        this.jdbcDescriptor = JDBCDeploymentHelper.createDescriptorLoader(file2, file, deploymentPlanBean, string2, string3);
        try {
            return this.getJDBCDataSourceBean();
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    private String getModuleUri(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null && appDeploymentMBean.getSourcePath().endsWith(".xml")) {
            return ".";
        }
        return string;
    }

    private String getModuleName(AppDeploymentMBean appDeploymentMBean, String string) {
        if (appDeploymentMBean.getSourcePath() != null) {
            return new File(appDeploymentMBean.getSourcePath()).getName();
        }
        return string;
    }

    public JDBCDataSourceBean createJDBCDataSourceDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        this.jdbcDescriptor = JDBCDeploymentHelper.createDescriptorLoader(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2);
        return this.getJDBCDataSourceBean();
    }

    public JDBCDataSourceBean createJDBCDataSourceDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) throws IOException, XMLStreamException {
        this.jdbcDescriptor = JDBCDeploymentHelper.createDescriptorLoader(file, file2, deploymentPlanBean, string, string2);
        return this.getJDBCDataSourceBean();
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(file, file2, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JDBCDeploymentHelper.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
        return new AbstractDescriptorLoader2(descriptorManager, genericClassLoader, file, deploymentPlanBean, string, string2){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JDBCDeploymentHelper.createVersionMunger(inputStream, this);
            }
        };
    }

    private static AbstractDescriptorLoader2 createDescriptorLoader(InputStream inputStream, DescriptorManager descriptorManager, List list, boolean bl) {
        return new AbstractDescriptorLoader2(inputStream, descriptorManager, list, bl){

            protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
                return JDBCDeploymentHelper.createVersionMunger(inputStream, this);
            }
        };
    }

    private static VersionMunger createVersionMunger(InputStream inputStream, AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
        String string = "weblogic.j2ee.descriptor.wl.JDBCDataSourceBeanImpl$SchemaHelper2";
        return new VersionMunger(inputStream, abstractDescriptorLoader2, string, "http://xmlns.oracle.com/weblogic/jdbc-data-source");
    }

    public String getCanonicalPath(ApplicationContextInternal applicationContextInternal, String string) throws ModuleException {
        if (applicationContextInternal.isEar()) {
            File[] fileArray = applicationContextInternal.getEar().getModuleRoots(string);
            if (fileArray.length == 0) {
                return null;
            }
            File file = fileArray[0];
            return file.getAbsolutePath().replace(File.separatorChar, '/');
        }
        return applicationContextInternal.getStagingPath();
    }

    public JDBCDataSourceBean getJDBCDataSourceBean() throws IOException, XMLStreamException {
        return (JDBCDataSourceBean)this.jdbcDescriptor.loadDescriptorBean();
    }

    public JDBCSystemResourceMBean createJDBCSystemResource(DeploymentMBean deploymentMBean, int n, DomainMBean domainMBean) throws Exception {
        String string = JDBCDeploymentHelper.getSystemResourceName(deploymentMBean.getName(), n);
        if (domainMBean.lookupJDBCSystemResource(string) != null) {
            return null;
        }
        JDBCSystemResourceMBean jDBCSystemResourceMBean = domainMBean.createJDBCSystemResource(string);
        jDBCSystemResourceMBean.setDeploymentOrder(n);
        JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
        if (n == 1) {
            JDBCMBeanConverter.getJDBCDataSourceDescriptor((JDBCConnectionPoolMBean)deploymentMBean, jDBCDataSourceBean);
        } else if (n == 2) {
            JDBCMBeanConverter.getJDBCDataSourceDescriptor((JDBCMultiPoolMBean)deploymentMBean, jDBCDataSourceBean);
        } else if (n == 3) {
            JDBCMBeanConverter.getJDBCDataSourceDescriptor((JDBCDataSourceMBean)deploymentMBean, jDBCDataSourceBean);
        } else if (n == 4) {
            JDBCMBeanConverter.getJDBCDataSourceDescriptor((JDBCTxDataSourceMBean)deploymentMBean, jDBCDataSourceBean, domainMBean);
        }
        return jDBCSystemResourceMBean;
    }

    public static String getSystemResourceName(String string, int n) {
        if (n == 1) {
            return new String("CP-" + string);
        }
        if (n == 2) {
            return new String("MP-" + string);
        }
        if (n == 3) {
            return new String("DS-" + string);
        }
        if (n == 4) {
            return new String("TxDS-" + string);
        }
        return new String("");
    }

    public static void writeModuleAsXML(DescriptorBean descriptorBean) {
        Descriptor descriptor = descriptorBean.getDescriptor();
        try {
            EditableDescriptorManager editableDescriptorManager = new EditableDescriptorManager();
            editableDescriptorManager.writeDescriptorAsXML(descriptor, (OutputStream)new BufferedOutputStream(System.out){

                public void close() {
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            JDBCDeploymentHelper.usage();
        }
        System.out.println("\n\n... getting InterceptionBean:");
        ((DescriptorBean)new JDBCDeploymentHelper().createJDBCDataSourceDescriptor(stringArray[0])).getDescriptor().toXML((OutputStream)System.out);
    }

    private static void usage() {
        System.err.println("usage: java weblogic.jdbc.module.JDBCDeploymentHelper <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.jdbc.module.JDBCDeploymentHelper sample.xml");
        System.exit(0);
    }
}

