/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.management.provider.AccessCallback;

public class JDBCEditCompatibilityObserver
implements AccessCallback,
PropertyChangeListener {
    DomainMBean domainTree;
    JDBCDeploymentHelper helper;

    public void accessed(DomainMBean domainMBean) {
        this.domainTree = domainMBean;
        this.helper = new JDBCDeploymentHelper();
        this.updateConfiguration(domainMBean);
        this.domainTree.addPropertyChangeListener(this);
    }

    public void shutdown() {
        this.domainTree.removePropertyChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.JDBCProperty(propertyChangeEvent.getPropertyName())) {
            this.applyChanges((Object[])propertyChangeEvent.getOldValue(), (Object[])propertyChangeEvent.getNewValue());
        }
    }

    private boolean JDBCProperty(String string) {
        return string.equals("JDBCConnectionPools") || string.equals("JDBCMultiPools") || string.equals("JDBCDataSources") || string.equals("JDBCTxDataSources") || string.equals("JDBCSystemResources");
    }

    private void applyChanges(Object[] objectArray, Object[] objectArray2) {
        Object object;
        int n;
        Object[] objectArray3 = (Object[])objectArray2.clone();
        for (n = 0; n < objectArray.length; ++n) {
            int n2;
            object = objectArray[n];
            for (n2 = 0; n2 < objectArray3.length; ++n2) {
                Object object2 = objectArray2[n2];
                if (object2 == null || !object2.equals(object)) continue;
                objectArray3[n2] = null;
                break;
            }
            if (n2 != objectArray3.length) continue;
            this.removeBean(object);
        }
        for (n = 0; n < objectArray3.length; ++n) {
            object = objectArray3[n];
            if (object == null) continue;
            this.addBean(object);
        }
    }

    private void addBean(Object object) {
        if (object instanceof JDBCSystemResourceMBean) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = (JDBCSystemResourceMBean)object;
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
            String string = null;
            if (jDBCDataSourceBean != null) {
                string = jDBCDataSourceBean.getName();
            }
            if (string == null) {
                return;
            }
            int n = JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean);
            if (n == 1) {
                if (this.domainTree.lookupJDBCConnectionPool(string) == null) {
                    this.domainTree.createJDBCConnectionPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
            } else if (n == 2) {
                if (this.domainTree.lookupJDBCMultiPool(string) == null) {
                    this.domainTree.createJDBCMultiPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
            } else if (n == 3) {
                if (this.domainTree.lookupJDBCDataSource(string) == null) {
                    this.domainTree.createJDBCDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
            } else if (n == 4) {
                if (this.domainTree.lookupJDBCTxDataSource(string) == null) {
                    this.domainTree.createJDBCTxDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
            } else if (n == 0) {
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null) {
                    if (this.domainTree.lookupJDBCMultiPool(string) == null) {
                        this.domainTree.createJDBCMultiPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    }
                } else if (this.domainTree.lookupJDBCConnectionPool(string) == null) {
                    this.domainTree.createJDBCConnectionPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("None")) {
                    if (this.domainTree.lookupJDBCDataSource(string) == null) {
                        this.domainTree.createJDBCDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    }
                } else if (this.domainTree.lookupJDBCTxDataSource(string) == null) {
                    this.domainTree.createJDBCTxDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
            }
        } else {
            Object object2;
            block48: {
                try {
                    String string = ((DeploymentMBean)object).getName();
                    object2 = this.domainTree.getJDBCSystemResources();
                    if (object2 == null) break block48;
                    for (int i = 0; i < ((JDBCSystemResourceMBean[])object2).length; ++i) {
                        try {
                            if (!string.equals(object2[i].getJDBCResource().getName())) continue;
                            return;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            int n = 0;
            if (object instanceof JDBCConnectionPoolMBean) {
                n = 1;
            } else if (object instanceof JDBCMultiPoolMBean) {
                n = 2;
            } else if (object instanceof JDBCDataSourceMBean) {
                n = 3;
            } else if (object instanceof JDBCTxDataSourceMBean) {
                n = 4;
            }
            try {
                if (this.domainTree.lookupJDBCSystemResource(((DeploymentMBean)object).getName()) != null) {
                    return;
                }
                object2 = this.helper.createJDBCSystemResource((DeploymentMBean)object, n, this.domainTree);
                if (object2 == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            if (n == 1) {
                ((JDBCConnectionPoolMBean)object).setJDBCSystemResource((JDBCSystemResourceMBean)object2);
            } else if (n == 2) {
                ((JDBCMultiPoolMBean)object).setJDBCSystemResource((JDBCSystemResourceMBean)object2);
            } else if (n == 3) {
                ((JDBCDataSourceMBean)object).setJDBCSystemResource((JDBCSystemResourceMBean)object2);
            } else if (n == 4) {
                ((JDBCTxDataSourceMBean)object).setJDBCSystemResource((JDBCSystemResourceMBean)object2);
            }
        }
    }

    private void removeBean(Object object) {
        if (object instanceof JDBCSystemResourceMBean) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = (JDBCSystemResourceMBean)object;
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
            if (jDBCDataSourceBean == null) {
                return;
            }
            String string = jDBCDataSourceBean.getName();
            if (string == null) {
                return;
            }
            int n = JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean);
            if (n == 1) {
                if (this.domainTree.lookupJDBCConnectionPool(string) != null) {
                    this.domainTree.destroyJDBCConnectionPool(this.domainTree.lookupJDBCConnectionPool(string));
                }
            } else if (n == 2) {
                if (this.domainTree.lookupJDBCMultiPool(string) != null) {
                    this.domainTree.destroyJDBCMultiPool(this.domainTree.lookupJDBCMultiPool(string));
                }
            } else if (n == 3) {
                if (this.domainTree.lookupJDBCDataSource(string) != null) {
                    this.domainTree.destroyJDBCDataSource(this.domainTree.lookupJDBCDataSource(string));
                }
            } else if (n == 4) {
                if (this.domainTree.lookupJDBCTxDataSource(string) != null) {
                    this.domainTree.destroyJDBCTxDataSource(this.domainTree.lookupJDBCTxDataSource(string));
                }
            } else if (n == 0) {
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null) {
                    if (this.domainTree.lookupJDBCMultiPool(string) != null) {
                        this.domainTree.destroyJDBCMultiPool(this.domainTree.lookupJDBCMultiPool(string));
                    }
                } else if (this.domainTree.lookupJDBCConnectionPool(string) != null) {
                    this.domainTree.destroyJDBCConnectionPool(this.domainTree.lookupJDBCConnectionPool(string));
                }
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("None")) {
                    if (this.domainTree.lookupJDBCDataSource(string) != null) {
                        this.domainTree.destroyJDBCDataSource(this.domainTree.lookupJDBCDataSource(string));
                    }
                } else if (this.domainTree.lookupJDBCTxDataSource(string) != null) {
                    this.domainTree.destroyJDBCTxDataSource(this.domainTree.lookupJDBCTxDataSource(string));
                }
            }
        } else if (object instanceof JDBCConnectionPoolMBean) {
            this.domainTree.destroyJDBCSystemResource(((JDBCConnectionPoolMBean)object).getJDBCSystemResource());
        } else if (object instanceof JDBCMultiPoolMBean) {
            this.domainTree.destroyJDBCSystemResource(((JDBCMultiPoolMBean)object).getJDBCSystemResource());
        } else if (object instanceof JDBCDataSourceMBean) {
            this.domainTree.destroyJDBCSystemResource(((JDBCDataSourceMBean)object).getJDBCSystemResource());
        } else if (object instanceof JDBCTxDataSourceMBean) {
            this.domainTree.destroyJDBCSystemResource(((JDBCTxDataSourceMBean)object).getJDBCSystemResource());
        }
    }

    private void updateConfiguration(DomainMBean domainMBean) {
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = domainMBean.getJDBCSystemResources();
        if (jDBCSystemResourceMBeanArray != null) {
            for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                String string;
                JDBCSystemResourceMBean jDBCSystemResourceMBean = jDBCSystemResourceMBeanArray[i];
                JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBean.getJDBCResource();
                if (jDBCDataSourceBean == null || (string = jDBCDataSourceBean.getName()) == null) continue;
                int n = JDBCMBeanConverter.getLegacyType(jDBCDataSourceBean);
                if (n == 1) {
                    if (domainMBean.lookupJDBCConnectionPool(string) != null) continue;
                    domainMBean.createJDBCConnectionPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    continue;
                }
                if (n == 2) {
                    if (domainMBean.lookupJDBCMultiPool(string) != null) continue;
                    domainMBean.createJDBCMultiPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    continue;
                }
                if (n == 3) {
                    if (domainMBean.lookupJDBCDataSource(string) != null) continue;
                    domainMBean.createJDBCDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    continue;
                }
                if (n == 4) {
                    if (domainMBean.lookupJDBCTxDataSource(string) != null) continue;
                    domainMBean.createJDBCTxDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    continue;
                }
                if (n != 0) continue;
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null) {
                    if (domainMBean.lookupJDBCMultiPool(string) == null) {
                        domainMBean.createJDBCMultiPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    }
                } else if (domainMBean.lookupJDBCConnectionPool(string) == null) {
                    domainMBean.createJDBCConnectionPool(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                }
                if (jDBCDataSourceBean.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("None")) {
                    if (domainMBean.lookupJDBCDataSource(string) != null) continue;
                    domainMBean.createJDBCDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
                    continue;
                }
                if (domainMBean.lookupJDBCTxDataSource(string) != null) continue;
                domainMBean.createJDBCTxDataSource(string).setJDBCSystemResource(jDBCSystemResourceMBean);
            }
        }
    }
}

