/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.ModuleLocationInfo;
import weblogic.application.NonDynamicPropertyUpdateException;
import weblogic.application.UpdateListener;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.common.ResourceException;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.event.DeploymentVetoException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.ConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ConnectionPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCDriverParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCOracleParamsBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ConnectionPoolManager;
import weblogic.jdbc.common.internal.DataSourceManager;
import weblogic.jdbc.common.internal.HAConnectionPool;
import weblogic.jdbc.common.internal.JDBCHelper;
import weblogic.jdbc.common.internal.JDBCMBeanConverter;
import weblogic.jdbc.common.internal.JDBCService;
import weblogic.jdbc.common.internal.MultiPool;
import weblogic.jdbc.module.JDBCDataSourceFactory;
import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.jdbc.module.LocalDataSource;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.FileUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public class JDBCModule
implements Module,
UpdateListener,
ModuleLocationInfo {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ApplicationContextInternal appCtx;
    private Context envCtx;
    private String appName;
    private String moduleName;
    private DataSource dataSource;
    private boolean bound = false;
    private final String uri;
    private ConnectionPoolManager cpMgr;
    private DataSourceManager dsMgr;
    private JDBCDeploymentHelper deploymentHelper;
    private ConnectionPool pool = null;
    private MultiPool multipool = null;
    private ComponentRuntimeMBean compRTMB;
    private int legacyType;
    private JDBCConnectionPoolBean descriptor;
    private boolean oldAppScopedPool;
    private JDBCDataSourceBean dsBean;
    private final int BEAN_TYPE_PROPERTIES = 100;
    private final int BEAN_TYPE_PROPERTY = 101;
    private final int BEAN_TYPE_ORACLE = 102;
    private int COMMIT_CHANGE = 0;
    private int ROLLBACK_CHANGE = 1;
    private String altDD = null;
    private static final String DEFAULT_APPENDIX = "-jdbc.xml";

    public JDBCModule(String string) {
        this.uri = string;
        this.deploymentHelper = new JDBCDeploymentHelper();
    }

    public JDBCModule(WeblogicModuleBean weblogicModuleBean) {
        this(weblogicModuleBean.getPath());
        this.moduleName = weblogicModuleBean.getName();
    }

    public JDBCModule(JDBCConnectionPoolBean jDBCConnectionPoolBean, String string) {
        this(string);
        this.descriptor = jDBCConnectionPoolBean;
        this.oldAppScopedPool = true;
    }

    public String getId() {
        if (this.moduleName != null) {
            return this.moduleName;
        }
        return this.uri;
    }

    public String getModuleURI() {
        return this.uri;
    }

    public String getType() {
        return WebLogicModuleType.MODULETYPE_JDBC;
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return new ComponentRuntimeMBean[]{this.compRTMB};
    }

    public DescriptorBean[] getDescriptors() {
        if (this.descriptor != null) {
            return new DescriptorBean[]{(DescriptorBean)this.descriptor};
        }
        if (this.dsBean != null) {
            return new DescriptorBean[]{(DescriptorBean)this.dsBean};
        }
        return new DescriptorBean[0];
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.init(applicationContext, genericClassLoader, registration);
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.appCtx = (ApplicationContextInternal)applicationContext;
        String string = applicationContext.getApplicationId();
        this.envCtx = applicationContext.getEnvContext();
        try {
            this.envCtx.lookup("/jdbc");
        }
        catch (NameNotFoundException nameNotFoundException) {
            try {
                this.envCtx.createSubcontext("jdbc");
            }
            catch (NamingException namingException) {
                throw new AssertionError((Object)namingException);
            }
        }
        catch (NamingException namingException) {
            throw new AssertionError((Object)namingException);
        }
        if (!this.oldAppScopedPool) {
            if (!this.uri.endsWith(DEFAULT_APPENDIX)) {
                throw new ModuleException("Data source descriptor filename " + this.uri + " does not have the required suffix \"-jdbc.xml\"");
            }
            this.dsBean = this.deploymentHelper.createJDBCDataSourceDescriptor(this.appCtx, this.uri);
            if (this.dsBean == null) {
                throw new ModuleException("Descriptor " + this.uri + " not found.");
            }
            this.legacyType = JDBCMBeanConverter.getLegacyType(this.dsBean);
            if (this.legacyType == 0 && JDBCMBeanConverter.getInternalProperty(this.dsBean, "LegacyPoolName") != null) {
                throw new ModuleException("Cannot specify pool name for data source " + this.dsBean.getName() + ", URI = " + this.uri);
            }
            if (this.moduleName == null && !this.dsBean.getJDBCDataSourceParams().getScope().equals("Global")) {
                JDBCLogger.logInvalidApplicationScope((String)this.dsBean.getName(), (String)this.uri);
                this.dsBean.getJDBCDataSourceParams().setScope("Global");
            }
            String string2 = ApplicationVersionUtils.getVersionId(string);
            if ("Global".equals(this.dsBean.getJDBCDataSourceParams().getScope())) {
                if (string2 != null) {
                    throw new ModuleException("An application-scoped data source (" + this.dsBean.getName() + ") cannot specify a scope of Global when application is versioned (" + string + ")");
                }
            } else {
                this.appName = string;
            }
            registration.addUpdateListener(this);
            this.cpMgr = JDBCService.getConnectionPoolManager();
            this.dsMgr = JDBCService.getDataSourceManager();
        } else {
            this.appName = string;
        }
        return genericClassLoader;
    }

    public void start() {
    }

    public void prepare() throws ModuleException {
        if (this.oldAppScopedPool) {
            ConnectionFactoryBean connectionFactoryBean = this.descriptor.getConnectionFactory();
            try {
                if (this.dataSource == null) {
                    if (connectionFactoryBean == null) {
                        JDBCDataSourceFactory jDBCDataSourceFactory = JDBCDataSourceFactory.getDataSourceFactory();
                        this.dataSource = jDBCDataSourceFactory.createDataSource(this.appName, this.moduleName, this.descriptor);
                    } else {
                        String string = connectionFactoryBean.getFactoryName();
                        ConnectionPropertiesBean connectionPropertiesBean = connectionFactoryBean.getConnectionProperties();
                        if (string == null && connectionPropertiesBean == null) {
                            throw new ModuleException("Connection factory must have factory name or connection properties defined");
                        }
                        JDBCDataSourceFactory jDBCDataSourceFactory = JDBCDataSourceFactory.getDataSourceFactory(string);
                        if (jDBCDataSourceFactory == null) {
                            throw new ModuleException("Could not find DataSourceFactory named " + string);
                        }
                        this.dataSource = jDBCDataSourceFactory.createDataSource(this.appName, this.moduleName, this.descriptor);
                    }
                }
            }
            catch (ResourceException resourceException) {
                throw new ModuleException(resourceException.toString(), (Throwable)((Object)resourceException));
            }
            catch (ModuleException moduleException) {
                throw moduleException;
            }
            catch (Throwable throwable) {
                JDBCLogger.logStackTrace((Throwable)throwable);
                throw new ModuleException(throwable.toString());
            }
            this.bindDataSource();
        } else {
            boolean bl = JDBCModule.isMemberDSOfMultiDataSource(this.dsBean.getName(), this.appCtx);
            boolean bl2 = JDBCModule.isMemberOfMultiDataSourceLLR(this.dsBean.getName(), this.appCtx);
            try {
                JDBCDataSourceBean[] jDBCDataSourceBeanArray;
                if (this.legacyType == 0 || this.legacyType == 1 || this.legacyType == 2) {
                    jDBCDataSourceBeanArray = this.cpMgr.createAndStartPool(this.dsBean, this.appName, this.moduleName, bl, bl2);
                    if (jDBCDataSourceBeanArray instanceof HAConnectionPool) {
                        this.pool = (HAConnectionPool)jDBCDataSourceBeanArray;
                        this.compRTMB = JDBCService.createHADataSourceRuntimeMBean((HAConnectionPool)this.pool, this.pool.getAppName(), this.pool.getModuleName(), this.pool.getJDBCDataSource());
                    } else if (jDBCDataSourceBeanArray instanceof ConnectionPool) {
                        this.pool = (ConnectionPool)jDBCDataSourceBeanArray;
                        this.pool.suspend(false);
                        JDBCService.createConnectionPoolRuntimeMBean(this.pool, this.pool.getAppName(), this.pool.getModuleName());
                        this.compRTMB = JDBCService.createDataSourceRuntimeMBean(this.pool, this.pool.getAppName(), this.pool.getModuleName(), this.pool.getJDBCDataSource());
                    } else {
                        this.multipool = (MultiPool)jDBCDataSourceBeanArray;
                        this.compRTMB = JDBCService.createJDBCMultiDataSourceRuntimeMBean(this.multipool, this.appName, this.moduleName);
                        if (!"Global".equals(this.dsBean.getJDBCDataSourceParams().getScope())) {
                            this.multipool.setModuleNames(JDBCModule.getCPModuleNames(this.dsBean));
                        }
                        this.multipool.suspend(false);
                    }
                }
                if (this.legacyType == 0 || this.legacyType == 3 || this.legacyType == 4) {
                    jDBCDataSourceBeanArray = this.getPoolBeans(this.dsBean, this.appCtx);
                    this.dsMgr.checkDataSource(this.dsBean, this.appName, this.moduleName, jDBCDataSourceBeanArray);
                }
            }
            catch (Exception exception) {
                try {
                    if (this.dsBean != null) {
                        this.cpMgr.shutdownAndDestroyPool(this.dsBean, this.appName, this.moduleName);
                        this.unregisterMBeans(this.dsBean);
                    }
                }
                catch (Exception exception2) {
                    JDBCLogger.logStackTrace((Throwable)exception2);
                }
                throw new ModuleException(exception);
            }
        }
    }

    private void unregisterMBeans(JDBCDataSourceBean jDBCDataSourceBean) throws ManagementException, ResourceException {
        if (jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null) {
            JDBCService.destroyMultiDataSourceRuntimeMBean(this.appName, this.moduleName, jDBCDataSourceBean.getName());
        } else {
            JDBCService.destroyConnectionPoolRuntimeMBean(this.appName, this.moduleName, jDBCDataSourceBean.getName());
            JDBCService.destroyDataSourceRuntimeMBean(jDBCDataSourceBean.getJDBCDriverParams().getDriverName(), this.appName, this.moduleName, jDBCDataSourceBean.getName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void activate() throws IllegalStateException, ModuleException {
        if (this.oldAppScopedPool) {
            if (!(this.dataSource instanceof LocalDataSource)) return;
            try {
                ConnectionPool connectionPool = ((LocalDataSource)this.dataSource).getPoolRef();
                if (connectionPool == null) return;
                connectionPool.activate();
                JDBCService.createConnectionPoolRuntimeMBean(connectionPool, connectionPool.getAppName(), connectionPool.getModuleName());
                this.compRTMB = JDBCService.createDataSourceRuntimeMBean(connectionPool, connectionPool.getAppName(), connectionPool.getModuleName(), connectionPool.getJDBCDataSource());
                return;
            }
            catch (ResourceException resourceException) {
                throw new ModuleException((Throwable)((Object)resourceException));
            }
            catch (ManagementException managementException) {
                throw new ModuleException(managementException);
            }
        }
        boolean bl = JDBCModule.isMemberDSOfMultiDataSource(this.dsBean.getName(), this.appCtx);
        try {
            if (this.pool != null) {
                this.pool.resume();
            } else if (this.multipool != null) {
                this.multipool.setupConnPoolRefs();
                this.multipool.resume();
            }
            if (this.legacyType != 0 && this.legacyType != 3 && this.legacyType != 4) return;
            JDBCDataSourceBean[] jDBCDataSourceBeanArray = this.getPoolBeans(this.dsBean, this.appCtx);
            this.dsMgr.createAndStartDataSource(this.dsBean, this.appName, this.moduleName, this.appCtx.getEnvContext(), jDBCDataSourceBeanArray, bl);
            return;
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deactivate() throws IllegalStateException, ModuleException {
        if (this.oldAppScopedPool) {
            if (!(this.dataSource instanceof LocalDataSource)) return;
            try {
                ConnectionPool connectionPool = ((LocalDataSource)this.dataSource).getPoolRef();
                if (connectionPool == null) return;
                connectionPool.deactivate();
                JDBCService.destroyConnectionPoolRuntimeMBean(this.appName, this.moduleName, connectionPool.getName());
                JDBCService.destroyDataSourceRuntimeMBean(connectionPool.getDriverVersion(), this.appName, this.moduleName, connectionPool.getName());
                return;
            }
            catch (ResourceException resourceException) {
                throw new ModuleException((Throwable)((Object)resourceException));
            }
            catch (ManagementException managementException) {
                throw new ModuleException(managementException);
            }
        }
        try {
            if (this.legacyType == 0 || this.legacyType == 3 || this.legacyType == 4) {
                this.dsMgr.shutdownAndDestroyDataSource(this.dsBean, this.appName, this.moduleName);
            }
            if (this.pool != null) {
                JDBCService.destroyDataSourceRuntimeMBean(this.pool.getDriverVersion(), this.pool.getAppName(), this.pool.getModuleName(), this.pool.getName());
                if (T3Srvr.getT3Srvr().getState().equals("FORCE_SHUTTING_DOWN")) {
                    this.pool.forceSuspend(true);
                    return;
                } else {
                    this.pool.suspend(false);
                }
                return;
            } else {
                if (this.multipool == null) return;
                this.multipool.suspend(false);
            }
            return;
        }
        catch (Exception exception) {
            throw new ModuleException(exception);
        }
    }

    public void unprepare() throws IllegalStateException, ModuleException {
        if (this.oldAppScopedPool) {
            if (this.dataSource != null) {
                ((LocalDataSource)this.dataSource).unregister();
            }
            this.unbindDataSource();
            this.dataSource = null;
        } else {
            try {
                if (this.legacyType == 0 || this.legacyType == 1 || this.legacyType == 2) {
                    this.cpMgr.shutdownAndDestroyPool(this.dsBean, this.appName, this.moduleName);
                }
                if (this.pool != null) {
                    JDBCService.destroyConnectionPoolRuntimeMBean(this.pool.getAppName(), this.pool.getModuleName(), this.pool.getName());
                    JDBCService.destroyDataSourceRuntimeMBean(this.pool.getDriverVersion(), this.pool.getAppName(), this.pool.getModuleName(), this.pool.getName());
                }
            }
            catch (Exception exception) {
                throw new ModuleException(exception);
            }
        }
    }

    public void remove() throws IllegalStateException, ModuleException {
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        registration.removeUpdateListener(this);
    }

    public void adminToProduction() {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) {
    }

    public void forceProductionToAdmin() {
    }

    private static HashMap getCPModuleNames(JDBCDataSourceBean jDBCDataSourceBean) throws ResourceException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (ApplicationAccess.getApplicationAccess().getCurrentApplicationContext() == null) {
            return null;
        }
        Module[] moduleArray = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext().getApplicationModules();
        String string = jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            Module module = JDBCModule.getModule(moduleArray, string2);
            if (module == null) {
                String string3 = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext().getApplicationId();
                throw new ResourceException("Unable to find module in application '" + string3 + "' for connection pool '" + string2 + "' being used by multi pool '" + jDBCDataSourceBean.getName() + "'");
            }
            hashMap.put(string2, module.getId());
        }
        return hashMap;
    }

    private static Module getModule(Module[] moduleArray, String string) {
        int n = string.indexOf("@");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            if ((n = string2.indexOf("@")) == -1) {
                n = string.indexOf("@");
                string2 = string.substring(0, n);
            } else {
                string2 = string2.substring(0, n);
            }
            for (int i = 0; i < moduleArray.length; ++i) {
                if (!"jdbc".equals(moduleArray[i].getType()) || !string2.equals(moduleArray[i].getId())) continue;
                return moduleArray[i];
            }
            return null;
        }
        for (int i = 0; i < moduleArray.length; ++i) {
            JDBCDataSourceBean jDBCDataSourceBean;
            DescriptorBean[] descriptorBeanArray;
            if (!"jdbc".equals(moduleArray[i].getType()) || (descriptorBeanArray = moduleArray[i].getDescriptors()) == null || descriptorBeanArray.length != 1 || !(descriptorBeanArray[0] instanceof JDBCDataSourceBean) || !string.equals((jDBCDataSourceBean = (JDBCDataSourceBean)descriptorBeanArray[0]).getName())) continue;
            return moduleArray[i];
        }
        return null;
    }

    public boolean acceptURI(String string) {
        if (".".equals(string)) {
            return true;
        }
        return this.uri.equals(string);
    }

    public void prepareUpdate(String string) throws ModuleException {
        this.processUpdate(string, this.COMMIT_CHANGE);
    }

    public void rollbackUpdate(String string) {
        try {
            this.processUpdate(string, this.ROLLBACK_CHANGE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void activateUpdate(String string) throws ModuleException {
        this.dsBean = this.deploymentHelper.createJDBCDataSourceDescriptor(this.appCtx, string);
        if (this.pool != null) {
            this.pool.setJDBCDataSource(this.dsBean);
        }
    }

    public String toString() {
        if (this.oldAppScopedPool) {
            return "JDBCModule(" + this.descriptor.getDataSourceJNDIName() + ")";
        }
        return "JDBCModule(" + this.dsBean.getName() + ")";
    }

    public void checkDependencies() throws DeploymentVetoException {
        if (this.oldAppScopedPool) {
            return;
        }
        if (this.pool != null) {
            String string = this.pool.getName();
            Iterator iterator = ConnectionPoolManager.getMultiPools();
            while (iterator.hasNext()) {
                MultiPool multiPool = (MultiPool)iterator.next();
                if (!this.isGloballyScoped() || !multiPool.isGloballyScoped() || !multiPool.hasMember(string)) continue;
                throw new DeploymentVetoException("Cannot undeploy JDBC Data Source " + this.pool.getName() + ", it is currently being used by the JDBC Multi Data Source " + multiPool.getName());
            }
        }
    }

    public void setAltDD(String string) {
        this.altDD = string;
    }

    public String getAltDD() {
        return this.altDD;
    }

    private void bindDataSource() throws ModuleException {
        if (this.bound) {
            return;
        }
        try {
            Context context = (Context)this.envCtx.lookup("jdbc");
            String string = this.descriptor.getDataSourceJNDIName();
            if (string == null) {
                throw new ModuleException("data-source-name not defined in jdbc-connection-pool");
            }
            context.bind(string, (Object)this.dataSource);
        }
        catch (NamingException namingException) {
            throw new ModuleException(namingException.toString(), namingException);
        }
        this.bound = true;
    }

    private void unbindDataSource() throws ModuleException {
        if (!this.bound) {
            return;
        }
        try {
            Context context = (Context)this.envCtx.lookup("jdbc");
            context.unbind(this.descriptor.getDataSourceJNDIName());
        }
        catch (NamingException namingException) {
            throw new ModuleException(namingException.toString(), namingException);
        }
        this.bound = false;
    }

    private void processUpdate(String string, int n) throws ModuleException {
        try {
            JDBCDataSourceBean jDBCDataSourceBean = this.deploymentHelper.createJDBCDataSourceDescriptor(this.appCtx, string);
            Iterator iterator = ((DescriptorBean)this.dsBean).getDescriptor().computeDiff(((DescriptorBean)jDBCDataSourceBean).getDescriptor()).iterator();
            while (iterator.hasNext()) {
                this.processBeanUpdateEvent((BeanUpdateEvent)iterator.next(), n);
            }
        }
        catch (Exception exception) {
            if (n == this.COMMIT_CHANGE) {
                throw new ModuleException("prepareUpdate failed for JDBC Module " + this.dsBean.getName() + ": " + exception.getMessage(), exception);
            }
            throw new ModuleException("rollbackUpdate failed for JDBC Module " + this.dsBean.getName() + ": " + exception.getMessage(), exception);
        }
    }

    private void processBeanUpdateEvent(BeanUpdateEvent beanUpdateEvent, int n) throws Exception {
        int n2;
        JDBCConnectionPoolParamsBean jDBCConnectionPoolParamsBean = null;
        JDBCDataSourceParamsBean jDBCDataSourceParamsBean = null;
        JDBCPropertiesBean jDBCPropertiesBean = null;
        JDBCPropertyBean jDBCPropertyBean = null;
        JDBCOracleParamsBean jDBCOracleParamsBean = null;
        BeanUpdateEvent.PropertyUpdate[] propertyUpdateArray = beanUpdateEvent.getUpdateList();
        if (propertyUpdateArray == null) {
            return;
        }
        DescriptorBean descriptorBean = beanUpdateEvent.getProposedBean();
        if (descriptorBean instanceof JDBCConnectionPoolParamsBean) {
            n2 = 1;
            jDBCConnectionPoolParamsBean = n == this.COMMIT_CHANGE ? (JDBCConnectionPoolParamsBean)descriptorBean : this.dsBean.getJDBCConnectionPoolParams();
        } else if (descriptorBean instanceof JDBCDataSourceParamsBean) {
            n2 = 3;
            jDBCDataSourceParamsBean = n == this.COMMIT_CHANGE ? (JDBCDataSourceParamsBean)descriptorBean : this.dsBean.getJDBCDataSourceParams();
        } else if (descriptorBean instanceof JDBCPropertiesBean) {
            n2 = 100;
            jDBCPropertiesBean = n == this.COMMIT_CHANGE ? (JDBCPropertiesBean)descriptorBean : this.dsBean.getInternalProperties();
        } else if (descriptorBean instanceof JDBCPropertyBean) {
            n2 = 101;
            jDBCPropertyBean = n == this.COMMIT_CHANGE ? (JDBCPropertyBean)descriptorBean : this.dsBean.getInternalProperties().lookupProperty(((JDBCPropertyBean)descriptorBean).getName());
        } else if (descriptorBean instanceof JDBCOracleParamsBean) {
            n2 = 102;
            jDBCOracleParamsBean = n == this.COMMIT_CHANGE ? (JDBCOracleParamsBean)descriptorBean : this.dsBean.getJDBCOracleParams();
        } else {
            if (descriptorBean instanceof JDBCDriverParamsBean) {
                return;
            }
            JDBCLogger.logUnexpectedUpdateBeanType((String)descriptorBean.toString());
            return;
        }
        int n3 = -1;
        block10: for (int i = 0; i < propertyUpdateArray.length; ++i) {
            switch (propertyUpdateArray[i].getUpdateType()) {
                case 1: {
                    Object object;
                    if (n2 == 1) {
                        try {
                            this.processCPUpdate(propertyUpdateArray[i].getPropertyName(), jDBCConnectionPoolParamsBean);
                            continue block10;
                        }
                        catch (Exception exception) {
                            if (propertyUpdateArray[i].getPropertyName().equals("InitialCapacity")) {
                                n3 = i;
                                continue block10;
                            }
                            throw exception;
                        }
                    }
                    if (n2 == 3) {
                        this.processDSUpdate(propertyUpdateArray[i].getPropertyName(), jDBCDataSourceParamsBean);
                        continue block10;
                    }
                    if (n2 == 102) {
                        this.processOracleUpdate(propertyUpdateArray[i].getPropertyName(), jDBCOracleParamsBean);
                        continue block10;
                    }
                    if (n2 == 101) {
                        object = jDBCPropertyBean.getSysPropValue();
                        if (object == null) {
                            object = jDBCPropertyBean.getValue();
                        } else {
                            try {
                                object = System.getProperty((String)object);
                            }
                            catch (Exception exception) {
                                object = null;
                            }
                        }
                        this.processInternalPropertyUpdate(jDBCPropertyBean.getName(), (String)object);
                        continue block10;
                    }
                    JDBCLogger.logUnexpectedBeanChangeType((String)descriptorBean.toString(), (String)propertyUpdateArray[i].toString());
                    continue block10;
                }
                case 2: {
                    Object object;
                    if (n2 == 100) {
                        object = (JDBCPropertyBean)propertyUpdateArray[i].getAddedObject();
                        String string = object.getSysPropValue();
                        if (string == null) {
                            string = object.getValue();
                        } else {
                            try {
                                string = System.getProperty(string);
                            }
                            catch (Exception exception) {
                                string = null;
                            }
                        }
                        this.processInternalPropertyUpdate(object.getName(), string);
                        continue block10;
                    }
                    JDBCLogger.logUnexpectedBeanAddType((String)descriptorBean.toString(), (String)propertyUpdateArray[i].toString());
                    continue block10;
                }
                default: {
                    JDBCLogger.logUnexpectedUpdateType((String)descriptorBean.toString(), (String)propertyUpdateArray[i].toString());
                }
            }
        }
        if (n3 >= 0) {
            this.processCPUpdate(propertyUpdateArray[n3].getPropertyName(), jDBCConnectionPoolParamsBean);
        }
    }

    private void processCPUpdate(String string, JDBCConnectionPoolParamsBean jDBCConnectionPoolParamsBean) throws Exception {
        if (string.equals("MaxCapacity")) {
            this.pool.setMaximumCapacity(jDBCConnectionPoolParamsBean.getMaxCapacity());
        } else if (string.equals("MinCapacity")) {
            this.pool.setMinimumCapacity(jDBCConnectionPoolParamsBean.getMinCapacity());
        } else if (string.equals("InitialCapacity")) {
            this.pool.setInitialCapacity(jDBCConnectionPoolParamsBean.getInitialCapacity());
        } else if (string.equals("CapacityIncrement")) {
            this.pool.setCapacityIncrement(jDBCConnectionPoolParamsBean.getCapacityIncrement());
        } else if (string.equals("HighestNumWaiters")) {
            this.pool.setHighestNumWaiters(jDBCConnectionPoolParamsBean.getHighestNumWaiters());
        } else if (string.equals("InactiveConnectionTimeoutSeconds")) {
            this.pool.setInactiveResourceTimeoutSeconds(jDBCConnectionPoolParamsBean.getInactiveConnectionTimeoutSeconds());
        } else if (string.equals("ConnectionReserveTimeoutSeconds")) {
            this.pool.setResourceReserveTimeoutSeconds(jDBCConnectionPoolParamsBean.getConnectionReserveTimeoutSeconds());
        } else if (string.equals("ConnectionCreationRetryFrequencySeconds")) {
            this.pool.setResourceCreationRetrySeconds(jDBCConnectionPoolParamsBean.getConnectionCreationRetryFrequencySeconds());
        } else if (string.equals("ShrinkFrequencySeconds")) {
            this.pool.setShrinkFrequencySeconds(jDBCConnectionPoolParamsBean.getShrinkFrequencySeconds());
        } else if (string.equals("TestFrequencySeconds")) {
            if (this.pool != null) {
                this.pool.setTestFrequencySeconds(jDBCConnectionPoolParamsBean.getTestFrequencySeconds());
            } else if (this.multipool != null) {
                this.multipool.setHealthCheckFrequencySeconds(jDBCConnectionPoolParamsBean.getTestFrequencySeconds());
            }
        } else if (string.equals("TestConnectionsOnReserve")) {
            this.pool.setTestOnReserve(jDBCConnectionPoolParamsBean.isTestConnectionsOnReserve());
        } else if (string.equals("StatementCacheSize")) {
            this.pool.setStatementCacheSize(jDBCConnectionPoolParamsBean.getStatementCacheSize());
        } else if (string.equals("TestTableName")) {
            this.pool.setTestTableName(jDBCConnectionPoolParamsBean.getTestTableName());
        } else if (string.equals("ProfileType")) {
            this.pool.setProfileType(jDBCConnectionPoolParamsBean.getProfileType());
        } else if (string.equals("ProfileHarvestFrequencySeconds")) {
            this.pool.setProfileHarvestFrequencySeconds(jDBCConnectionPoolParamsBean.getProfileHarvestFrequencySeconds());
        } else if (string.equals("IgnoreInUseConnsEnabled")) {
            this.pool.setIgnoreInUseResources(jDBCConnectionPoolParamsBean.isIgnoreInUseConnectionsEnabled());
        } else if (string.equals("SecondsToTrustAnIdlePoolConnection")) {
            this.pool.setSecondsToTrustAnIdlePoolConnection(jDBCConnectionPoolParamsBean.getSecondsToTrustAnIdlePoolConnection());
        } else if (string.equals("ConnectionHarvestMaxCount")) {
            this.pool.setConnectionHarvestMaxCount(jDBCConnectionPoolParamsBean.getConnectionHarvestMaxCount());
        } else if (string.equals("ConnectionHarvestTriggerCount")) {
            this.pool.setConnectionHarvestTriggerCount(jDBCConnectionPoolParamsBean.getConnectionHarvestTriggerCount());
        } else {
            throw new NonDynamicPropertyUpdateException(string + " is not dynamically updatable. Please redeploy the updated JDBC DataSource for the changes to take effect.");
        }
    }

    private void processDSUpdate(String string, JDBCDataSourceParamsBean jDBCDataSourceParamsBean) throws Exception {
        if (string.equals("FailoverIfBusy")) {
            this.multipool.setFailoverRequestIfBusy(jDBCDataSourceParamsBean.isFailoverRequestIfBusy());
        } else if (string.equals("DataSourceList")) {
            this.multipool.setDataSourceList(jDBCDataSourceParamsBean.getDataSourceList());
        }
    }

    private void processOracleUpdate(String string, JDBCOracleParamsBean jDBCOracleParamsBean) throws Exception {
        if (string.equals("OracleEnableJavaNetFastPath")) {
            this.pool.setOracleEnableJavaNetFastPath(jDBCOracleParamsBean.isOracleEnableJavaNetFastPath());
        } else if (string.equals("OracleOptimizeUtf8Conversion")) {
            this.pool.setOracleOptimizeUtf8Conversion(jDBCOracleParamsBean.isOracleOptimizeUtf8Conversion());
        } else if (string.equals("FanEnabled")) {
            if (this.pool instanceof HAConnectionPool) {
                HAConnectionPool hAConnectionPool = (HAConnectionPool)this.pool;
                hAConnectionPool.setFanEnabled(jDBCOracleParamsBean.isFanEnabled());
            } else {
                JDBCLogger.logFANEnabledNotAllowed((String)this.pool.getName());
            }
        }
    }

    private void processInternalPropertyUpdate(String string, String string2) throws Exception {
        if (string.equals("TestConnectionsOnRelease")) {
            this.pool.setTestOnRelease(Boolean.valueOf(string2).booleanValue());
        } else if (string.equals("TestConnectionsOnCreate")) {
            this.pool.setTestOnCreate(Boolean.valueOf(string2).booleanValue());
        } else if (string.equals("HighestNumUnavailable")) {
            this.pool.setHighestNumUnavailable(Integer.parseInt(string2));
        } else if (string.equals("CountOfTestFailuresTillFlush")) {
            this.pool.setCountOfTestFailuresTillFlush(Integer.parseInt(string2));
        } else if (string.equals("CountOfRefreshFailuresTillDisable")) {
            this.pool.setCountOfRefreshFailuresTillDisable(Integer.parseInt(string2));
        } else {
            throw new NonDynamicPropertyUpdateException(string + " is not dynamically updatable. Please redeploy the updated JDBC DataSource for the changes to take effect.");
        }
    }

    public static String constructDefaultJDBCSystemFilename(String string) {
        if ((string = string.trim()).endsWith("-jdbc")) {
            string = string.substring(0, string.length() - 5);
        }
        return "jdbc/" + FileUtils.mapNameToFileName((String)string) + DEFAULT_APPENDIX;
    }

    private boolean isGloballyScoped() {
        return this.appCtx.getSystemResourceMBean() != null;
    }

    private JDBCDataSourceBean[] getPoolBeans(JDBCDataSourceBean jDBCDataSourceBean, ApplicationContext applicationContext) throws ResourceException {
        String string = jDBCDataSourceBean.getName();
        String string2 = DataSourceManager.getInternalProperty((JDBCDataSourceBean)jDBCDataSourceBean, (String)"LegacyPoolName");
        String string3 = string2 != null ? string2 : string;
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = new JDBCDataSourceBean[1];
        if (JDBCModule.getLegacyType(jDBCDataSourceBean) == 0) {
            if (jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() != null) {
                jDBCDataSourceBeanArray = JDBCModule.getSystemResourceBeans(jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList(), 0, applicationContext);
                if (jDBCDataSourceBeanArray == null) {
                    jDBCDataSourceBeanArray = JDBCModule.getAppDeploymentBeans(jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList(), applicationContext);
                }
                if (jDBCDataSourceBeanArray == null) {
                    jDBCDataSourceBeanArray = JDBCModule.getApplicationBeans(jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList());
                }
                this.checkMDSConfig(jDBCDataSourceBean, jDBCDataSourceBeanArray);
            } else {
                jDBCDataSourceBeanArray[0] = jDBCDataSourceBean;
            }
        } else {
            JDBCDataSourceBean jDBCDataSourceBean2 = null;
            JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = JDBCModule.getDomainMBean(applicationContext).getJDBCSystemResources();
            for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                int n;
                JDBCDataSourceBean jDBCDataSourceBean3 = jDBCSystemResourceMBeanArray[i].getJDBCResource();
                if (jDBCDataSourceBean3 == null || (n = JDBCModule.getLegacyType(jDBCDataSourceBean3)) != 1 && n != 2 || !string3.equals(jDBCDataSourceBean3.getName())) continue;
                jDBCDataSourceBean2 = jDBCDataSourceBean3;
                break;
            }
            if (jDBCDataSourceBean2 != null) {
                if (jDBCDataSourceBean2.getJDBCDataSourceParams().getDataSourceList() != null) {
                    jDBCDataSourceBeanArray = JDBCModule.getSystemResourceBeans(jDBCDataSourceBean2.getJDBCDataSourceParams().getDataSourceList(), 1, applicationContext);
                } else {
                    jDBCDataSourceBeanArray[0] = jDBCDataSourceBean2;
                }
            } else {
                jDBCDataSourceBeanArray = null;
            }
        }
        return jDBCDataSourceBeanArray;
    }

    private static boolean isMemberDSOfMultiDataSource(String string, ApplicationContext applicationContext) {
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = JDBCModule.getDomainMBean(applicationContext).getJDBCSystemResources();
        for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
            String string2;
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBeanArray[i].getJDBCResource();
            if (jDBCDataSourceBean == null || (string2 = jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList()) == null) continue;
            List list = JDBCHelper.getHelper().dsToList(string2);
            Iterator iterator = list.iterator();
            while (list.size() > 0 && iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (!string3.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMemberOfMultiDataSourceLLR(String string, ApplicationContext applicationContext) {
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = JDBCModule.getDomainMBean(applicationContext).getJDBCSystemResources();
        for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
            String string2;
            JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBeanArray[i].getJDBCResource();
            if (jDBCDataSourceBean == null || !jDBCDataSourceBean.getName().equals(string) || (string2 = jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList()) == null) continue;
            List list = JDBCHelper.getHelper().dsToList(string2);
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                for (int j = 0; j < jDBCSystemResourceMBeanArray.length; ++j) {
                    JDBCDataSourceBean jDBCDataSourceBean2 = jDBCSystemResourceMBeanArray[j].getJDBCResource();
                    if (!jDBCDataSourceBean2.getName().equals(string3)) continue;
                    return jDBCDataSourceBean2.getJDBCDataSourceParams().getGlobalTransactionsProtocol().equals("LoggingLastResource");
                }
                continue;
            }
            return false;
        }
        return false;
    }

    private void checkMDSConfig(JDBCDataSourceBean jDBCDataSourceBean, JDBCDataSourceBean[] jDBCDataSourceBeanArray) throws ResourceException {
        if (jDBCDataSourceBeanArray == null) {
            throw new ResourceException("Unable to locate configuration of data sources (" + jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() + ") being used by multi data source " + jDBCDataSourceBean.getName());
        }
        for (int i = 0; i < jDBCDataSourceBeanArray.length; ++i) {
            if (jDBCDataSourceBeanArray[i] != null) continue;
            throw new ResourceException("Unable to locate complete configuration of data sources (" + jDBCDataSourceBean.getJDBCDataSourceParams().getDataSourceList() + ") being used by multi data source " + jDBCDataSourceBean.getName());
        }
    }

    public static JDBCDataSourceBean[] getJDBCDataSourceBean(String string) {
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = JDBCModule.getApplicationBeans(string);
        if (jDBCDataSourceBeanArray == null) {
            jDBCDataSourceBeanArray = JDBCModule.getSystemResourceBeans(string, 0, null);
        }
        if (jDBCDataSourceBeanArray == null) {
            jDBCDataSourceBeanArray = JDBCModule.getAppDeploymentBeans(string, null);
        }
        if (jDBCDataSourceBeanArray == null) {
            jDBCDataSourceBeanArray = JDBCModule.getSystemResourceBeans(string, 1, null);
        }
        return jDBCDataSourceBeanArray;
    }

    private static JDBCDataSourceBean[] getSystemResourceBeans(String string, int n, ApplicationContext applicationContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = new JDBCDataSourceBean[stringTokenizer.countTokens()];
        int n2 = 0;
        JDBCSystemResourceMBean[] jDBCSystemResourceMBeanArray = JDBCModule.getDomainMBean(applicationContext).getJDBCSystemResources();
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < jDBCSystemResourceMBeanArray.length; ++i) {
                JDBCDataSourceBean jDBCDataSourceBean = jDBCSystemResourceMBeanArray[i].getJDBCResource();
                if (jDBCDataSourceBean == null || JDBCModule.getLegacyType(jDBCDataSourceBean) != n || !string2.equals(jDBCDataSourceBean.getName())) continue;
                jDBCDataSourceBeanArray[n2++] = jDBCDataSourceBean;
                continue block0;
            }
        }
        if (n2 == 0) {
            return null;
        }
        return jDBCDataSourceBeanArray;
    }

    private static JDBCDataSourceBean[] getAppDeploymentBeans(String string, ApplicationContext applicationContext) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = new JDBCDataSourceBean[stringTokenizer.countTokens()];
        int n = 0;
        AppDeploymentMBean[] appDeploymentMBeanArray = JDBCModule.getDomainMBean(applicationContext).getAppDeployments();
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                String string3 = appDeploymentMBeanArray[i].getSourcePath();
                if (string3 == null || !string3.endsWith(DEFAULT_APPENDIX)) continue;
                String string4 = appDeploymentMBeanArray[i].getApplicationName();
                ApplicationContextInternal applicationContextInternal = ApplicationAccess.getApplicationAccess().getApplicationContext(string4);
                if (applicationContextInternal == null) {
                    JDBCLogger.logStandaloneMultiDataSourceMemberNotFound((String)applicationContext.getApplicationId(), (String)string4);
                    return null;
                }
                JDBCDataSourceBean jDBCDataSourceBean = JDBCModule.getJDBCModuleFromAppModules(applicationContextInternal.getApplicationModules(), string2);
                if (jDBCDataSourceBean == null) continue;
                jDBCDataSourceBeanArray[n++] = jDBCDataSourceBean;
                continue block0;
            }
        }
        if (n == 0) {
            return null;
        }
        return jDBCDataSourceBeanArray;
    }

    private static JDBCDataSourceBean[] getApplicationBeans(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        JDBCDataSourceBean[] jDBCDataSourceBeanArray = new JDBCDataSourceBean[stringTokenizer.countTokens()];
        int n = 0;
        if (ApplicationAccess.getApplicationAccess().getCurrentApplicationContext() == null) {
            return null;
        }
        Module[] moduleArray = ApplicationAccess.getApplicationAccess().getCurrentApplicationContext().getApplicationModules();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            JDBCDataSourceBean jDBCDataSourceBean = JDBCModule.getJDBCModuleFromAppModules(moduleArray, string2);
            if (jDBCDataSourceBean == null) continue;
            jDBCDataSourceBeanArray[n++] = jDBCDataSourceBean;
        }
        if (n == 0) {
            return null;
        }
        return jDBCDataSourceBeanArray;
    }

    private static JDBCDataSourceBean getJDBCModuleFromAppModules(Module[] moduleArray, String string) {
        int n = string.indexOf("@");
        if (n != -1) {
            String string2 = string.substring(n + 1);
            if ((n = string2.indexOf("@")) == -1) {
                n = string.indexOf("@");
                string2 = string.substring(0, n);
            } else {
                string2 = string2.substring(0, n);
            }
            for (int i = 0; i < moduleArray.length; ++i) {
                if (!"jdbc".equals(moduleArray[i].getType()) || !string2.equals(moduleArray[i].getId())) continue;
                DescriptorBean[] descriptorBeanArray = moduleArray[i].getDescriptors();
                JDBCDataSourceBean jDBCDataSourceBean = (JDBCDataSourceBean)descriptorBeanArray[0];
                return jDBCDataSourceBean;
            }
            return null;
        }
        for (int i = 0; i < moduleArray.length; ++i) {
            JDBCDataSourceBean jDBCDataSourceBean;
            DescriptorBean[] descriptorBeanArray;
            if (!"jdbc".equals(moduleArray[i].getType()) || (descriptorBeanArray = moduleArray[i].getDescriptors()) == null || descriptorBeanArray.length != 1 || !(descriptorBeanArray[0] instanceof JDBCDataSourceBean) || !string.equals((jDBCDataSourceBean = (JDBCDataSourceBean)descriptorBeanArray[0]).getName())) continue;
            return jDBCDataSourceBean;
        }
        return null;
    }

    private static DomainMBean getDomainMBean(ApplicationContext applicationContext) {
        DomainMBean domainMBean = null;
        if (applicationContext != null) {
            try {
                domainMBean = ((ApplicationContextInternal)applicationContext).getProposedDomain();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (domainMBean == null) {
            domainMBean = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain();
        }
        return domainMBean;
    }

    private static int getLegacyType(JDBCDataSourceBean jDBCDataSourceBean) {
        int n = 0;
        String string = DataSourceManager.getInternalProperty((JDBCDataSourceBean)jDBCDataSourceBean, (String)"LegacyType");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }
}

