/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.module;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import weblogic.j2ee.descriptor.wl.ApplicationPoolParamsBean;
import weblogic.j2ee.descriptor.wl.ConnectionCheckParamsBean;
import weblogic.j2ee.descriptor.wl.ConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ConnectionPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.XAParamsBean;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ConnectionPoolConfig;
import weblogic.jdbc.common.internal.DataSourceMetaData;
import weblogic.jdbc.common.internal.DataSourceUtil;
import weblogic.jdbc.common.internal.GenericConnectionPool;
import weblogic.jdbc.common.internal.ParentLogger;
import weblogic.jdbc.common.internal.WLSMBeanConnectionPoolConfig;
import weblogic.jdbc.jta.DataSource;
import weblogic.management.configuration.JDBCDataSourceFactoryMBean;
import weblogic.transaction.TransactionHelper;
import weblogic.transaction.TransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalDataSource
extends ParentLogger
implements javax.sql.DataSource,
DataSourceMetaData {
    private final Driver driverInstance;
    private Properties driverProps;
    private final String driverURL;
    private final String driverClassName;
    private static final String JTSURL = "jdbc:weblogic:jts";
    private final javax.sql.DataSource dsInstance;
    private final ConnectionPool poolRef;
    private final String poolName;
    private final String appName;
    private final String moduleName;
    private final String jtaRegistrationName;

    public LocalDataSource(JDBCConnectionPoolBean jDBCConnectionPoolBean, String string, String string2, JDBCDataSourceFactoryMBean jDBCDataSourceFactoryMBean) throws SQLException {
        Object object;
        block22: {
            this.driverProps = null;
            if (jDBCConnectionPoolBean == null && jDBCDataSourceFactoryMBean == null) {
                throw new SQLException("Both application descriptor and config mbean  are null");
            }
            this.appName = string;
            this.moduleName = string2;
            this.poolName = jDBCConnectionPoolBean.getDataSourceJNDIName();
            ConnectionFactoryBean connectionFactoryBean = jDBCConnectionPoolBean.getConnectionFactory();
            ConnectionPropertiesBean connectionPropertiesBean = connectionFactoryBean.getConnectionProperties();
            String string3 = null;
            String string4 = null;
            if (connectionPropertiesBean != null) {
                string3 = connectionPropertiesBean.getDriverClassName();
                string4 = connectionPropertiesBean.getUrl();
            }
            if (jDBCDataSourceFactoryMBean != null) {
                if (string3 == null) {
                    string3 = jDBCDataSourceFactoryMBean.getDriverClassName();
                }
                if (string4 == null) {
                    string4 = jDBCDataSourceFactoryMBean.getURL();
                }
            }
            if (string3 == null) {
                throw new SQLException("Driver class must be included in your pool or DataSource definition");
            }
            this.driverClassName = string3;
            if (string4 == null) {
                throw new SQLException("URL must be included in your pool or DataSource definition");
            }
            this.driverURL = string4;
            this.driverProps = this.defineDriverProps(string3, jDBCConnectionPoolBean);
            this.jtaRegistrationName = string != null ? string + "@" + string2 + "@" + this.poolName : this.poolName;
            if (DataSourceUtil.isXADataSource((String)string3)) {
                try {
                    this.driverInstance = null;
                    this.dsInstance = new DataSource();
                    ((DataSource)this.dsInstance).setProperties(this.driverProps);
                    try {
                        object = new Hashtable();
                        ((Hashtable)object).put("weblogic.transaction.registration.type", "dynamic");
                        String string5 = (String)this.driverProps.get("callXASetTransactionTimeout");
                        if (string5 != null && "true".equals(string5)) {
                            ((Hashtable)object).put("weblogic.transaction.registration.settransactiontimeout", "true");
                        }
                        try {
                            if (((String)this.driverProps.get("callXAEndAtTxTimout")).equals("true")) {
                                ((Hashtable)object).put("weblogic.transaction.registration.asynctimeoutdelist", "true");
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).registerResource(this.jtaRegistrationName, (XAResource)((weblogic.transaction.XAResource)this.dsInstance), (Hashtable)object);
                        break block22;
                    }
                    catch (Exception exception) {
                        throw new SQLException("Cannot register XAResource '" + this.poolName + "': " + exception.getMessage());
                    }
                }
                catch (Exception exception) {
                    throw new SQLException(exception.getMessage());
                }
            }
            try {
                this.dsInstance = null;
                this.driverInstance = (Driver)Class.forName("weblogic.jdbc.jts.Driver").newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException.getMessage());
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException.getMessage());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException.getMessage());
            }
        }
        try {
            object = new WLSMBeanConnectionPoolConfig(jDBCConnectionPoolBean, jDBCDataSourceFactoryMBean);
            this.poolRef = new GenericConnectionPool(string, string2, (ConnectionPoolConfig)object);
            JDBCLogger.logStart((String)this.poolName, (String)string, (String)string2);
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    public ConnectionPool getPoolRef() {
        return this.poolRef;
    }

    private Properties defineDriverProps(String string, JDBCConnectionPoolBean jDBCConnectionPoolBean) {
        Properties properties = new Properties();
        ConnectionFactoryBean connectionFactoryBean = jDBCConnectionPoolBean.getConnectionFactory();
        ConnectionPropertiesBean connectionPropertiesBean = connectionFactoryBean.getConnectionProperties();
        Object var6_6 = null;
        properties.put("connectionPoolScope", "application");
        properties.put("applicationName", this.appName);
        if (this.moduleName != null) {
            properties.put("moduleName", this.moduleName);
        }
        if (DataSourceUtil.isXADataSource((String)string)) {
            properties.put("connectionPoolID", this.poolName);
            ApplicationPoolParamsBean applicationPoolParamsBean = jDBCConnectionPoolBean.getPoolParams();
            if (applicationPoolParamsBean != null) {
                properties.put("weblogic.t3.waitSecondsForConnectionSecs", String.valueOf(applicationPoolParamsBean.getLoginDelaySeconds()));
                ConnectionCheckParamsBean connectionCheckParamsBean = null;
                XAParamsBean xAParamsBean = null;
                connectionCheckParamsBean = applicationPoolParamsBean.getConnectionCheckParams();
                if (connectionCheckParamsBean != null) {
                    properties.put("testTableName", connectionCheckParamsBean.getTableName());
                }
                if ((xAParamsBean = applicationPoolParamsBean.getXAParams()) != null) {
                    properties.put("jdbcxaDebugLevel", String.valueOf(xAParamsBean.getDebugLevel()));
                    properties.put("preparedStatementCacheSize", String.valueOf(xAParamsBean.getPreparedStatementCacheSize()));
                    properties.put("enableResourceHealthMonitoring", String.valueOf(xAParamsBean.isResourceHealthMonitoringEnabled()));
                    properties.put("keepLogicalConnOpenOnRelease", String.valueOf(xAParamsBean.isKeepLogicalConnOpenOnRelease()));
                    properties.put("callRecoverOnlyOnce", String.valueOf(xAParamsBean.isRecoverOnlyOnceEnabled()));
                    properties.put("keepXAConnTillTxComplete", String.valueOf(xAParamsBean.isKeepConnUntilTxCompleteEnabled()));
                    properties.put("xaEndOnlyOnce", String.valueOf(xAParamsBean.isEndOnlyOnceEnabled()));
                    properties.put("needTxCtxOnClose", String.valueOf(xAParamsBean.isTxContextOnCloseNeeded()));
                    properties.put("newXAConnForCommit", String.valueOf(xAParamsBean.isNewConnForCommitEnabled()));
                }
            }
        } else {
            properties.put("weblogic.jts.connectionPoolId", this.poolName);
            properties.put("weblogic.jts.driverURL", this.driverURL);
            properties.put("weblogic.jts.driverClassName", string);
        }
        return properties;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection = null;
        connection = this.dsInstance != null ? this.dsInstance.getConnection(string, string2) : this.localConnect();
        return connection;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.localConnect();
    }

    private Connection localConnect() throws SQLException {
        Connection connection = null;
        connection = this.driverInstance != null ? this.driverInstance.connect(JTSURL, this.driverProps) : ((DataSource)this.dsInstance).getConnection();
        return connection;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean isTxDataSource() {
        return true;
    }

    void unregister() {
        if (DataSourceUtil.isXADataSource((String)this.driverClassName)) {
            try {
                ((TransactionManager)TransactionHelper.getTransactionHelper().getTransactionManager()).unregisterResource(this.jtaRegistrationName, true);
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }
}

