/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.rmi.Remote;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.jdbc.JDBCTextTextFormatter;
import weblogic.jdbc.common.internal.RmiDataSource;
import weblogic.jdbc.rmi.RMIWrapperImpl;
import weblogic.jndi.Environment;
import weblogic.jndi.WLInitialContextFactory;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.utils.http.HttpParsing;

public final class Driver
extends RMIWrapperImpl
implements java.sql.Driver {
    private static final String URL_BASE = "jdbc:weblogic:rmi";
    private static final String DATA_SOURCE_NAME_PROP = "weblogic.jdbc.datasource";
    private static final String SERVER_URL_PROP = "weblogic.server.url";
    private static final String USER = "weblogic.user";
    private static final String PASSWORD = "weblogic.credential";
    private static final String REMOTEDATASOURCE = "weblogic.jts.remotedatasource";
    private boolean debug = false;
    private DebugLogger JDBCRMIDriver = null;

    public Connection connect(String string, Properties properties) throws SQLException {
        Connection connection = null;
        String string2 = "getConnection";
        Object[] objectArray = new Object[]{string, properties};
        try {
            InitialContext initialContext;
            String string3;
            Object object;
            String string4;
            String string5;
            this.preInvocationHandler(string2, objectArray);
            if (properties != null) {
                string5 = "weblogic.jdbc.verbose";
                string4 = properties.getProperty(string5);
                if (string4 != null) {
                    try {
                        this.debug = Boolean.valueOf(string4);
                    }
                    catch (Exception exception) {
                        String string6 = "The Property " + string5 + " must be a true or false.";
                        throw new SQLException(string6);
                    }
                }
                if (this.debug) {
                    this.JDBCRMIDriver = DebugLogger.createUnregisteredDebugLogger((String)"JDBCRMIDriver", (boolean)true);
                }
            }
            if (this.debug) {
                string5 = "time=" + System.currentTimeMillis() + " : connect" + "\n\turl=" + string + "\n\tinfo=" + properties;
                this.JDBCRMIDriver.debug(string5);
            }
            if (!this.acceptsURL(string)) {
                this.postInvocationHandler(string2, objectArray, null);
                return null;
            }
            int n = string.indexOf(63);
            if (n != -1) {
                HttpParsing.parseQueryString((String)string.substring(n + 1), (Map)properties);
                string = string.substring(0, n);
            }
            if (this.debug) {
                string4 = "time=" + System.currentTimeMillis() + " : getting context";
                this.JDBCRMIDriver.debug(string4);
            }
            string4 = properties.getProperty(DATA_SOURCE_NAME_PROP);
            String string7 = properties.getProperty(SERVER_URL_PROP);
            String string8 = properties.getProperty(USER);
            String string9 = properties.getProperty(PASSWORD);
            if (string4 == null) {
                throw new SQLException("You must define weblogic.jdbc.datasource");
            }
            if (string7 == null) {
                throw new SQLException("You must define weblogic.server.url");
            }
            if (this.debug) {
                this.JDBCRMIDriver.debug("weblogic.jdbc.datasource=" + string4);
                this.JDBCRMIDriver.debug("weblogic.server.url=" + string7);
            }
            try {
                object = new Environment();
                string3 = WLInitialContextFactory.class.getName();
                ((Environment)object).setInitialContextFactory(string3);
                ((Environment)object).setProviderUrl(string7);
                if (string8 != null) {
                    ((Environment)object).setSecurityPrincipal(string8);
                }
                if (string9 != null) {
                    ((Environment)object).setSecurityCredentials(string9);
                }
                initialContext = new InitialContext(((Environment)object).getProperties());
            }
            catch (NamingException namingException) {
                throw new SQLException(namingException.toString());
            }
            if (this.debug) {
                object = "time=" + System.currentTimeMillis() + " : got context,";
                this.JDBCRMIDriver.debug((String)object);
            }
            object = null;
            try {
                if (this.debug) {
                    string3 = "time=" + System.currentTimeMillis() + " : lookup " + string4;
                    this.JDBCRMIDriver.debug(string3);
                }
                if ((object = (DataSource)initialContext.lookup(string4)) != null && properties.getProperty(REMOTEDATASOURCE) != null && object instanceof RmiDataSource) {
                    try {
                        object = null;
                        object = (DataSource)ServerHelper.getStubWithPinnedRef((Remote)((RmiDataSource)object), (String)string7);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (object == null || object instanceof RmiDataSource) {
                        throw new RuntimeException("CR106162: WLS RMI runtime failed to give us a remote DataSource to " + string7);
                    }
                }
                if (object != null) {
                    if (this.debug) {
                        string3 = "time=" + System.currentTimeMillis() + " : got " + string4;
                        this.JDBCRMIDriver.debug(string3);
                        string3 = "time=" + System.currentTimeMillis() + " : getting connection";
                        this.JDBCRMIDriver.debug(string3);
                    }
                    connection = object.getConnection();
                    if (this.debug) {
                        string3 = "time=" + System.currentTimeMillis() + " : got connection";
                        this.JDBCRMIDriver.debug(string3);
                    }
                }
            }
            catch (NamingException namingException) {
                throw new SQLException(namingException.toString());
            }
            this.postInvocationHandler(string2, objectArray, connection);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return connection;
    }

    public boolean acceptsURL(String string) throws SQLException {
        boolean bl = true;
        String string2 = "acceptsURL";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            bl = string.startsWith(URL_BASE);
            this.postInvocationHandler(string2, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return bl;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        String string2 = "DriverPropertyInfo";
        Object[] objectArray = new Object[]{string, properties};
        try {
            this.preInvocationHandler(string2, objectArray);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return null;
    }

    public int getMajorVersion() {
        String string = "getMajorVersion";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.postInvocationHandler(string, objectArray, new Integer(1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public int getMinorVersion() {
        String string = "getMinorVersion";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.postInvocationHandler(string, objectArray, new Integer(2));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 2;
    }

    public boolean jdbcCompliant() {
        String string = "jdbcCompliant";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.postInvocationHandler(string, objectArray, new Boolean(true));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException sQLException) {
            DriverManager.println(new JDBCTextTextFormatter().driverLoadingError(sQLException.getClass().getName(), sQLException.getMessage()));
        }
    }
}

