/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.sql.SQLException;
import java.util.Map;
import weblogic.common.resourcepool.ResourceUnusableException;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.InstrumentationSupport;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;
import weblogic.jdbc.common.internal.ConnectionEnv;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.extensions.PoolUnavailableSQLException;
import weblogic.jdbc.wrapper.JDBCWrapperImpl;
import weblogic.utils.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIWrapperImpl
extends JDBCWrapperImpl {
    static final long serialVersionUID = -6070228019593000541L;
    public static final String _WLDF$INST_VERSION = "9.0.0";
    static /* synthetic */ Class _WLDF$INST_FLD_class;
    public static final DelegatingMonitor _WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium;
    public static final JoinPoint _WLDF$INST_JPFLD_0;

    public void preInvocationHandler(String string, Object[] objectArray) throws Exception {
        if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
            String string2 = string + "(";
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    string2 = string2 + objectArray[i] + ", ";
                }
                string2 = string2 + objectArray[objectArray.length - 1] + ")";
            } else {
                string2 = string2 + ")";
            }
            this.trace(string2);
        }
    }

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
            String string2 = string + " returns";
            if (object != null) {
                string2 = string2 + " " + object;
            }
            this.trace(string2);
        }
        return object;
    }

    public void trace(String string) {
        JdbcDebug.JDBCRMI.debug("[" + (Object)((Object)this) + "] " + string);
    }

    public Object invocationExceptionHandler(String string, Object[] objectArray, Throwable throwable) throws SQLException {
        Object object;
        if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
            object = string + "(";
            if (objectArray != null && objectArray.length > 0) {
                for (int i = 0; i < objectArray.length - 1; ++i) {
                    object = (String)object + objectArray[i] + ", ";
                }
                object = (String)object + objectArray[objectArray.length - 1] + ") throws ";
            } else {
                object = (String)object + "unknown) throws: ";
            }
            object = (String)object + StackTraceUtils.throwable2StackTrace((Throwable)throwable);
            this.trace((String)object);
        }
        if (throwable instanceof ResourceUnusableException) {
            throw new PoolUnavailableSQLException(throwable.getMessage());
        }
        if (throwable instanceof SQLException) {
            throw (SQLException)throwable;
        }
        if (throwable instanceof SecurityException) {
            throw (SecurityException)throwable;
        }
        object = new SQLException(string + ", Exception = " + throwable.getMessage());
        ((Throwable)object).initCause(throwable);
        throw object;
    }

    public ConnectionEnv getConnectionEnv() {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t;
        try {
            if (!clazz.isInstance((Object)this)) throw new SQLException((Object)((Object)this) + " is not an instance of " + clazz);
            Object var5_2 = null;
            t = clazz.cast((Object)this);
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            Object var4_5 = null;
            if (!_WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium.isEnabledAndNotDyeFiltered()) throw throwable;
            DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium;
            InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, var4_5), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
            throw throwable;
        }
        if (!_WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium.isEnabledAndNotDyeFiltered()) return t;
        DelegatingMonitor delegatingMonitor = _WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium;
        InstrumentationSupport.process((JoinPoint)InstrumentationSupport.createDynamicJoinPoint((JoinPoint)_WLDF$INST_JPFLD_0, null, t), (DiagnosticMonitor)delegatingMonitor, (DiagnosticAction[])delegatingMonitor.getActions());
        return t;
    }

    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance((Object)this);
    }

    static {
        _WLDF$INST_FLD_class = Class.forName("weblogic.jdbc.rmi.RMIWrapperImpl");
        _WLDF$INST_FLD_JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium = (DelegatingMonitor)InstrumentationSupport.getMonitor((Class)_WLDF$INST_FLD_class, (String)"JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium");
        _WLDF$INST_JPFLD_0 = InstrumentationSupport.createJoinPoint((Class)_WLDF$INST_FLD_class, (String)"RMIWrapperImpl.java", (String)"weblogic.jdbc.rmi.RMIWrapperImpl", (String)"unwrap", (String)"(Ljava/lang/Class;)Ljava/lang/Object;", (int)112, (Map)InstrumentationSupport.makeMap((String[])new String[]{"JDBC_Diagnostic_Connection_Get_Vendor_Connection_After_Medium"}, (PointcutHandlingInfo[])new PointcutHandlingInfo[]{InstrumentationSupport.createPointcutHandlingInfo((ValueHandlingInfo)InstrumentationSupport.createValueHandlingInfo((String)"pool", (String)"weblogic.diagnostics.instrumentation.gathering.JDBCConnectionRenderer", (boolean)false, (boolean)true), null, null)}), (boolean)false);
    }
}

