/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLXML;
import weblogic.jdbc.rmi.SerialArray;
import weblogic.jdbc.rmi.SerialConnection;
import weblogic.jdbc.rmi.SerialOracleBlob;
import weblogic.jdbc.rmi.SerialOracleClob;
import weblogic.jdbc.rmi.SerialOracleNClob;
import weblogic.jdbc.rmi.SerialPreparedStatement;
import weblogic.jdbc.rmi.SerialRef;
import weblogic.jdbc.rmi.SerialSQLXML;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;

public class SerialCallableStatement
extends SerialPreparedStatement {
    private static final long serialVersionUID = 915412605233701370L;
    private CallableStatement rmi_cstmt = null;

    public SerialCallableStatement() {
    }

    public SerialCallableStatement(CallableStatement callableStatement, SerialConnection serialConnection) {
        this.init(callableStatement, serialConnection);
    }

    public void init(CallableStatement callableStatement, SerialConnection serialConnection) {
        super.init(callableStatement, serialConnection);
        this.rmi_cstmt = callableStatement;
    }

    public static CallableStatement makeSerialCallableStatement(CallableStatement callableStatement, SerialConnection serialConnection) {
        if (callableStatement == null) {
            return null;
        }
        SerialCallableStatement serialCallableStatement = (SerialCallableStatement)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.SerialCallableStatement", (Object)callableStatement, (boolean)false);
        serialCallableStatement.init(callableStatement, serialConnection);
        return (CallableStatement)((Object)serialCallableStatement);
    }

    public Blob getBlob(int n) throws SQLException {
        Blob blob = null;
        String string = "getBlob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            blob = this.rmi_cstmt.getBlob(n);
            if (blob != null) {
                blob = SerialOracleBlob.makeSerialOracleBlob(blob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(blob);
            }
            this.postInvocationHandler(string, objectArray, blob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        Clob clob = null;
        String string = "getClob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            clob = this.rmi_cstmt.getClob(n);
            if (clob != null) {
                clob = SerialOracleClob.makeSerialOracleClob(clob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(clob);
            }
            this.postInvocationHandler(string, objectArray, clob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        Array array = null;
        String string = "getArray";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            array = this.rmi_cstmt.getArray(n);
            if (array != null) {
                array = SerialArray.makeSerialArrayFromStub(array);
            }
            this.postInvocationHandler(string, objectArray, array);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return array;
    }

    public Array getArray(String string) throws SQLException {
        Array array = null;
        String string2 = "getArray";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            array = this.rmi_cstmt.getArray(string);
            if (array != null) {
                array = SerialArray.makeSerialArrayFromStub(array);
            }
            this.postInvocationHandler(string2, objectArray, array);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return array;
    }

    public Blob getBlob(String string) throws SQLException {
        Blob blob = null;
        String string2 = "getBlob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            blob = this.rmi_cstmt.getBlob(string);
            if (blob == null) {
                blob = SerialOracleBlob.makeSerialOracleBlob(blob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(blob);
            }
            this.postInvocationHandler(string2, objectArray, blob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return blob;
    }

    public Clob getClob(String string) throws SQLException {
        Clob clob = null;
        String string2 = "getClob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            clob = this.rmi_cstmt.getClob(string);
            if (clob == null) {
                clob = SerialOracleClob.makeSerialOracleClob(clob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(clob);
            }
            this.postInvocationHandler(string2, objectArray, clob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return clob;
    }

    public NClob getNClob(int n) throws SQLException {
        NClob nClob = null;
        String string = "getNClob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            nClob = this.rmi_cstmt.getNClob(n);
            if (nClob == null) {
                nClob = SerialOracleNClob.makeSerialOracleNClob(nClob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(nClob);
            }
            this.postInvocationHandler(string, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return nClob;
    }

    public NClob getNClob(String string) throws SQLException {
        NClob nClob = null;
        String string2 = "getNClob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            nClob = this.rmi_cstmt.getNClob(string);
            if (nClob == null) {
                nClob = SerialOracleNClob.makeSerialOracleNClob(nClob);
                ((SerialConnection)((Object)this.getConnection())).addToLobSet(nClob);
            }
            this.postInvocationHandler(string2, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return nClob;
    }

    public Ref getRef(int n) throws SQLException {
        Ref ref = null;
        String string = "getRef";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            ref = this.rmi_cstmt.getRef(n);
            if (ref != null) {
                ref = SerialRef.makeSerialRefFromStub(ref);
            }
            this.postInvocationHandler(string, objectArray, ref);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return ref;
    }

    public Ref getRef(String string) throws SQLException {
        Ref ref = null;
        String string2 = "getRef";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            ref = this.rmi_cstmt.getRef(string);
            if (ref != null) {
                ref = SerialRef.makeSerialRefFromStub(ref);
            }
            this.postInvocationHandler(string2, objectArray, ref);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return ref;
    }

    public SQLXML getSQLXML(int n) throws SQLException {
        SQLXML sQLXML = null;
        String string = "getSQLXML";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            sQLXML = this.rmi_cstmt.getSQLXML(n);
            if (sQLXML != null) {
                sQLXML = SerialSQLXML.makeSerialSQLXMLFromStub(sQLXML);
            }
            this.postInvocationHandler(string, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return sQLXML;
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        SQLXML sQLXML = null;
        String string2 = "getSQLXML";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            sQLXML = this.rmi_cstmt.getSQLXML(string);
            if (sQLXML != null) {
                sQLXML = SerialSQLXML.makeSerialSQLXMLFromStub(sQLXML);
            }
            this.postInvocationHandler(string2, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return sQLXML;
    }
}

