/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.transaction.Transaction;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionLeakProfile;
import weblogic.jdbc.common.internal.ProfileStorage;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.SerialArray;
import weblogic.jdbc.rmi.SerialCallableStatement;
import weblogic.jdbc.rmi.SerialDatabaseMetaData;
import weblogic.jdbc.rmi.SerialOracleBlob;
import weblogic.jdbc.rmi.SerialOracleClob;
import weblogic.jdbc.rmi.SerialOracleNClob;
import weblogic.jdbc.rmi.SerialPreparedStatement;
import weblogic.jdbc.rmi.SerialSQLXML;
import weblogic.jdbc.rmi.SerialStatement;
import weblogic.jdbc.rmi.SerialStruct;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.transaction.TransactionHelper;
import weblogic.utils.StackTraceUtils;

public class SerialConnection
extends RMIStubWrapperImpl
implements Serializable {
    private static final long serialVersionUID = 7761262947309720591L;
    protected Set lobsets = Collections.synchronizedSet(new HashSet());
    private Connection rmi_conn;
    private Set<Statement> stmts = Collections.synchronizedSet(new HashSet());
    private Throwable stackTraceSource = null;
    private String poolName = null;
    private boolean connectionClosed = false;
    private boolean createdInThisVM = true;
    private boolean inited = false;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, object);
            return null;
        }
        try {
            if (object instanceof CallableStatement) {
                CallableStatement callableStatement = SerialCallableStatement.makeSerialCallableStatement((CallableStatement)object, this);
                this.stmts.add(callableStatement);
                super.postInvocationHandler(string, objectArray, callableStatement);
                return callableStatement;
            }
            if (object instanceof PreparedStatement) {
                PreparedStatement preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement((PreparedStatement)object, this);
                this.stmts.add(preparedStatement);
                super.postInvocationHandler(string, objectArray, preparedStatement);
                return preparedStatement;
            }
            if (object instanceof Statement) {
                Statement statement = SerialStatement.makeSerialStatement((Statement)object, this);
                this.stmts.add(statement);
                super.postInvocationHandler(string, objectArray, statement);
                return statement;
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void preInvocationHandler(String string, Object[] objectArray) throws Exception {
        super.preInvocationHandler(string, objectArray);
        if (!string.equals("close") && !string.equals("isClosed") && !string.equals("isValid") && this.connectionClosed) {
            throw new SQLException("Connection has already been closed.");
        }
    }

    public SerialConnection() {
    }

    public SerialConnection(Connection connection) {
        this.init(connection);
    }

    public void finalize() {
        if (!this.connectionClosed && !this.createdInThisVM && this.inited && this.stackTraceSource != null) {
            String string;
            if (this.poolName != null) {
                string = new ConnectionLeakProfile(this.poolName, StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource));
                ProfileStorage.storeLeakedConnTrace((ConnectionLeakProfile)string);
            }
            string = StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource);
            try {
                String string2 = ":";
                string = string.substring(string.indexOf(string2) + string2.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            JDBCLogger.logConnectionLeakWarning((String)string);
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void init(Connection connection) {
        this.rmi_conn = connection;
        this.stackTraceSource = new Exception("rmi connection initialized:");
        this.inited = true;
    }

    public Object readResolve() throws ObjectStreamException {
        SerialConnection serialConnection = null;
        try {
            serialConnection = (SerialConnection)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.SerialConnection", (Object)this.rmi_conn, (boolean)false);
            serialConnection.init(this.rmi_conn);
            return (Connection)((Object)serialConnection);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.rmi_conn;
        }
    }

    public void addToLobSet(Object object) {
        this.lobsets.add(object);
    }

    public Connection getDelegate() {
        return this.rmi_conn;
    }

    void removeStatement(SerialStatement serialStatement) {
        this.stmts.remove(serialStatement);
    }

    public Statement createStatement() throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            Statement statement2 = this.rmi_conn.createStatement();
            if (statement2 != null) {
                statement = SerialStatement.makeSerialStatement(statement2, this);
                this.stmts.add(statement);
            }
            super.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            Statement statement2 = this.rmi_conn.createStatement(n, n2);
            if (statement2 != null) {
                statement = SerialStatement.makeSerialStatement(statement2, this);
                this.stmts.add(statement);
            }
            super.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            PreparedStatement preparedStatement2 = this.rmi_conn.prepareStatement(string);
            if (preparedStatement2 != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement2, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string2, objectArray);
            PreparedStatement preparedStatement2 = this.rmi_conn.prepareStatement(string, n, n2);
            if (preparedStatement2 != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement2, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            CallableStatement callableStatement2 = this.rmi_conn.prepareCall(string);
            if (callableStatement2 != null) {
                callableStatement = SerialCallableStatement.makeSerialCallableStatement(callableStatement2, this);
                this.stmts.add(callableStatement);
            }
            super.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string2, objectArray);
            CallableStatement callableStatement2 = this.rmi_conn.prepareCall(string, n, n2);
            if (callableStatement2 != null) {
                callableStatement = SerialCallableStatement.makeSerialCallableStatement(callableStatement2, this);
                this.stmts.add(callableStatement);
            }
            super.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public void close() throws SQLException {
        String string = "close";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            if (!this.connectionClosed) {
                Exception exception;
                block12: {
                    block11: {
                        block10: {
                            this.connectionClosed = true;
                            exception = null;
                            try {
                                this.closeAndClearAllLobs();
                            }
                            catch (Exception exception2) {
                                if (exception != null) break block10;
                                exception = exception2;
                            }
                        }
                        try {
                            this.closeAndClearAllStatements();
                        }
                        catch (Exception exception3) {
                            if (exception != null) break block11;
                            exception = exception3;
                        }
                    }
                    try {
                        this.rmi_conn.close();
                    }
                    catch (Exception exception4) {
                        if (exception != null) break block12;
                        exception = exception4;
                    }
                }
                if (exception != null) {
                    throw exception;
                }
            }
            super.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public boolean isClosed() throws SQLException {
        String string = "isClosed";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            super.postInvocationHandler(string, objectArray, new Boolean(this.connectionClosed));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return this.connectionClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            block5: {
                this.preInvocationHandler(string, objectArray);
                Transaction transaction = null;
                try {
                    transaction = SerialConnection.suspend();
                    DatabaseMetaData databaseMetaData2 = this.rmi_conn.getMetaData();
                    if (databaseMetaData2 != null) {
                        SerialDatabaseMetaData serialDatabaseMetaData = (SerialDatabaseMetaData)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.SerialDatabaseMetaData", (Object)databaseMetaData2, (boolean)false);
                        databaseMetaData = (DatabaseMetaData)((Object)serialDatabaseMetaData);
                    }
                    Object var8_8 = null;
                    if (transaction == null) break block5;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (transaction == null) throw throwable;
                    SerialConnection.resume(transaction);
                    throw throwable;
                }
                SerialConnection.resume(transaction);
            }
            super.postInvocationHandler(string, objectArray, databaseMetaData);
            return databaseMetaData;
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return databaseMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReadOnly(boolean bl) throws SQLException {
        Transaction transaction = null;
        String string = "setReadOnly";
        Object[] objectArray = new Object[]{new Boolean(bl)};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                this.rmi_conn.setReadOnly(bl);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReadOnly() throws SQLException {
        Transaction transaction = null;
        boolean bl = false;
        String string = "isReadOnly";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                bl = this.rmi_conn.isReadOnly();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCatalog(String string) throws SQLException {
        Transaction transaction = null;
        String string2 = "setCatalog";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            try {
                transaction = SerialConnection.suspend();
                this.rmi_conn.setCatalog(string);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getCatalog() throws SQLException {
        String string = null;
        String string2 = "getCatalog";
        Object[] objectArray = new Object[]{};
        try {
            block4: {
                this.preInvocationHandler(string2, objectArray);
                Transaction transaction = null;
                try {
                    transaction = SerialConnection.suspend();
                    string = this.rmi_conn.getCatalog();
                    Object var6_6 = null;
                    if (transaction == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (transaction == null) throw throwable;
                    SerialConnection.resume(transaction);
                    throw throwable;
                }
                SerialConnection.resume(transaction);
            }
            super.postInvocationHandler(string2, objectArray, string);
            return string;
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        Transaction transaction = null;
        SQLWarning sQLWarning = null;
        String string = "getWarnings";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                sQLWarning = this.rmi_conn.getWarnings();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, sQLWarning);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return sQLWarning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Transaction transaction = null;
        String string = "clearWarnings";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                this.rmi_conn.clearWarnings();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getTypeMap() throws SQLException {
        Transaction transaction = null;
        Map<String, Class<?>> map = null;
        String string = "getTypeMap";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                map = this.rmi_conn.getTypeMap();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, map);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTypeMap(Map map) throws SQLException {
        Transaction transaction = null;
        String string = "setTypeMap";
        Object[] objectArray = new Object[]{map};
        try {
            this.preInvocationHandler(string, objectArray);
            try {
                transaction = SerialConnection.suspend();
                this.rmi_conn.setTypeMap(map);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                SerialConnection.resume(transaction);
                throw throwable;
            }
            SerialConnection.resume(transaction);
            super.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    private static Transaction suspend() {
        return TransactionHelper.getTransactionHelper().getTransactionManager().forceSuspend();
    }

    private static void resume(Transaction transaction) {
        TransactionHelper.getTransactionHelper().getTransactionManager().forceResume(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndClearAllStatements() {
        Set<Statement> set = this.stmts;
        synchronized (set) {
            Iterator<Statement> iterator = this.stmts.iterator();
            while (iterator.hasNext()) {
                SerialStatement serialStatement = (SerialStatement)((Object)iterator.next());
                try {
                    serialStatement.close(false);
                    iterator.remove();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAndClearAllLobs() {
        if (this.lobsets == null || this.lobsets.isEmpty()) {
            return;
        }
        Set set = this.lobsets;
        synchronized (set) {
            Iterator iterator = this.lobsets.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SerialArray) {
                    ((SerialArray)e).internalClose();
                } else if (e instanceof SerialOracleBlob) {
                    ((SerialOracleBlob)e).internalClose();
                } else if (e instanceof SerialOracleClob) {
                    ((SerialOracleClob)e).internalClose();
                } else if (e instanceof SerialSQLXML) {
                    ((SerialSQLXML)e).internalClose();
                }
                iterator.remove();
            }
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string, objectArray);
            statement = this.rmi_conn.createStatement(n, n2, n3);
            if (statement != null) {
                statement = SerialStatement.makeSerialStatement(statement, this);
                this.stmts.add(statement);
            }
            super.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string2, objectArray);
            callableStatement = this.rmi_conn.prepareCall(string, n, n2, n3);
            if (callableStatement != null) {
                callableStatement = SerialCallableStatement.makeSerialCallableStatement(callableStatement, this);
                this.stmts.add(callableStatement);
            }
            super.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n)};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = this.rmi_conn.prepareStatement(string, n);
            if (preparedStatement != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, nArray};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = this.rmi_conn.prepareStatement(string, nArray);
            if (preparedStatement != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = this.rmi_conn.prepareStatement(string, n, n2, n3);
            if (preparedStatement != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, stringArray};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = this.rmi_conn.prepareStatement(string, stringArray);
            if (preparedStatement != null) {
                preparedStatement = SerialPreparedStatement.makeSerialPreparedStatement(preparedStatement, this);
                this.stmts.add(preparedStatement);
            }
            super.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Array array = null;
        String string2 = "createArrayOf";
        Object[] objectArray2 = new Object[]{string, objectArray};
        try {
            this.preInvocationHandler(string2, objectArray2);
            array = this.rmi_conn.createArrayOf(string, objectArray);
            if (array != null) {
                array = SerialArray.makeSerialArrayFromStub(array);
                this.addToLobSet(array);
            }
            this.postInvocationHandler(string2, objectArray2, array);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray2, exception);
        }
        return array;
    }

    public Blob createBlob() throws SQLException {
        Blob blob = null;
        String string = "createBlob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            blob = this.rmi_conn.createBlob();
            if (blob != null) {
                blob = SerialOracleBlob.makeSerialOracleBlob(blob);
                this.addToLobSet(blob);
            }
            this.postInvocationHandler(string, objectArray, blob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return blob;
    }

    public Clob createClob() throws SQLException {
        Clob clob = null;
        String string = "createClob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            clob = this.rmi_conn.createClob();
            if (clob != null) {
                clob = SerialOracleClob.makeSerialOracleClob(clob);
                this.addToLobSet(clob);
            }
            this.postInvocationHandler(string, objectArray, clob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return clob;
    }

    public NClob createNClob() throws SQLException {
        NClob nClob = null;
        String string = "createNClob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            nClob = this.rmi_conn.createNClob();
            if (nClob != null) {
                nClob = SerialOracleNClob.makeSerialOracleNClob(nClob);
                this.addToLobSet(nClob);
            }
            this.postInvocationHandler(string, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return nClob;
    }

    public SQLXML createSQLXML() throws SQLException {
        SQLXML sQLXML = null;
        String string = "createSQLXML";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            sQLXML = this.rmi_conn.createSQLXML();
            if (sQLXML != null) {
                sQLXML = SerialSQLXML.makeSerialSQLXMLFromStub(sQLXML);
                this.addToLobSet(sQLXML);
            }
            this.postInvocationHandler(string, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return sQLXML;
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Struct struct2 = null;
        String string2 = "createStruct";
        Object[] objectArray2 = new Object[]{};
        try {
            this.preInvocationHandler(string2, objectArray2);
            struct2 = this.rmi_conn.createStruct(string, objectArray);
            if (struct2 != null) {
                struct2 = SerialStruct.makeSerialStructFromStub(struct2);
            }
            this.postInvocationHandler(string2, objectArray2, struct2);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray2, exception);
        }
        return struct2;
    }

    public boolean isValid() throws SQLException {
        return this.isValid(15);
    }

    public boolean isValid(int n) throws SQLException {
        boolean bl = false;
        String string = "isValid";
        Object[] objectArray = new Object[]{new Integer(n)};
        boolean bl2 = false;
        try {
            try {
                this.preInvocationHandler(string, objectArray);
                bl2 = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            if (n < 0) {
                throw new SQLException("timeout must not be less than 0");
            }
            if (bl2 && !this.connectionClosed) {
                try {
                    bl = this.rmi_conn.isValid(n);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.postInvocationHandler(string, objectArray, bl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }
}

