/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.SerialArray;
import weblogic.jdbc.rmi.SerialConnection;
import weblogic.jdbc.rmi.SerialOracleBlob;
import weblogic.jdbc.rmi.SerialOracleClob;
import weblogic.jdbc.rmi.SerialOracleNClob;
import weblogic.jdbc.rmi.SerialRef;
import weblogic.jdbc.rmi.SerialResultSetMetaData;
import weblogic.jdbc.rmi.SerialSQLXML;
import weblogic.jdbc.rmi.SerialStatement;
import weblogic.jdbc.rmi.internal.ResultSetCachingReader;
import weblogic.jdbc.rmi.internal.ResultSetReader;
import weblogic.jdbc.rmi.internal.ResultSetStraightReader;
import weblogic.jdbc.rmi.internal.ResultSetStub;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;

public class SerialResultSet
extends RMIStubWrapperImpl
implements Serializable {
    private static final long serialVersionUID = -2720653455103793350L;
    private ResultSet rmi_rs = null;
    private ResultSetReader rs_reader = null;
    private transient SerialStatement parent_stmt = null;
    private boolean closed = false;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Blob) {
                return SerialOracleBlob.makeSerialOracleBlob((Blob)object);
            }
            if (object instanceof Clob) {
                return SerialOracleClob.makeSerialOracleClob((Clob)object);
            }
            if (object instanceof Array) {
                return SerialArray.makeSerialArrayFromStub((Array)object);
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
        }
        return object;
    }

    public void init(ResultSet resultSet, SerialStatement serialStatement) {
        this.parent_stmt = serialStatement;
        this.rmi_rs = resultSet;
        this.closed = false;
        try {
            ResultSetStub resultSetStub;
            if (this.rmi_rs instanceof ResultSetStub && (resultSetStub = (ResultSetStub)((Object)this.rmi_rs)).isRowCaching()) {
                this.rs_reader = new ResultSetCachingReader(resultSetStub);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rs_reader = new ResultSetStraightReader(resultSet);
    }

    public static ResultSet makeSerialResultSet(ResultSet resultSet, SerialStatement serialStatement) {
        if (resultSet == null) {
            return null;
        }
        SerialResultSet serialResultSet = (SerialResultSet)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.SerialResultSet", (Object)resultSet, (boolean)false);
        serialResultSet.init(resultSet, serialStatement);
        if (serialStatement != null) {
            serialStatement.addResultSet(serialResultSet);
        }
        return (ResultSet)((Object)serialResultSet);
    }

    public boolean next() throws SQLException {
        boolean bl = false;
        String string = "next";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.next();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public void close() throws SQLException {
        String string = "close";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.close(true);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    void close(boolean bl) throws SQLException {
        try {
            if (!this.closed) {
                if (bl && this.parent_stmt != null) {
                    this.parent_stmt.removeResultSet(this);
                }
                this.rmi_rs.close();
                this.closed = true;
            }
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            Throwable throwable = new SQLException(exception.toString()).initCause(exception);
            throw (SQLException)throwable;
        }
    }

    public boolean wasNull() throws SQLException {
        boolean bl = false;
        String string = "wasNull";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.wasNull();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public String getString(int n) throws SQLException {
        String string = null;
        String string2 = "getString";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string2, objectArray);
            string = this.rs_reader.getString(n);
            this.postInvocationHandler(string2, objectArray, string);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return string;
    }

    public boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        String string = "getBoolean";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.getBoolean(n);
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public byte getByte(int n) throws SQLException {
        byte by = 0;
        String string = "getbyte";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            by = this.rs_reader.getByte(n);
            this.postInvocationHandler(string, objectArray, new Byte(by));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return by;
    }

    public short getShort(int n) throws SQLException {
        short s = 0;
        String string = "getShort";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            s = this.rs_reader.getShort(n);
            this.postInvocationHandler(string, objectArray, new Short(s));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return s;
    }

    public int getInt(int n) throws SQLException {
        int n2 = 0;
        String string = "getInt";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            n2 = this.rs_reader.getInt(n);
            this.postInvocationHandler(string, objectArray, new Integer(n2));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return n2;
    }

    public long getLong(int n) throws SQLException {
        long l = 0L;
        String string = "getLong";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            l = this.rs_reader.getLong(n);
            this.postInvocationHandler(string, objectArray, new Long(l));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return l;
    }

    public float getFloat(int n) throws SQLException {
        float f = 0.0f;
        String string = "getFloat";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            f = this.rs_reader.getFloat(n);
            this.postInvocationHandler(string, objectArray, new Float(f));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return f;
    }

    public double getDouble(int n) throws SQLException {
        double d = 0.0;
        String string = "getDouble";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            d = this.rs_reader.getDouble(n);
            this.postInvocationHandler(string, objectArray, new Double(d));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return d;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        String string = "getBigDecimal";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            bigDecimal = this.rs_reader.getBigDecimal(n, n2);
            this.postInvocationHandler(string, objectArray, bigDecimal);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bigDecimal;
    }

    public byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        String string = "getBytes";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            byArray = this.rs_reader.getBytes(n);
            this.postInvocationHandler(string, objectArray, byArray);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return byArray;
    }

    public Date getDate(int n) throws SQLException {
        Date date = null;
        String string = "getDate";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            date = this.rs_reader.getDate(n);
            this.postInvocationHandler(string, objectArray, date);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return date;
    }

    public Time getTime(int n) throws SQLException {
        Time time = null;
        String string = "getTime";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            time = this.rs_reader.getTime(n);
            this.postInvocationHandler(string, objectArray, time);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return time;
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        String string = "getTimestamp";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            timestamp = this.rs_reader.getTimestamp(n);
            this.postInvocationHandler(string, objectArray, timestamp);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return timestamp;
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = "getAsciiStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            inputStream = this.rs_reader.getAsciiStream(n);
            this.postInvocationHandler(string, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStream;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = "getUnicodeStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            inputStream = this.rs_reader.getUnicodeStream(n);
            this.postInvocationHandler(string, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStream;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        InputStream inputStream = null;
        String string = "getBinaryStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            inputStream = this.rs_reader.getBinaryStream(n);
            this.postInvocationHandler(string, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStream;
    }

    public String getString(String string) throws SQLException {
        String string2 = null;
        String string3 = "getString";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string3, objectArray);
            string2 = this.rs_reader.getString(string);
            this.postInvocationHandler(string3, objectArray, string2);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string3, objectArray, exception);
        }
        return string2;
    }

    public boolean getBoolean(String string) throws SQLException {
        boolean bl = false;
        String string2 = "getBoolean";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            bl = this.rs_reader.getBoolean(string);
            this.postInvocationHandler(string2, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return bl;
    }

    public byte getByte(String string) throws SQLException {
        byte by = 0;
        String string2 = "getByte";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            by = this.rs_reader.getByte(string);
            this.postInvocationHandler(string2, objectArray, new Byte(by));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return by;
    }

    public short getShort(String string) throws SQLException {
        short s = 0;
        String string2 = "getShort";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            s = this.rs_reader.getShort(string);
            this.postInvocationHandler(string2, objectArray, new Short(s));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return s;
    }

    public int getInt(String string) throws SQLException {
        int n = 0;
        String string2 = "getInt";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            n = this.rs_reader.getInt(string);
            this.postInvocationHandler(string2, objectArray, new Integer(n));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return n;
    }

    public long getLong(String string) throws SQLException {
        long l = 0L;
        String string2 = "getLong";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            l = this.rs_reader.getLong(string);
            this.postInvocationHandler(string2, objectArray, new Long(l));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return l;
    }

    public float getFloat(String string) throws SQLException {
        float f = 0.0f;
        String string2 = "getFloat";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            f = this.rs_reader.getFloat(string);
            this.postInvocationHandler(string2, objectArray, new Float(f));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return f;
    }

    public double getDouble(String string) throws SQLException {
        double d = 0.0;
        String string2 = "getDouble";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            d = this.rs_reader.getDouble(string);
            this.postInvocationHandler(string2, objectArray, new Double(d));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return d;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        BigDecimal bigDecimal = null;
        String string2 = "getBigDecimal";
        Object[] objectArray = new Object[]{string, new Integer(n)};
        try {
            this.preInvocationHandler(string2, objectArray);
            bigDecimal = this.rs_reader.getBigDecimal(string, n);
            this.postInvocationHandler(string2, objectArray, bigDecimal);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return bigDecimal;
    }

    public byte[] getBytes(String string) throws SQLException {
        byte[] byArray = null;
        String string2 = "getBytes";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            byArray = this.rs_reader.getBytes(string);
            this.postInvocationHandler(string2, objectArray, byArray);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return byArray;
    }

    public Date getDate(String string) throws SQLException {
        Date date = null;
        String string2 = "getDate";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            date = this.rs_reader.getDate(string);
            this.postInvocationHandler(string2, objectArray, date);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return date;
    }

    public Time getTime(String string) throws SQLException {
        Time time = null;
        String string2 = "getTime";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            time = this.rs_reader.getTime(string);
            this.postInvocationHandler(string2, objectArray, time);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return time;
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Timestamp timestamp = null;
        String string2 = "getTimestamp";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            timestamp = this.rs_reader.getTimestamp(string);
            this.postInvocationHandler(string2, objectArray, timestamp);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return timestamp;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        InputStream inputStream = null;
        String string2 = "getAsciiStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            inputStream = this.rs_reader.getAsciiStream(string);
            this.postInvocationHandler(string2, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return inputStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        InputStream inputStream = null;
        String string2 = "getUnicodeStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            inputStream = this.rs_reader.getUnicodeStream(string);
            this.postInvocationHandler(string2, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        InputStream inputStream = null;
        String string2 = "getBinaryStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            inputStream = this.rs_reader.getBinaryStream(string);
            this.postInvocationHandler(string2, objectArray, inputStream);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return inputStream;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        SerialResultSetMetaData serialResultSetMetaData = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            serialResultSetMetaData = new SerialResultSetMetaData(this.rmi_rs.getMetaData());
            this.postInvocationHandler(string, objectArray, serialResultSetMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return serialResultSetMetaData;
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        String string = "getObject";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            object = this.rs_reader.getObject(n);
            this.postInvocationHandler(string, objectArray, object);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return object;
    }

    public Object getObject(String string) throws SQLException {
        Object object = null;
        String string2 = "getObject";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            object = this.rs_reader.getObject(string);
            this.postInvocationHandler(string2, objectArray, object);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return object;
    }

    public int findColumn(String string) throws SQLException {
        int n = 0;
        String string2 = "findColumn";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            n = this.rs_reader.findColumn(string);
            this.postInvocationHandler(string2, objectArray, new Integer(n));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return n;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Reader reader = null;
        String string = "getCharacterStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            reader = this.rs_reader.getCharacterStream(n);
            this.postInvocationHandler(string, objectArray, reader);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return reader;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        Reader reader = null;
        String string2 = "getCharacterStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            reader = this.rs_reader.getCharacterStream(string);
            this.postInvocationHandler(string2, objectArray, reader);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return reader;
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        String string = "getBigDecimal";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            bigDecimal = this.rs_reader.getBigDecimal(n);
            this.postInvocationHandler(string, objectArray, bigDecimal);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        BigDecimal bigDecimal = null;
        String string2 = "getBigDecimal";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            bigDecimal = this.rs_reader.getBigDecimal(string);
            this.postInvocationHandler(string2, objectArray, bigDecimal);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return bigDecimal;
    }

    public boolean isBeforeFirst() throws SQLException {
        boolean bl = false;
        String string = "isBeforeFirst";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.isBeforeFirst();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public boolean isAfterLast() throws SQLException {
        boolean bl = false;
        String string = "isAfterLast";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.isAfterLast();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public boolean isFirst() throws SQLException {
        boolean bl = false;
        String string = "isFirst";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.isFirst();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public boolean isLast() throws SQLException {
        boolean bl = false;
        String string = "isLast";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.rs_reader.isLast();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public int getRow() throws SQLException {
        int n = 0;
        String string = "getrow";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            n = this.rs_reader.getRow();
            this.postInvocationHandler(string, objectArray, new Integer(n));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return n;
    }

    public Statement getStatement() throws SQLException {
        String string = "getStatement";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.postInvocationHandler(string, objectArray, this.parent_stmt);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (Statement)((Object)this.parent_stmt);
    }

    public Object getObject(int n, Map map) throws SQLException {
        Object object = null;
        String string = "getObject";
        Object[] objectArray = new Object[]{new Integer(n), map};
        try {
            this.preInvocationHandler(string, objectArray);
            object = this.rs_reader.getObject(n, map);
            this.postInvocationHandler(string, objectArray, object);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return object;
    }

    public Blob getBlob(int n) throws SQLException {
        Blob blob = null;
        String string = "getBlob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            ResultSetMetaData resultSetMetaData = this.rmi_rs.getMetaData();
            blob = this.rmi_rs.getBlob(resultSetMetaData.getColumnName(n));
            if (blob != null) {
                blob = SerialOracleBlob.makeSerialOracleBlob(blob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(blob);
            }
            super.postInvocationHandler(string, objectArray, blob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return blob;
    }

    public Clob getClob(int n) throws SQLException {
        Clob clob = null;
        String string = "getClob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            ResultSetMetaData resultSetMetaData = this.rmi_rs.getMetaData();
            clob = this.rmi_rs.getClob(resultSetMetaData.getColumnName(n));
            if (clob != null) {
                clob = SerialOracleClob.makeSerialOracleClob(clob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(clob);
            }
            super.postInvocationHandler(string, objectArray, clob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return clob;
    }

    public Array getArray(int n) throws SQLException {
        Array array = null;
        String string = "getArray";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            array = SerialArray.makeSerialArrayFromStub(this.rs_reader.getArray(n));
            super.postInvocationHandler(string, objectArray, array);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return array;
    }

    public Array getArray(String string) throws SQLException {
        Array array = null;
        String string2 = "getArray";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            array = SerialArray.makeSerialArrayFromStub(this.rs_reader.getArray(string));
            super.postInvocationHandler(string2, objectArray, array);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return array;
    }

    public Object getObject(String string, Map map) throws SQLException {
        Object object = null;
        String string2 = "getObject";
        Object[] objectArray = new Object[]{string, map};
        try {
            this.preInvocationHandler(string2, objectArray);
            object = this.rs_reader.getObject(string, map);
            this.postInvocationHandler(string2, objectArray, object);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return object;
    }

    public Ref getRef(String string) throws SQLException {
        Ref ref = null;
        String string2 = "getRef";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            ref = this.rs_reader.getRef(string);
            if (ref != null) {
                ref = SerialRef.makeSerialRefFromStub(ref);
            }
            this.postInvocationHandler(string2, objectArray, ref);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return ref;
    }

    public Blob getBlob(String string) throws SQLException {
        Blob blob = null;
        String string2 = "getBlob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            blob = this.rmi_rs.getBlob(string);
            if (blob != null) {
                blob = SerialOracleBlob.makeSerialOracleBlob(blob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(blob);
            }
            super.postInvocationHandler(string2, objectArray, blob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return blob;
    }

    public Clob getClob(String string) throws SQLException {
        Clob clob = null;
        String string2 = "getClob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            clob = this.rmi_rs.getClob(string);
            if (clob != null) {
                clob = SerialOracleClob.makeSerialOracleClob(clob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(clob);
            }
            super.postInvocationHandler(string2, objectArray, clob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return clob;
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = null;
        String string = "getDate";
        Object[] objectArray = new Object[]{new Integer(n), calendar};
        try {
            this.preInvocationHandler(string, objectArray);
            date = this.rs_reader.getDate(n, calendar);
            this.postInvocationHandler(string, objectArray, date);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return date;
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        Date date = null;
        String string2 = "getDate";
        Object[] objectArray = new Object[]{string, calendar};
        try {
            this.preInvocationHandler(string2, objectArray);
            date = this.rs_reader.getDate(string, calendar);
            this.postInvocationHandler(string2, objectArray, date);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return date;
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = null;
        String string = "getTime";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            time = this.rs_reader.getTime(n, calendar);
            this.postInvocationHandler(string, objectArray, time);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return time;
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        Time time = null;
        String string2 = "getTime";
        Object[] objectArray = new Object[]{string, calendar};
        try {
            this.preInvocationHandler(string2, objectArray);
            time = this.rs_reader.getTime(string, calendar);
            this.postInvocationHandler(string2, objectArray, time);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return time;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        String string = "getTimestamp";
        Object[] objectArray = new Object[]{new Integer(n), calendar};
        try {
            this.preInvocationHandler(string, objectArray);
            timestamp = this.rs_reader.getTimestamp(n, calendar);
            this.postInvocationHandler(string, objectArray, timestamp);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Timestamp timestamp = null;
        String string2 = "getTimestamp";
        Object[] objectArray = new Object[]{string, calendar};
        try {
            this.preInvocationHandler(string2, objectArray);
            timestamp = this.rs_reader.getTimestamp(string, calendar);
            this.postInvocationHandler(string2, objectArray, timestamp);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return timestamp;
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        Reader reader = null;
        String string = "getNCharacterStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            reader = this.rs_reader.getNCharacterStream(n);
            this.postInvocationHandler(string, objectArray, reader);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return reader;
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        Reader reader = null;
        String string2 = "getNCharacterStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            reader = this.rs_reader.getNCharacterStream(string);
            this.postInvocationHandler(string2, objectArray, reader);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return reader;
    }

    public NClob getNClob(int n) throws SQLException {
        NClob nClob = null;
        String string = "getNClob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            nClob = this.rs_reader.getNClob(n);
            if (nClob != null) {
                nClob = SerialOracleNClob.makeSerialOracleNClob(nClob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(nClob);
            }
            super.postInvocationHandler(string, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return nClob;
    }

    public NClob getNClob(String string) throws SQLException {
        NClob nClob = null;
        String string2 = "getNClob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            nClob = this.rs_reader.getNClob(string);
            if (nClob != null) {
                nClob = SerialOracleNClob.makeSerialOracleNClob(nClob);
                ((SerialConnection)((Object)this.getStatement().getConnection())).addToLobSet(nClob);
            }
            super.postInvocationHandler(string2, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return nClob;
    }

    public String getNString(int n) throws SQLException {
        String string = null;
        String string2 = "getNString";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string2, objectArray);
            string = this.rs_reader.getNString(n);
            this.postInvocationHandler(string2, objectArray, string);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return string;
    }

    public String getNString(String string) throws SQLException {
        String string2 = null;
        String string3 = "getNString";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string3, objectArray);
            string2 = this.rs_reader.getNString(string);
            this.postInvocationHandler(string3, objectArray, string2);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string3, objectArray, exception);
        }
        return string2;
    }

    public Ref getRef(int n) throws SQLException {
        Ref ref = null;
        String string = "getRef";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            ref = this.rs_reader.getRef(n);
            if (ref != null) {
                ref = SerialRef.makeSerialRefFromStub(ref);
            }
            this.postInvocationHandler(string, objectArray, ref);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return ref;
    }

    public SQLXML getSQLXML(int n) throws SQLException {
        SQLXML sQLXML = null;
        String string = "getSQLXML";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            sQLXML = this.rs_reader.getSQLXML(n);
            if (sQLXML != null) {
                sQLXML = SerialSQLXML.makeSerialSQLXMLFromStub(sQLXML);
            }
            this.postInvocationHandler(string, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return sQLXML;
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        SQLXML sQLXML = null;
        String string2 = "getSQLXML";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            sQLXML = this.rs_reader.getSQLXML(string);
            if (sQLXML != null) {
                sQLXML = SerialSQLXML.makeSerialSQLXMLFromStub(sQLXML);
            }
            this.postInvocationHandler(string2, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return sQLXML;
    }

    public URL getURL(int n) throws SQLException {
        URL uRL = null;
        String string = "getURL";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            uRL = this.rs_reader.getURL(n);
            this.postInvocationHandler(string, objectArray, uRL);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return uRL;
    }

    public URL getURL(String string) throws SQLException {
        URL uRL = null;
        String string2 = "getURL";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            uRL = this.rs_reader.getURL(string);
            this.postInvocationHandler(string2, objectArray, uRL);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return uRL;
    }

    public boolean isClosed() throws SQLException {
        boolean bl = this.closed;
        String string = "isClosed";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            if (!this.closed) {
                bl = this.rmi_rs.isClosed();
            }
            this.postInvocationHandler(string, objectArray, bl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }
}

