/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.RmiStatement;
import weblogic.jdbc.rmi.SerialConnection;
import weblogic.jdbc.rmi.SerialResultSet;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;

public class SerialStatement
extends RMIStubWrapperImpl
implements RmiStatement,
Serializable {
    private static final long serialVersionUID = -1944649289013384795L;
    private Statement rmi_stmt = null;
    private transient SerialConnection parent_conn = null;
    protected transient Set<SerialResultSet> rsets = Collections.synchronizedSet(new HashSet());
    private transient boolean isClosed = false;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof ResultSet) {
                object = SerialResultSet.makeSerialResultSet((ResultSet)object, this);
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void preInvocationHandler(String string, Object[] objectArray) throws Exception {
        super.preInvocationHandler(string, objectArray);
        if (!string.equals("isClosed")) {
            this.checkClosed();
        }
    }

    public void init(Statement statement, SerialConnection serialConnection) {
        this.rmi_stmt = statement;
        this.parent_conn = serialConnection;
        this.isClosed = false;
    }

    public static Statement makeSerialStatement(Statement statement, SerialConnection serialConnection) {
        if (statement == null) {
            return null;
        }
        SerialStatement serialStatement = (SerialStatement)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.SerialStatement", (Object)statement, (boolean)false);
        serialStatement.init(statement, serialConnection);
        return (Statement)((Object)serialStatement);
    }

    void addResultSet(SerialResultSet serialResultSet) {
        this.rsets.add(serialResultSet);
    }

    void removeResultSet(SerialResultSet serialResultSet) {
        this.rsets.remove(serialResultSet);
    }

    public int getRmiFetchSize() throws SQLException {
        try {
            return ((RmiStatement)((Object)this.rmi_stmt)).getRmiFetchSize();
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException(exception.toString());
        }
    }

    public void setRmiFetchSize(int n) throws SQLException {
        try {
            ((RmiStatement)((Object)this.rmi_stmt)).setRmiFetchSize(n);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException(exception.toString());
        }
    }

    public void close() throws SQLException {
        this.close(true);
    }

    void close(boolean bl) throws SQLException {
        if (this.isClosed) {
            return;
        }
        try {
            try {
                this.closeAndClearAllResultSets();
                if (bl) {
                    this.parent_conn.removeStatement(this);
                }
                this.rmi_stmt.close();
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw new SQLException(exception.toString());
            }
            Object var4_2 = null;
            this.isClosed = true;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.isClosed = true;
            throw throwable;
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement is closed.");
        }
    }

    public Connection getConnection() throws SQLException {
        String string = "getConnection";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            this.postInvocationHandler(string, objectArray, this.parent_conn);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (Connection)((Object)this.parent_conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndClearAllResultSets() {
        Set<SerialResultSet> set = this.rsets;
        synchronized (set) {
            Iterator<SerialResultSet> iterator = this.rsets.iterator();
            while (iterator.hasNext()) {
                SerialResultSet serialResultSet = iterator.next();
                try {
                    serialResultSet.close(false);
                    iterator.remove();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public boolean isClosed() throws SQLException {
        String string = "isClosed";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            super.postInvocationHandler(string, objectArray, new Boolean(this.isClosed));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return this.isClosed;
    }
}

