/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.internal.Blob;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class BlobStub
extends RMIStubWrapperImpl
implements Serializable,
StubDelegateInfo {
    private static final long serialVersionUID = 6113511803561203420L;
    Blob remoteB;
    private RmiDriverSettings rmiSettings = null;

    public void init(Blob blob, RmiDriverSettings rmiDriverSettings) {
        this.remoteB = blob;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public void internalClose() {
        this.remoteB.internalClose();
    }

    public Object readResolve() throws ObjectStreamException {
        BlobStub blobStub = null;
        try {
            blobStub = (BlobStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.BlobStub", (Object)this.remoteB, (boolean)false);
            blobStub.init(this.remoteB, this.rmiSettings);
            return (java.sql.Blob)((Object)blobStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.remoteB;
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        String string;
        InputStreamHandler inputStreamHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getBinaryStream";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            BlockGetter blockGetter = this.getBlockGetter();
            int n = this.registerStream(3);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    public int registerStream(int n) throws SQLException {
        return this.remoteB.registerStream(n);
    }

    public BlockGetter getBlockGetter() throws SQLException {
        return this.remoteB.getBlockGetter();
    }

    public Object getStubDelegate() {
        return this.remoteB;
    }
}

