/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.Remote;
import java.sql.SQLException;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.internal.CallableStatement;
import weblogic.jdbc.rmi.internal.CallableStatementStub;
import weblogic.jdbc.rmi.internal.PreparedStatementImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.StubFactory;

public class CallableStatementImpl
extends PreparedStatementImpl {
    private java.sql.CallableStatement t2_cstmt = null;
    private RmiDriverSettings rmiSettings = null;
    private BlockGetter bg = null;
    private ReaderBlockGetter rbg = null;
    private transient Object interop = null;
    public static final int ASCII_STREAM = 1;
    public static final int UNICODE_STREAM = 2;
    public static final int BINARY_STREAM = 3;
    public static final int CHARACTER_STREAM = 4;
    public static final int NCHARACTER_STREAM = 5;

    public CallableStatementImpl() {
    }

    public CallableStatementImpl(java.sql.CallableStatement callableStatement, RmiDriverSettings rmiDriverSettings) {
        this.init(callableStatement, rmiDriverSettings);
    }

    public void init(java.sql.CallableStatement callableStatement, RmiDriverSettings rmiDriverSettings) {
        super.init(callableStatement, rmiDriverSettings);
        this.t2_cstmt = callableStatement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public static java.sql.CallableStatement makeCallableStatementImpl(java.sql.CallableStatement callableStatement, RmiDriverSettings rmiDriverSettings) {
        if (callableStatement == null) {
            return null;
        }
        CallableStatementImpl callableStatementImpl = (CallableStatementImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.CallableStatementImpl", (Object)callableStatement, (boolean)true));
        callableStatementImpl.init(callableStatement, rmiDriverSettings);
        return (java.sql.CallableStatement)((Object)callableStatementImpl);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new CallableStatementStub((CallableStatement)object, this.rmiSettings);
        }
        return this.interop;
    }

    public java.sql.CallableStatement getImplDelegateAsCS() {
        return (java.sql.CallableStatement)this.getImplDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockGetter getBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        return this.bg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(int n, int n2) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (n2 == 4 || n2 == 5) {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            object = null;
            object = n2 == 4 ? this.getImplDelegateAsCS().getCharacterStream(n) : this.getImplDelegateAsCS().getNCharacterStream(n);
            if (object == null) {
                return -1;
            }
            return this.rbg.register((Reader)object, this.rmiSettings.getChunkSize());
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        if (n2 == 1) {
            object = this.getAsciiStream(n);
        } else if (n2 == 2) {
            object = this.getUnicodeStream(n);
        } else if (n2 == 3) {
            object = this.getBinaryStream(n);
        } else {
            throw new SQLException("Invalid stream type: " + n2);
        }
        int n3 = this.bg.register((InputStream)object, this.rmiSettings.getChunkSize());
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(String string, int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (n == 4 || n == 5) {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            object = null;
            object = n == 4 ? this.getImplDelegateAsCS().getCharacterStream(string) : this.getImplDelegateAsCS().getNCharacterStream(string);
            if (object == null) {
                return -1;
            }
            return this.rbg.register((Reader)object, this.rmiSettings.getChunkSize());
        }
        throw new SQLException("Invalid stream type: " + n);
    }

    public void close() throws SQLException {
        super.close();
        if (this.bg != null) {
            this.bg.close();
        }
        if (this.rbg != null) {
            this.rbg.close();
        }
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        throw new SQLException("This vendor feature is not supported");
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        throw new SQLException("This vendor feature is not supported");
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        throw new SQLException("This vendor feature is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderBlockGetter getReaderBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getReaderBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.rbg == null) {
                this.rbg = new ReaderBlockGetterImpl();
            }
        }
        return this.rbg;
    }

    public void setClob(String string, ReaderBlockGetter readerBlockGetter, int n) throws SQLException {
        String string2 = "setClob";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setClob(string, (Reader)readerHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setClob(String string, ReaderBlockGetter readerBlockGetter, int n, long l) throws SQLException {
        String string2 = "setClob";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setClob(string, (Reader)readerHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setCharacterStream(String string, ReaderBlockGetter readerBlockGetter, int n) throws SQLException {
        String string2 = "setCharacterStream";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setCharacterStream(string, (Reader)readerHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setCharacterStream(String string, ReaderBlockGetter readerBlockGetter, int n, int n2) throws SQLException {
        String string2 = "setCharacterStream";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, n2};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setCharacterStream(string, (Reader)readerHandler, n2);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setCharacterStream(String string, ReaderBlockGetter readerBlockGetter, int n, long l) throws SQLException {
        String string2 = "setCharacterStream";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setCharacterStream(string, (Reader)readerHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setNClob(String string, ReaderBlockGetter readerBlockGetter, int n) throws SQLException {
        String string2 = "setNClob";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setNClob(string, (Reader)readerHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setNClob(String string, ReaderBlockGetter readerBlockGetter, int n, long l) throws SQLException {
        String string2 = "setNClob";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setNClob(string, (Reader)readerHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setNCharacterStream(String string, ReaderBlockGetter readerBlockGetter, int n) throws SQLException {
        String string2 = "setNCharacterStream";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setNCharacterStream(string, (Reader)readerHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setNCharacterStream(String string, ReaderBlockGetter readerBlockGetter, int n, long l) throws SQLException {
        String string2 = "setNCharacterStream";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setNCharacterStream(string, (Reader)readerHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setAsciiStream(String string, BlockGetter blockGetter, int n) throws SQLException {
        String string2 = "setAsciiStream";
        Object[] objectArray = new Object[]{string, blockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setAsciiStream(string, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setAsciiStream(String string, BlockGetter blockGetter, int n, int n2) throws SQLException {
        String string2 = "setAsciiStream";
        Object[] objectArray = new Object[]{string, blockGetter, n, n2};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setAsciiStream(string, (InputStream)inputStreamHandler, n2);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setAsciiStream(String string, BlockGetter blockGetter, int n, long l) throws SQLException {
        String string2 = "setAsciiStream";
        Object[] objectArray = new Object[]{string, blockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setAsciiStream(string, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setBinaryStream(String string, BlockGetter blockGetter, int n) throws SQLException {
        String string2 = "setBinaryStream";
        Object[] objectArray = new Object[]{string, blockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setBinaryStream(string, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setBinaryStream(String string, BlockGetter blockGetter, int n, int n2) throws SQLException {
        String string2 = "setBinaryStream";
        Object[] objectArray = new Object[]{string, blockGetter, n, n2};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setBinaryStream(string, (InputStream)inputStreamHandler, n2);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setBinaryStream(String string, BlockGetter blockGetter, int n, long l) throws SQLException {
        String string2 = "setBinaryStream";
        Object[] objectArray = new Object[]{string, blockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setBinaryStream(string, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setBlob(String string, BlockGetter blockGetter, int n) throws SQLException {
        String string2 = "setBlob";
        Object[] objectArray = new Object[]{string, blockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setBlob(string, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setBlob(String string, BlockGetter blockGetter, int n, long l) throws SQLException {
        String string2 = "setBlob";
        Object[] objectArray = new Object[]{string, blockGetter, n, l};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setBlob(string, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, ReaderBlockGetter readerBlockGetter, int n) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)readerHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, ReaderBlockGetter readerBlockGetter, int n, int n2) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, n2};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)readerHandler, n2);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, ReaderBlockGetter readerBlockGetter, int n, int n2, int n3) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, readerBlockGetter, n, n2, n3};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)readerHandler, n2, n3);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, BlockGetter blockGetter, int n) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, blockGetter, n};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)inputStreamHandler);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, BlockGetter blockGetter, int n, int n2) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, blockGetter, n, n2};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)inputStreamHandler, n2);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }

    public void setObject(String string, BlockGetter blockGetter, int n, int n2, int n3) throws SQLException {
        String string2 = "setObject";
        Object[] objectArray = new Object[]{string, blockGetter, n, n2, n3};
        try {
            this.preInvocationHandler(string2, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.getImplDelegateAsCS().setObject(string, (Object)inputStreamHandler, n2, n3);
            this.postInvocationHandler(string2, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
    }
}

