/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.internal.CallableStatement;
import weblogic.jdbc.rmi.internal.PreparedStatementStub;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;

public class CallableStatementStub
extends PreparedStatementStub {
    private static final long serialVersionUID = 8441497012896429985L;
    transient BlockGetter bg = null;
    private RmiDriverSettings rmiSettings = null;
    CallableStatement cstmt;

    public CallableStatementStub() {
    }

    public CallableStatementStub(CallableStatement callableStatement, RmiDriverSettings rmiDriverSettings) {
        this.init(callableStatement, rmiDriverSettings);
    }

    public void init(CallableStatement callableStatement, RmiDriverSettings rmiDriverSettings) {
        super.init(callableStatement, rmiDriverSettings);
        this.cstmt = callableStatement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object readResolve() throws ObjectStreamException {
        CallableStatementStub callableStatementStub = null;
        try {
            callableStatementStub = (CallableStatementStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.CallableStatementStub", (Object)this.cstmt, (boolean)false);
            callableStatementStub.init(this.cstmt, this.rmiSettings);
            return (java.sql.CallableStatement)((Object)callableStatementStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.cstmt;
        }
    }

    public CallableStatement getStubDelegateAsCS() {
        return (CallableStatement)this.getStubDelegate();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string;
        InputStreamHandler inputStreamHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getAsciiStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            BlockGetter blockGetter = this.getStubDelegateAsCS().getBlockGetter();
            int n2 = this.getStubDelegateAsCS().registerStream(n, 1);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        String string;
        InputStreamHandler inputStreamHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getBinaryStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            BlockGetter blockGetter = this.getStubDelegateAsCS().getBlockGetter();
            int n2 = this.getStubDelegateAsCS().registerStream(n, 3);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string;
        InputStreamHandler inputStreamHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getUnicodeStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getUnicodeStream";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            BlockGetter blockGetter = this.getStubDelegateAsCS().getBlockGetter();
            int n2 = this.getStubDelegateAsCS().registerStream(n, 2);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(String string, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setClob(string, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setClob(string, this.rbg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(String string, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setClob(string, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setClob(string, this.rbg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setCharacterStream(string, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setCharacterStream(string, this.rbg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setCharacterStream(string, reader, n);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setCharacterStream(string, this.rbg, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setCharacterStream(string, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setCharacterStream(string, this.rbg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(String string, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setNClob(string, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setNClob(string, this.rbg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setNClob(string, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setNClob(string, this.rbg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setNCharacterStream(string, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setNCharacterStream(string, this.rbg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsCS().setNCharacterStream(string, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setNCharacterStream(string, this.rbg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setAsciiStream(string, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setAsciiStream(string, this.bg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setAsciiStream(string, inputStream, n);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setAsciiStream(string, this.bg, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setAsciiStream(string, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setAsciiStream(string, this.bg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setBinaryStream(string, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setBinaryStream(string, this.bg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setBinaryStream(string, inputStream, n);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setBinaryStream(string, this.bg, n2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setBinaryStream(string, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setBinaryStream(string, this.bg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setBlob(string, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setBlob(string, this.bg, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsCS().setBlob(string, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setBlob(string, this.bg, n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String string, Object object) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsCS().setObject(string, object);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.rbg, n);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.bg, n);
        } else {
            this.getStubDelegateAsCS().setObject(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String string, Object object, int n) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsCS().setObject(string, object, n);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.rbg, n2, n);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.bg, n3, n);
        } else {
            this.getStubDelegateAsCS().setObject(string, object, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsCS().setObject(string, object, n, n2);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n3 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.rbg, n3, n, n2);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n4 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsCS().setObject(string, this.bg, n4, n, n2);
        } else {
            this.getStubDelegateAsCS().setObject(string, object, n, n2);
        }
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string;
        ReaderHandler readerHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getCharacterStream";
        Object[] objectArray = new Object[]{n};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderBlockGetter readerBlockGetter = this.getStubDelegateAsCS().getReaderBlockGetter();
            int n2 = this.getStubDelegateAsCS().registerStream(n, 4);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.postInvocationHandler(string, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return readerHandler;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        String string2;
        ReaderHandler readerHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string2 = "time=" + System.currentTimeMillis() + " : getCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string2);
        }
        string2 = "getCharacterStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderBlockGetter readerBlockGetter = this.getStubDelegateAsCS().getReaderBlockGetter();
            int n = this.getStubDelegateAsCS().registerStream(string, 4);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.postInvocationHandler(string2, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return readerHandler;
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        String string;
        ReaderHandler readerHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getNCharacterStream";
        Object[] objectArray = new Object[]{n};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderBlockGetter readerBlockGetter = this.getStubDelegateAsCS().getReaderBlockGetter();
            int n2 = this.getStubDelegateAsCS().registerStream(n, 5);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.postInvocationHandler(string, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return readerHandler;
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        String string2;
        ReaderHandler readerHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string2 = "time=" + System.currentTimeMillis() + " : getNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string2);
        }
        string2 = "getNCharacterStream";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            ReaderBlockGetter readerBlockGetter = this.getStubDelegateAsCS().getReaderBlockGetter();
            int n = this.getStubDelegateAsCS().registerStream(string, 5);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.postInvocationHandler(string2, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return readerHandler;
    }
}

