/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.internal.Clob;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class ClobStub
extends RMIStubWrapperImpl
implements Serializable,
StubDelegateInfo {
    private static final long serialVersionUID = 5514150181551731451L;
    Clob remoteC;
    private RmiDriverSettings rmiSettings = null;

    public void init(Clob clob, RmiDriverSettings rmiDriverSettings) {
        this.remoteC = clob;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public void internalClose() {
        this.remoteC.internalClose();
    }

    public Object readResolve() throws ObjectStreamException {
        ClobStub clobStub = null;
        try {
            clobStub = (ClobStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.ClobStub", (Object)this.remoteC, (boolean)false);
            clobStub.init(this.remoteC, this.rmiSettings);
            return (java.sql.Clob)((Object)clobStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.remoteC;
        }
    }

    public InputStream getAsciiStream() throws SQLException {
        String string;
        InputStreamHandler inputStreamHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getAsciiStream";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            BlockGetter blockGetter = this.getBlockGetter();
            int n = this.registerStream(1);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    public Reader getCharacterStream() throws SQLException {
        String string;
        ReaderHandler readerHandler = null;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : getCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "getCharacterStream";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderBlockGetter readerBlockGetter = this.getReaderBlockGetter();
            int n = this.registerStream(2);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n);
            this.postInvocationHandler(string, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return readerHandler;
    }

    public int registerStream(int n) throws SQLException {
        return this.remoteC.registerStream(n);
    }

    public BlockGetter getBlockGetter() throws SQLException {
        return this.remoteC.getBlockGetter();
    }

    public ReaderBlockGetter getReaderBlockGetter() throws SQLException {
        return this.remoteC.getReaderBlockGetter();
    }

    public Object getStubDelegate() {
        return this.remoteC;
    }
}

