/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.rmi.server.Unreferenced;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Properties;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.ConnectionLeakProfile;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ProfileStorage;
import weblogic.jdbc.rmi.RMIWrapperImpl;
import weblogic.jdbc.rmi.internal.ArrayImpl;
import weblogic.jdbc.rmi.internal.CallableStatementImpl;
import weblogic.jdbc.rmi.internal.DatabaseMetaDataImpl;
import weblogic.jdbc.rmi.internal.OracleTBlobImpl;
import weblogic.jdbc.rmi.internal.OracleTClobImpl;
import weblogic.jdbc.rmi.internal.OracleTNClobImpl;
import weblogic.jdbc.rmi.internal.PreparedStatementImpl;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.SQLXMLImpl;
import weblogic.jdbc.rmi.internal.SavepointImpl;
import weblogic.jdbc.rmi.internal.StatementImpl;
import weblogic.jdbc.rmi.internal.StructImpl;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rjvm.PeerGoneEvent;
import weblogic.rjvm.PeerGoneListener;
import weblogic.rjvm.RJVM;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.server.UnicastRemoteObject;
import weblogic.rmi.spi.EndPoint;
import weblogic.utils.StackTraceUtils;

public class ConnectionImpl
extends RMISkelWrapperImpl
implements Unreferenced,
PeerGoneListener,
InteropWriteReplaceable {
    private Connection t2_conn = null;
    private RmiDriverSettings rmiSettings = null;
    private boolean isPeerGoneListener = false;
    public static final String CHUNK_SIZE = "weblogic.jdbc.stream_chunk_size";
    public static final String VERBOSE = "weblogic.jdbc.verbose";
    public static final String CACHE_ROWS = "weblogic.jdbc.rmi.cacheRows";
    private Throwable stackTraceSource = null;
    private boolean isClosed = false;
    private String poolName = null;
    private static final boolean DEBUGROUTING = false;
    private transient boolean createdInThisVM = true;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof CallableStatement) {
                object = CallableStatementImpl.makeCallableStatementImpl((CallableStatement)object, this.rmiSettings);
            } else if (object instanceof PreparedStatement) {
                object = PreparedStatementImpl.makePreparedStatementImpl((PreparedStatement)object, this.rmiSettings);
            } else if (object instanceof Statement) {
                object = StatementImpl.makeStatementImpl((Statement)object, this.rmiSettings);
            } else if (object instanceof Savepoint) {
                object = SavepointImpl.makeSavepointImpl((Savepoint)object);
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void init(Connection connection, Properties properties, RmiDriverSettings rmiDriverSettings, String string) throws SQLException {
        this.t2_conn = connection;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
        if (string != null) {
            this.poolName = string;
        }
        if (properties != null) {
            this.setup(properties);
        }
        if (this.rmiSettings.isVerbose()) {
            JdbcDebug.JDBCRMIInternal.debug("rmi settings: " + this.rmiSettings);
        }
    }

    public void finalize() {
        if (!this.isClosed && !this.createdInThisVM) {
            if (this.poolName != null) {
                ConnectionLeakProfile connectionLeakProfile = new ConnectionLeakProfile(this.poolName, StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource));
                ProfileStorage.storeLeakedConnTrace((ConnectionLeakProfile)connectionLeakProfile);
            }
            try {
                if (!this.t2_conn.getAutoCommit()) {
                    this.t2_conn.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            JdbcDebug.JDBCRMIInternal.debug("Detected Connection Leak!!!!! : " + StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource));
        }
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        return this;
    }

    public void peerGone(PeerGoneEvent peerGoneEvent) {
        if (this.rmiSettings.isVerbose()) {
            JdbcDebug.JDBCRMIInternal.debug("Client JVM died: " + peerGoneEvent);
        }
        try {
            if (!this.isClosed && !this.createdInThisVM) {
                String string;
                if (this.poolName != null) {
                    string = new ConnectionLeakProfile(this.poolName, StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource));
                    ProfileStorage.storeLeakedConnTrace((ConnectionLeakProfile)string);
                }
                string = StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource);
                try {
                    String string2 = ":";
                    string = string.substring(string.indexOf(string2) + string2.length());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JDBCLogger.logConnectionLeakWarning((String)string);
                if (!this.t2_conn.getAutoCommit()) {
                    this.t2_conn.rollback();
                }
            }
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.t2_conn = null;
    }

    public void addPeerGoneListener() {
        if (!this.isPeerGoneListener) {
            this.isPeerGoneListener = true;
            EndPoint endPoint = ServerHelper.getClientEndPointInternal();
            if (endPoint != null && endPoint instanceof RJVM) {
                ((RJVM)endPoint).addPeerGoneListener((PeerGoneListener)this);
            }
        }
    }

    private void setup(Properties properties) throws SQLException {
        String string = (String)properties.get(CHUNK_SIZE);
        if (string != null) {
            try {
                this.rmiSettings.setChunkSize(Integer.parseInt(string));
            }
            catch (Exception exception) {
                String string2 = "The Property weblogic.jdbc.stream_chunk_size must be a number";
                throw new SQLException(string2);
            }
        }
        if ((string = (String)properties.get(CACHE_ROWS)) != null) {
            try {
                this.rmiSettings.setRowCacheSize(Integer.parseInt(string));
            }
            catch (Exception exception) {
                String string3 = "The Property weblogic.jdbc.rmi.cacheRows must be a number";
                throw new SQLException(string3);
            }
        }
        if ((string = (String)properties.get(VERBOSE)) != null) {
            try {
                this.rmiSettings.setVerbose(Boolean.valueOf(string).booleanValue());
            }
            catch (Exception exception) {
                String string4 = "The Property weblogic.jdbc.verbose must be a true or false.";
                throw new SQLException(string4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreferenced() {
        try {
            try {
                if (!this.isClosed && !this.createdInThisVM) {
                    String string;
                    if (this.poolName != null) {
                        string = new ConnectionLeakProfile(this.poolName, StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource));
                        ProfileStorage.storeLeakedConnTrace((ConnectionLeakProfile)string);
                    }
                    string = StackTraceUtils.throwable2StackTrace((Throwable)this.stackTraceSource);
                    try {
                        String string2 = ":";
                        string = string.substring(string.indexOf(string2) + string2.length());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JDBCLogger.logConnectionLeakWarning((String)string);
                }
                this.close();
            }
            catch (SQLException sQLException) {
                JDBCLogger.logStackTrace((Throwable)sQLException);
                Object var4_6 = null;
                this.t2_conn = null;
            }
            Object var4_5 = null;
            this.t2_conn = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.t2_conn = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{};
        try {
            try {
                this.preInvocationHandler(string, objectArray);
                statement = StatementImpl.makeStatementImpl(this.t2_conn.createStatement(), this.rmiSettings);
                this.postInvocationHandler(string, objectArray, statement);
            }
            catch (Exception exception) {
                this.invocationExceptionHandler(string, objectArray, exception);
                Object var6_5 = null;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
        return statement;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            statement = StatementImpl.makeStatementImpl(this.t2_conn.createStatement(n, n2), this.rmiSettings);
            this.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string, n, n2), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            callableStatement = CallableStatementImpl.makeCallableStatementImpl(this.t2_conn.prepareCall(string), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        try {
            this.preInvocationHandler(string2, objectArray);
            callableStatement = CallableStatementImpl.makeCallableStatementImpl(this.t2_conn.prepareCall(string, n, n2), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.t2_conn.rollback((Savepoint)((RMIWrapperImpl)((Object)savepoint)).getVendorObj());
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.t2_conn.releaseSavepoint((Savepoint)((RMIWrapperImpl)((Object)savepoint)).getVendorObj());
        ((SavepointImpl)((Object)savepoint)).close();
    }

    public void close() throws SQLException {
        String string = "close";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            if (this.t2_conn != null) {
                this.t2_conn.close();
                this.t2_conn = null;
                if (this.isPeerGoneListener) {
                    this.isPeerGoneListener = false;
                    EndPoint endPoint = ServerHelper.getClientEndPointInternal();
                    if (endPoint != null && endPoint instanceof RJVM) {
                        ((RJVM)endPoint).removePeerGoneListener((PeerGoneListener)this);
                    }
                    try {
                        UnicastRemoteObject.unexportObject((Object)this, (boolean)true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public boolean isClosed() throws SQLException {
        boolean bl = false;
        String string = "isClosed";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.t2_conn == null ? true : this.t2_conn.isClosed();
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        DatabaseMetaDataImpl databaseMetaDataImpl = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            DatabaseMetaData databaseMetaData = this.t2_conn.getMetaData();
            databaseMetaDataImpl = (DatabaseMetaDataImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.DatabaseMetaDataImpl", (Object)databaseMetaData, (boolean)true));
            databaseMetaDataImpl.init(databaseMetaData, this.rmiSettings);
            this.postInvocationHandler(string, objectArray, (Object)databaseMetaDataImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (DatabaseMetaData)((Object)databaseMetaDataImpl);
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        Statement statement = null;
        String string = "createStatement";
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string, objectArray);
            statement = StatementImpl.makeStatementImpl(this.t2_conn.createStatement(n, n2, n3), this.rmiSettings);
            this.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        CallableStatement callableStatement = null;
        String string2 = "prepareCall";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string2, objectArray);
            callableStatement = CallableStatementImpl.makeCallableStatementImpl(this.t2_conn.prepareCall(string, n, n2, n3), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, callableStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return callableStatement;
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n)};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string, n), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, nArray};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string, nArray), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string, n, n2, n3), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        PreparedStatement preparedStatement = null;
        String string2 = "prepareStatement";
        Object[] objectArray = new Object[]{string, stringArray};
        try {
            this.preInvocationHandler(string2, objectArray);
            preparedStatement = PreparedStatementImpl.makePreparedStatementImpl(this.t2_conn.prepareStatement(string, stringArray), this.rmiSettings);
            this.postInvocationHandler(string2, objectArray, preparedStatement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return preparedStatement;
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        ArrayImpl arrayImpl = null;
        String string2 = "createArrayOf";
        Object[] objectArray2 = new Object[]{string, objectArray};
        try {
            this.preInvocationHandler(string2, objectArray2);
            Array array = this.t2_conn.createArrayOf(string, objectArray);
            arrayImpl = (ArrayImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.ArrayImpl", (Object)array, (boolean)true));
            arrayImpl.init(array, this.rmiSettings);
            this.postInvocationHandler(string2, objectArray2, (Object)arrayImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray2, exception);
        }
        return (Array)((Object)arrayImpl);
    }

    public Blob createBlob() throws SQLException {
        OracleTBlobImpl oracleTBlobImpl = null;
        String string = "createBlob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            Blob blob = this.t2_conn.createBlob();
            oracleTBlobImpl = (OracleTBlobImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.OracleTBlobImpl", (Object)blob, (boolean)true));
            oracleTBlobImpl.init(blob, this.rmiSettings);
            this.postInvocationHandler(string, objectArray, (Object)oracleTBlobImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (Blob)((Object)oracleTBlobImpl);
    }

    public Clob createClob() throws SQLException {
        OracleTClobImpl oracleTClobImpl = null;
        String string = "createClob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            Clob clob = this.t2_conn.createClob();
            oracleTClobImpl = (OracleTClobImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.OracleTClobImpl", (Object)clob, (boolean)true));
            oracleTClobImpl.init(clob, this.rmiSettings);
            this.postInvocationHandler(string, objectArray, (Object)oracleTClobImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (Clob)((Object)oracleTClobImpl);
    }

    public NClob createNClob() throws SQLException {
        OracleTNClobImpl oracleTNClobImpl = null;
        String string = "createNClob";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            NClob nClob = this.t2_conn.createNClob();
            oracleTNClobImpl = (OracleTNClobImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.OracleTNClobImpl", (Object)nClob, (boolean)true));
            oracleTNClobImpl.init(nClob, this.rmiSettings);
            this.postInvocationHandler(string, objectArray, (Object)oracleTNClobImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (NClob)((Object)oracleTNClobImpl);
    }

    public SQLXML createSQLXML() throws SQLException {
        SQLXMLImpl sQLXMLImpl = null;
        String string = "createSQLXML";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            SQLXML sQLXML = this.t2_conn.createSQLXML();
            sQLXMLImpl = (SQLXMLImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.SQLXMLImpl", (Object)sQLXML, (boolean)true));
            sQLXMLImpl.init(sQLXML, this.rmiSettings);
            this.postInvocationHandler(string, objectArray, (Object)sQLXMLImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return (SQLXML)((Object)sQLXMLImpl);
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        StructImpl structImpl = null;
        String string2 = "createStruct";
        Object[] objectArray2 = new Object[]{string, objectArray};
        try {
            this.preInvocationHandler(string2, objectArray2);
            Struct struct2 = this.t2_conn.createStruct(string, objectArray);
            structImpl = (StructImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.StructImpl", (Object)struct2, (boolean)true));
            structImpl.init(struct2, this.rmiSettings);
            this.postInvocationHandler(string2, objectArray2, (Object)structImpl);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray2, exception);
        }
        return (Struct)((Object)structImpl);
    }

    public boolean isValid(int n) throws SQLException {
        boolean bl = false;
        String string = "isValid";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            bl = this.t2_conn.isValid(n);
            this.postInvocationHandler(string, objectArray, new Boolean(bl));
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return bl;
    }
}

