/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.sql.Blob;
import java.sql.SQLException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.JDBCOutputStreamImpl;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.rmi.internal.OracleTBlob;
import weblogic.jdbc.rmi.internal.OracleTBlobStub;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.server.UnicastRemoteObject;

public class OracleTBlobImpl
extends RMISkelWrapperImpl
implements InteropWriteReplaceable {
    private Blob t2_blob = null;
    private BlockGetterImpl bg = null;
    private RmiDriverSettings rmiSettings = null;
    public static final int BINARY_STREAM = 3;
    private transient Object interop = null;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof OutputStream) {
                OutputStream outputStream = (OutputStream)object;
                JDBCOutputStreamImpl jDBCOutputStreamImpl = new JDBCOutputStreamImpl(outputStream, this.rmiSettings.isVerbose(), this.rmiSettings.getChunkSize());
                object = jDBCOutputStreamImpl;
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void init(Blob blob, RmiDriverSettings rmiDriverSettings) {
        this.t2_blob = blob;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new OracleTBlobStub((OracleTBlob)object, this.rmiSettings);
        }
        return this.interop;
    }

    public static Blob makeOracleTBlobImpl(Blob blob, RmiDriverSettings rmiDriverSettings) {
        OracleTBlobImpl oracleTBlobImpl = (OracleTBlobImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.OracleTBlobImpl", (Object)blob, (boolean)true));
        oracleTBlobImpl.init(blob, rmiDriverSettings);
        return (Blob)((Object)oracleTBlobImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        if (n != 3) {
            throw new SQLException("Invalid stream type: " + n);
        }
        object = this.t2_blob.getBinaryStream();
        int n2 = this.bg.register((InputStream)object, this.rmiSettings.getChunkSize());
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockGetter getBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        return this.bg;
    }

    public void internalClose() {
        try {
            UnicastRemoteObject.unexportObject((Object)((Object)this), (boolean)true);
            this.t2_blob = null;
            this.rmiSettings = null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

