/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.sql.Clob;
import java.sql.SQLException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.JDBCOutputStreamImpl;
import weblogic.jdbc.common.internal.JDBCWriterImpl;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.rmi.internal.OracleTClob;
import weblogic.jdbc.rmi.internal.OracleTClobStub;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.jdbc.wrapper.JDBCWrapperImpl;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.server.UnicastRemoteObject;

public class OracleTClobImpl
extends RMISkelWrapperImpl
implements InteropWriteReplaceable {
    private Clob t2_clob = null;
    RmiDriverSettings rmiSettings = null;
    private BlockGetterImpl bg = null;
    private ReaderBlockGetterImpl rbg = null;
    public static final int ASCII_STREAM = 1;
    public static final int CHAR_STREAM = 2;
    transient Object interop = null;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof Writer) {
                Writer writer = (Writer)object;
                JDBCWriterImpl jDBCWriterImpl = new JDBCWriterImpl(writer, this.rmiSettings.isVerbose(), this.rmiSettings.getChunkSize());
                object = jDBCWriterImpl;
            } else if (object instanceof OutputStream) {
                OutputStream outputStream = (OutputStream)object;
                JDBCOutputStreamImpl jDBCOutputStreamImpl = new JDBCOutputStreamImpl(outputStream, this.rmiSettings.isVerbose(), this.rmiSettings.getChunkSize());
                object = jDBCOutputStreamImpl;
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void init(Clob clob, RmiDriverSettings rmiDriverSettings) {
        this.t2_clob = clob;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new OracleTClobStub((OracleTClob)object, this.rmiSettings);
        }
        return this.interop;
    }

    public static Clob makeOracleTClobImpl(Clob clob, RmiDriverSettings rmiDriverSettings) {
        OracleTClobImpl oracleTClobImpl = (OracleTClobImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.OracleTClobImpl", (Object)clob, (boolean)true));
        oracleTClobImpl.init(clob, rmiDriverSettings);
        return (Clob)((Object)oracleTClobImpl);
    }

    public int registerStream(int n) throws SQLException {
        return this.registerStream(n, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(int n, Object[] objectArray) throws SQLException {
        int n2;
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (n == 1) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            } else if (n == 2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            } else {
                throw new SQLException("Invalid stream type: " + n);
            }
        }
        if (n == 1) {
            InputStream inputStream = this.t2_clob.getAsciiStream();
            n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
        } else if (n == 2) {
            Reader reader = null;
            reader = objectArray == null ? this.t2_clob.getCharacterStream() : this.t2_clob.getCharacterStream((Long)objectArray[0], (Long)objectArray[1]);
            n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
        } else {
            throw new SQLException("Invalid stream type: " + n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockGetter getBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        return this.bg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderBlockGetter getReaderBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.rbg == null) {
                this.rbg = new ReaderBlockGetterImpl();
            }
        }
        return this.rbg;
    }

    public void internalClose() {
        try {
            UnicastRemoteObject.unexportObject((Object)((Object)this), (boolean)true);
            this.t2_clob = null;
            this.rmiSettings = null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public long position(Clob clob, long l) throws SQLException {
        long l2 = -1L;
        String string = "position";
        Object[] objectArray = new Object[]{clob, l};
        try {
            this.preInvocationHandler(string, objectArray);
            l2 = clob instanceof JDBCWrapperImpl ? ((Clob)this.getVendorObj()).position((Clob)((JDBCWrapperImpl)clob).getVendorObj(), l) : ((Clob)this.getVendorObj()).position(clob, l);
            this.postInvocationHandler(string, objectArray, l2);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return l2;
    }
}

