/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.Remote;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.internal.ParameterMetaDataImpl;
import weblogic.jdbc.rmi.internal.PreparedStatement;
import weblogic.jdbc.rmi.internal.PreparedStatementStub;
import weblogic.jdbc.rmi.internal.ResultSetImpl;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.StatementImpl;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.jdbc.wrapper.JDBCWrapperImpl;
import weblogic.rmi.extensions.StubFactory;

public class PreparedStatementImpl
extends StatementImpl
implements InteropWriteReplaceable {
    protected java.sql.PreparedStatement t2_pstmt = null;
    protected RmiDriverSettings rmiSettings = null;
    protected transient Object interop = null;

    public PreparedStatementImpl() {
    }

    public PreparedStatementImpl(java.sql.PreparedStatement preparedStatement, RmiDriverSettings rmiDriverSettings) {
        this.init(preparedStatement, rmiDriverSettings);
    }

    public void init(java.sql.PreparedStatement preparedStatement, RmiDriverSettings rmiDriverSettings) {
        super.init(preparedStatement, rmiDriverSettings);
        this.t2_pstmt = preparedStatement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public static java.sql.PreparedStatement makePreparedStatementImpl(java.sql.PreparedStatement preparedStatement, RmiDriverSettings rmiDriverSettings) {
        if (preparedStatement == null) {
            return null;
        }
        PreparedStatementImpl preparedStatementImpl = (PreparedStatementImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.PreparedStatementImpl", (Object)preparedStatement, (boolean)true));
        preparedStatementImpl.init(preparedStatement, rmiDriverSettings);
        return (java.sql.PreparedStatement)((Object)preparedStatementImpl);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new PreparedStatementStub((PreparedStatement)object, this.rmiSettings);
        }
        return this.interop;
    }

    public java.sql.PreparedStatement getImplDelegateAsPS() {
        return (java.sql.PreparedStatement)this.getImplDelegate();
    }

    public void setAsciiStream(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = new InputStreamHandler();
        ((InputStreamHandler)object).setBlockGetter(blockGetter, n2);
        this.setAsciiStream(n, (InputStream)object, n3);
    }

    public void setUnicodeStream(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setUnicodeStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = new InputStreamHandler();
        ((InputStreamHandler)object).setBlockGetter(blockGetter, n2);
        this.setUnicodeStream(n, (InputStream)object, n3);
    }

    public void setBinaryStream(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = new InputStreamHandler();
        ((InputStreamHandler)object).setBlockGetter(blockGetter, n2);
        this.setBinaryStream(n, (InputStream)object, n3);
    }

    public void setCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, int n3) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = new ReaderHandler();
        ((ReaderHandler)object).setReaderBlockGetter(readerBlockGetter, n2);
        this.setCharacterStream(n, (Reader)object, n3);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string = "setAsciiStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            this.t2_pstmt.setAsciiStream(n, inputStream, n2);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string = "setUnicodeStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            this.t2_pstmt.setUnicodeStream(n, inputStream, n2);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string = "setBinaryStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            this.t2_pstmt.setBinaryStream(n, inputStream, n2);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        String string = "setCharacterStream";
        Object[] objectArray = new Object[]{new Integer(n), reader, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            this.t2_pstmt.setCharacterStream(n, reader, n2);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{new Integer(n), object, new Integer(n2), new Integer(n3)};
        try {
            this.preInvocationHandler(string, objectArray);
            if (object instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setObject(n, ((JDBCWrapperImpl)object).getVendorObj(), n2, n3);
            } else {
                this.t2_pstmt.setObject(n, object, n2, n3);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{new Integer(n), object, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            if (object instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setObject(n, ((JDBCWrapperImpl)object).getVendorObj(), n2);
            } else {
                this.t2_pstmt.setObject(n, object, n2);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, Object object) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{new Integer(n), object};
        try {
            this.preInvocationHandler(string, objectArray);
            if (object instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setObject(n, ((JDBCWrapperImpl)object).getVendorObj());
            } else {
                this.t2_pstmt.setObject(n, object);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setRef(int n, Ref ref) throws SQLException {
        String string = "setRef";
        Object[] objectArray = new Object[]{new Integer(n), ref};
        try {
            this.preInvocationHandler(string, objectArray);
            if (ref instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setRef(n, (Ref)((JDBCWrapperImpl)ref).getVendorObj());
            } else {
                this.t2_pstmt.setRef(n, ref);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        String string = "setBlob";
        Object[] objectArray = new Object[]{new Integer(n), blob};
        try {
            this.preInvocationHandler(string, objectArray);
            if (blob instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setBlob(n, (Blob)((JDBCWrapperImpl)blob).getVendorObj());
            } else {
                this.t2_pstmt.setBlob(n, blob);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setClob(int n, Clob clob) throws SQLException {
        String string = "setClob";
        Object[] objectArray = new Object[]{new Integer(n), clob};
        try {
            this.preInvocationHandler(string, objectArray);
            if (clob instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setClob(n, (Clob)((JDBCWrapperImpl)clob).getVendorObj());
            } else {
                this.t2_pstmt.setClob(n, clob);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        String string = "setArray";
        Object[] objectArray = new Object[]{new Integer(n), array};
        try {
            this.preInvocationHandler(string, objectArray);
            if (array instanceof JDBCWrapperImpl) {
                this.t2_pstmt.setArray(n, (Array)((JDBCWrapperImpl)array).getVendorObj());
            } else {
                this.t2_pstmt.setArray(n, array);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            resultSetMetaData = this.t2_pstmt.getMetaData();
            if (resultSetMetaData != null) {
                resultSetMetaData = new ResultSetMetaDataImpl(resultSetMetaData);
            }
            this.postInvocationHandler(string, objectArray, resultSetMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return resultSetMetaData;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        ParameterMetaData parameterMetaData = null;
        String string = "getParameterMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            parameterMetaData = this.t2_pstmt.getParameterMetaData();
            if (parameterMetaData != null) {
                parameterMetaData = new ParameterMetaDataImpl(parameterMetaData);
            }
            this.postInvocationHandler(string, objectArray, parameterMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return parameterMetaData;
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = null;
        String string = "executeQuery";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            resultSet = this.getImplDelegateAsPS().executeQuery();
            if (resultSet != null) {
                resultSet = ResultSetImpl.makeResultSetImpl(resultSet, this.rmiSettings);
            }
            this.postInvocationHandler(string, objectArray, resultSet);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return resultSet;
    }

    public void setNClob(int n, NClob nClob) throws SQLException {
        String string = "setNClob";
        Object[] objectArray = new Object[]{new Integer(n), nClob};
        try {
            this.preInvocationHandler(string, objectArray);
            if (nClob instanceof JDBCWrapperImpl) {
                this.getImplDelegateAsPS().setNClob(n, (NClob)((JDBCWrapperImpl)nClob).getVendorObj());
            } else {
                this.getImplDelegateAsPS().setNClob(n, nClob);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        String string = "setSQLXML";
        Object[] objectArray = new Object[]{new Integer(n), sQLXML};
        try {
            this.preInvocationHandler(string, objectArray);
            if (sQLXML instanceof JDBCWrapperImpl) {
                this.getImplDelegateAsPS().setSQLXML(n, (SQLXML)((JDBCWrapperImpl)sQLXML).getVendorObj());
            } else {
                this.getImplDelegateAsPS().setSQLXML(n, sQLXML);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setClob(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "setClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setClob(n, readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setClob(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "setClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setClob(n, readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "setCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setCharacterStream(n, readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "setCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setCharacterStream(n, (Reader)readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setNClob(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "setNClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setNClob(n, readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setNClob(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "setNClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setNClob(n, readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setNCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "setNCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setNCharacterStream(n, readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setNCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "setNCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setNCharacterStream(n, readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setAsciiStream(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "setAsciiStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setAsciiStream(n, inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setAsciiStream(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "setAsciiStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setAsciiStream(n, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBinaryStream(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "setBinaryStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setBinaryStream(n, inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBinaryStream(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "setBinaryStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setBinaryStream(n, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBlob(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "setBlob";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setBlob(n, inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setBlob(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "setBlob";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setBlob(n, inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, ReaderBlockGetter readerBlockGetter, int n2, int n3) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, (Object)readerHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, ReaderBlockGetter readerBlockGetter, int n2, int n3, int n4) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, n3, n4};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, (Object)readerHandler, n3, n4);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, blockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, (Object)inputStreamHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void setObject(int n, BlockGetter blockGetter, int n2, int n3, int n4) throws SQLException {
        String string = "setObject";
        Object[] objectArray = new Object[]{n, blockGetter, n2, n3, n4};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.getImplDelegateAsPS().setObject(n, (Object)inputStreamHandler, n3, n4);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }
}

