/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.ParameterMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.rmi.internal.ParameterMetaDataImpl;
import weblogic.jdbc.rmi.internal.PreparedStatement;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.StatementStub;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class PreparedStatementStub
extends StatementStub
implements Serializable,
StubDelegateInfo {
    private static final long serialVersionUID = -2902370428006989865L;
    transient BlockGetter bg = null;
    transient ReaderBlockGetter rbg = null;
    protected RmiDriverSettings rmiSettings = null;
    protected PreparedStatement pstmt;

    public PreparedStatementStub() {
    }

    public PreparedStatementStub(PreparedStatement preparedStatement, RmiDriverSettings rmiDriverSettings) {
        this.init(preparedStatement, rmiDriverSettings);
    }

    public void init(PreparedStatement preparedStatement, RmiDriverSettings rmiDriverSettings) {
        super.init(preparedStatement, rmiDriverSettings);
        this.pstmt = preparedStatement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object readResolve() throws ObjectStreamException {
        PreparedStatementStub preparedStatementStub = null;
        try {
            preparedStatementStub = (PreparedStatementStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.PreparedStatementStub", (Object)this.pstmt, (boolean)false);
            preparedStatementStub.init(this.pstmt, this.rmiSettings);
            return (java.sql.PreparedStatement)((Object)preparedStatementStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.pstmt;
        }
    }

    public PreparedStatement getStubDelegateAsPS() {
        return (PreparedStatement)this.getStubDelegate();
    }

    public Object getStubDelegate() {
        return this.pstmt;
    }

    public int getRmiFetchSize() throws SQLException {
        return this.rmiSettings.getRowCacheSize();
    }

    public void setRmiFetchSize(int n) throws SQLException {
        this.pstmt.setRmiFetchSize(n);
        this.rmiSettings.setRowCacheSize(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string = "setAsciiStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            Object object;
            this.preInvocationHandler(string, objectArray);
            if (this.rmiSettings.isVerbose()) {
                object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
                JdbcDebug.JDBCRMIInternal.debug((String)object);
            }
            if (inputStream == null || n2 <= 0) {
                this.pstmt.setAsciiStream(n, inputStream, n2);
            } else {
                object = this;
                synchronized (object) {
                    if (this.bg == null) {
                        this.bg = new BlockGetterImpl();
                    }
                }
                int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
                this.pstmt.setAsciiStream(n, this.bg, n3, n2);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : setUnicodeStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "setUnicodeStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            if (inputStream == null || n2 <= 0) {
                this.pstmt.setUnicodeStream(n, inputStream, n2);
            } else {
                PreparedStatementStub preparedStatementStub = this;
                synchronized (preparedStatementStub) {
                    if (this.bg == null) {
                        this.bg = new BlockGetterImpl();
                    }
                }
                int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
                this.pstmt.setUnicodeStream(n, this.bg, n3, n2);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        String string;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "setBinaryStream";
        Object[] objectArray = new Object[]{new Integer(n), inputStream, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            if (inputStream == null || n2 <= 0) {
                this.pstmt.setBinaryStream(n, inputStream, n2);
            } else {
                PreparedStatementStub preparedStatementStub = this;
                synchronized (preparedStatementStub) {
                    if (this.bg == null) {
                        this.bg = new BlockGetterImpl();
                    }
                }
                int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
                this.pstmt.setBinaryStream(n, this.bg, n3, n2);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        String string;
        if (this.rmiSettings.isVerbose()) {
            string = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        string = "setCharacterStream";
        Object[] objectArray = new Object[]{new Integer(n), reader, new Integer(n2)};
        try {
            this.preInvocationHandler(string, objectArray);
            if (reader == null || n2 <= 0) {
                this.pstmt.setCharacterStream(n, reader, n2);
            } else {
                PreparedStatementStub preparedStatementStub = this;
                synchronized (preparedStatementStub) {
                    if (this.rbg == null) {
                        this.rbg = new ReaderBlockGetterImpl();
                    }
                }
                int n3 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
                this.pstmt.setCharacterStream(n, this.rbg, n3, n2);
            }
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            resultSetMetaData = this.pstmt.getMetaData();
            if (resultSetMetaData != null) {
                resultSetMetaData = new ResultSetMetaDataImpl(resultSetMetaData);
            }
            this.postInvocationHandler(string, objectArray, resultSetMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return resultSetMetaData;
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        ParameterMetaData parameterMetaData = null;
        String string = "getParameterMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            parameterMetaData = this.pstmt.getParameterMetaData();
            if (parameterMetaData != null) {
                parameterMetaData = new ParameterMetaDataImpl(parameterMetaData);
            }
            this.postInvocationHandler(string, objectArray, parameterMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return parameterMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        super.close();
        PreparedStatementStub preparedStatementStub = this;
        synchronized (preparedStatementStub) {
            if (this.bg != null) {
                this.bg.close();
                this.bg = null;
            }
            if (this.rbg != null) {
                this.rbg.close();
                this.rbg = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setClob(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setClob(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClob(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setClob(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setClob(n, this.rbg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setCharacterStream(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setCharacterStream(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setCharacterStream(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setCharacterStream(n, this.rbg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setNClob(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setNClob(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setNClob(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setNClob(n, this.rbg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setNCharacterStream(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setNCharacterStream(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.getStubDelegateAsPS().setNCharacterStream(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setNCharacterStream(n, this.rbg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setAsciiStream(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setAsciiStream(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setAsciiStream(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setAsciiStream(n, this.bg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setBinaryStream(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setBinaryStream(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setBinaryStream(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setBinaryStream(n, this.bg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setBlob(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setBlob(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : setBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.getStubDelegateAsPS().setBlob(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setBlob(n, this.bg, n2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsPS().setObject(n, object);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.rbg, n2);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.bg, n3);
        } else {
            this.getStubDelegateAsPS().setObject(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsPS().setObject(n, object, n2);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n3 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.rbg, n3, n2);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n4 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.bg, n4, n2);
        } else {
            this.getStubDelegateAsPS().setObject(n, object, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.getStubDelegateAsPS().setObject(n, object, n2, n3);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n4 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.rbg, n4, n2, n3);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : setObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n5 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.getStubDelegateAsPS().setObject(n, this.bg, n5, n2, n3);
        } else {
            this.getStubDelegateAsPS().setObject(n, object, n2, n3);
        }
    }
}

