/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.rmi.server.ServerNotActiveException;
import java.security.AccessController;
import weblogic.common.internal.PeerInfo;
import weblogic.common.internal.PeerInfoable;
import weblogic.jdbc.common.internal.JDBCServerHelperImpl;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.rmi.RMIWrapperImpl;
import weblogic.rmi.extensions.server.RemoteDomainSecurityHelper;
import weblogic.rmi.extensions.server.ServerHelper;
import weblogic.rmi.spi.EndPoint;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public class RMISkelWrapperImpl
extends RMIWrapperImpl {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final UnsupportedOperationException noRemoteJDBCException = new UnsupportedOperationException("Remote JDBC not supported");

    public void preInvocationHandler(String string, Object[] objectArray) throws Exception {
        super.preInvocationHandler(string, objectArray);
        if (JDBCServerHelperImpl.rmiSecure()) {
            EndPoint endPoint = null;
            PeerInfo peerInfo = null;
            try {
                endPoint = ServerHelper.getClientEndPoint();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            if (endPoint != null && endPoint instanceof PeerInfoable) {
                peerInfo = ((PeerInfoable)endPoint).getPeerInfo();
            }
            if (peerInfo == null || !peerInfo.isServer()) {
                if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("rejecting: caller not a server. " + endPoint);
                }
                throw noRemoteJDBCException;
            }
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)KERNEL_ID);
            int n = 2;
            n = RemoteDomainSecurityHelper.acceptRemoteDomainCall(endPoint.getHostID(), authenticatedSubject);
            if (n == 1) {
                if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("rejecting: invalid cross-domain subject " + authenticatedSubject);
                }
                throw noRemoteJDBCException;
            }
            if (n == 0) {
                if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("accepting call from remote domain with subject " + authenticatedSubject);
                }
                return;
            }
            if (n == 2) {
                if (!SecurityServiceManager.isKernelIdentity((AuthenticatedSubject)authenticatedSubject)) {
                    if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                        JdbcDebug.JDBCRMI.debug("rejecting: invalid subject for intra-domain call " + authenticatedSubject);
                    }
                    throw noRemoteJDBCException;
                }
                if (JdbcDebug.JDBCRMI.isDebugEnabled()) {
                    JdbcDebug.JDBCRMI.debug("accepting intra-domain call with subject " + authenticatedSubject);
                }
            }
        }
    }
}

