/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataCache;
import weblogic.jdbc.rmi.internal.ResultSetReader;
import weblogic.jdbc.rmi.internal.ResultSetRowCache;
import weblogic.jdbc.rmi.internal.ResultSetStub;

public class ResultSetCachingReader
implements ResultSetReader,
Serializable {
    private static final long serialVersionUID = 3906341926472915638L;
    private ResultSetStub rs;
    private transient ResultSetRowCache rowCache = null;
    private transient ResultSetMetaDataCache mdCache = null;

    public ResultSetCachingReader(ResultSetStub resultSetStub) throws SQLException {
        this.rs = resultSetStub;
        this.mdCache = resultSetStub.getMetaDataCache();
        this.rowCache = this.rs.getNextRowCache();
        this.rowCache.setMetaDataCache(this.mdCache);
        this.rowCache.beforeFirstRow();
    }

    public synchronized boolean next() throws SQLException {
        if (this.rowCache.next()) {
            return true;
        }
        if (this.rowCache.isTrueSetFinished()) {
            return false;
        }
        this.rowCache = this.rs.getNextRowCache();
        this.rowCache.setMetaDataCache(this.mdCache);
        return this.rowCache.getRowCount() > 0;
    }

    public boolean wasNull() throws SQLException {
        return this.rowCache.wasNull();
    }

    public String getString(int n) throws SQLException {
        return this.rowCache.getString(n);
    }

    public boolean getBoolean(int n) throws SQLException {
        return this.rowCache.getBoolean(n);
    }

    public byte getByte(int n) throws SQLException {
        return this.rowCache.getByte(n);
    }

    public short getShort(int n) throws SQLException {
        return this.rowCache.getShort(n);
    }

    public int getInt(int n) throws SQLException {
        return this.rowCache.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        return this.rowCache.getLong(n);
    }

    public float getFloat(int n) throws SQLException {
        return this.rowCache.getFloat(n);
    }

    public double getDouble(int n) throws SQLException {
        return this.rowCache.getDouble(n);
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.rowCache.getBigDecimal(n, n2);
    }

    public byte[] getBytes(int n) throws SQLException {
        return this.rowCache.getBytes(n);
    }

    public Date getDate(int n) throws SQLException {
        return this.rowCache.getDate(n);
    }

    public Time getTime(int n) throws SQLException {
        return this.rowCache.getTime(n);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this.rowCache.getTimestamp(n);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        String string = "getAsciiStream is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = "getUnicodeStream is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        String string = "getBinaryStream is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public String getString(String string) throws SQLException {
        return this.rowCache.getString(this.mdCache.findColumn(string));
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.rowCache.getBoolean(this.mdCache.findColumn(string));
    }

    public byte getByte(String string) throws SQLException {
        return this.rowCache.getByte(this.mdCache.findColumn(string));
    }

    public short getShort(String string) throws SQLException {
        return this.rowCache.getShort(this.mdCache.findColumn(string));
    }

    public int getInt(String string) throws SQLException {
        return this.rowCache.getInt(this.mdCache.findColumn(string));
    }

    public long getLong(String string) throws SQLException {
        return this.rowCache.getLong(this.mdCache.findColumn(string));
    }

    public float getFloat(String string) throws SQLException {
        return this.rowCache.getFloat(this.mdCache.findColumn(string));
    }

    public double getDouble(String string) throws SQLException {
        return this.rowCache.getDouble(this.mdCache.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.rowCache.getBigDecimal(this.mdCache.findColumn(string), n);
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.rowCache.getBytes(this.mdCache.findColumn(string));
    }

    public Date getDate(String string) throws SQLException {
        return this.rowCache.getDate(this.mdCache.findColumn(string));
    }

    public Time getTime(String string) throws SQLException {
        return this.rowCache.getTime(this.mdCache.findColumn(string));
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.rowCache.getTimestamp(this.mdCache.findColumn(string));
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        String string2 = "getAsciiStream is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        String string2 = "getUnicodeStream is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        String string2 = "getBinaryStream is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Object getObject(int n) throws SQLException {
        return this.rowCache.getObject(n);
    }

    public Object getObject(String string) throws SQLException {
        return this.rowCache.getObject(this.mdCache.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        return this.mdCache.findColumn(string);
    }

    public Reader getCharacterStream(int n) throws SQLException {
        String string = "getCharacterStream is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Reader getCharacterStream(String string) throws SQLException {
        String string2 = "getCharacterStream is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this.rowCache.getBigDecimal(n);
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.rowCache.getBigDecimal(this.mdCache.findColumn(string));
    }

    public boolean isBeforeFirst() throws SQLException {
        String string = "isBeforeFirst is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public boolean isAfterLast() throws SQLException {
        String string = "isAfterLast is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public boolean isFirst() throws SQLException {
        String string = "isFirst is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public boolean isLast() throws SQLException {
        String string = "isLast is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public int getRow() throws SQLException {
        String string = "getRow is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Object getObject(int n, Map map) throws SQLException {
        String string = "getObject(int col, java.util.Map map) is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Ref getRef(int n) throws SQLException {
        String string = "getRef is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Blob getBlob(int n) throws SQLException {
        String string = "getBlob is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Clob getClob(int n) throws SQLException {
        String string = "getClob is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Array getArray(int n) throws SQLException {
        String string = "getArray is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Object getObject(String string, Map map) throws SQLException {
        String string2 = "getObject(String col, java.util.Map map) is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Ref getRef(String string) throws SQLException {
        String string2 = "getRef is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Blob getBlob(String string) throws SQLException {
        String string2 = "getBlob is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Clob getClob(String string) throws SQLException {
        String string2 = "getClob is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Array getArray(String string) throws SQLException {
        String string2 = "getArray is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        String string = " getDate(int col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        String string2 = " getDate(String col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        String string = " getTime(int col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        String string2 = " getTime(String col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        String string = " getTimestamp(int col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        String string2 = " getTimestamp(String col, java.util.Calendar cal) is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        String string = "getNCharacterStream is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        String string2 = "getNCharacterStream is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public NClob getNClob(int n) throws SQLException {
        String string = "getNClob is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public NClob getNClob(String string) throws SQLException {
        String string2 = "getNClob is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public String getNString(int n) throws SQLException {
        return this.rowCache.getNString(n);
    }

    public String getNString(String string) throws SQLException {
        return this.rowCache.getNString(this.mdCache.findColumn(string));
    }

    public RowId getRowId(int n) throws SQLException {
        String string = "getRowId is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public RowId getRowId(String string) throws SQLException {
        String string2 = "getRowId is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public SQLXML getSQLXML(int n) throws SQLException {
        String string = "getRowId is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        String string2 = "getRowId is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }

    public URL getURL(int n) throws SQLException {
        String string = "getURL is not supported with row caching turned on. ";
        throw new SQLException(string);
    }

    public URL getURL(String string) throws SQLException {
        String string2 = "getURL is not supported with row caching turned on. ";
        throw new SQLException(string2);
    }
}

