/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.internal.ArrayImpl;
import weblogic.jdbc.rmi.internal.OracleTBlobImpl;
import weblogic.jdbc.rmi.internal.OracleTClobImpl;
import weblogic.jdbc.rmi.internal.OracleTNClobImpl;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RefImpl;
import weblogic.jdbc.rmi.internal.ResultSet;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataCache;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataImpl;
import weblogic.jdbc.rmi.internal.ResultSetRowCache;
import weblogic.jdbc.rmi.internal.ResultSetStub;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.SQLXMLImpl;
import weblogic.jdbc.rmi.internal.StatementImpl;
import weblogic.jdbc.rmi.internal.StructImpl;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.server.UnicastRemoteObject;

public class ResultSetImpl
extends RMISkelWrapperImpl
implements InteropWriteReplaceable {
    private java.sql.ResultSet t2_rs = null;
    private BlockGetter bg = new BlockGetterImpl();
    private ReaderBlockGetter rbg = null;
    private RmiDriverSettings rmiSettings = null;
    private ResultSetMetaDataCache mdCache = null;
    private ResultSetRowCache nextRowCache = null;
    private transient Object interop = null;
    public static final int ASCII_STREAM = 1;
    public static final int UNICODE_STREAM = 2;
    public static final int BINARY_STREAM = 3;
    public static final int CHARACTER_STREAM = 4;
    public static final int NCHARACTER_STREAM = 5;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof java.sql.ResultSet) {
                object = ResultSetImpl.makeResultSetImpl((java.sql.ResultSet)object, this.rmiSettings);
            } else if (object instanceof Blob) {
                object = OracleTBlobImpl.makeOracleTBlobImpl((Blob)object, this.rmiSettings);
            } else if (object instanceof Clob) {
                object = OracleTClobImpl.makeOracleTClobImpl((Clob)object, this.rmiSettings);
            } else if (object instanceof Struct) {
                object = StructImpl.makeStructImpl((Struct)object, this.rmiSettings);
            } else if (object instanceof Ref) {
                object = RefImpl.makeRefImpl((Ref)object, this.rmiSettings);
            } else if (object instanceof Array) {
                object = ArrayImpl.makeArrayImpl((Array)object, this.rmiSettings);
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void init(java.sql.ResultSet resultSet, RmiDriverSettings rmiDriverSettings) {
        this.t2_rs = resultSet;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public static java.sql.ResultSet makeResultSetImpl(java.sql.ResultSet resultSet, RmiDriverSettings rmiDriverSettings) {
        ResultSetImpl resultSetImpl = (ResultSetImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.ResultSetImpl", (Object)resultSet, (boolean)true));
        resultSetImpl.init(resultSet, rmiDriverSettings);
        return (java.sql.ResultSet)((Object)resultSetImpl);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new ResultSetStub((ResultSet)object, this.rmiSettings);
        }
        return this.interop;
    }

    public boolean isRowCaching() throws SQLException {
        if (this.rmiSettings.getRowCacheSize() <= 1) {
            if (this.rmiSettings.isVerbose()) {
                JdbcDebug.JDBCRMIInternal.debug("rmiSettings.rowCacheSize is " + this.rmiSettings.getRowCacheSize() + " so returning false");
            }
            return false;
        }
        if (this.mdCache == null) {
            this.mdCache = new ResultSetMetaDataCache(this.t2_rs);
        }
        try {
            if (this.isResultSetCacheable()) {
                this.nextRowCache = new ResultSetRowCache(this.rmiSettings.getRowCacheSize(), this.t2_rs, this.mdCache);
            } else {
                this.rmiSettings.setRowCacheSize(0);
                if (this.rmiSettings.isVerbose()) {
                    JdbcDebug.JDBCRMIInternal.debug("Result set is not cacheable");
                }
            }
        }
        catch (Exception exception) {
            if (this.rmiSettings.isVerbose()) {
                JdbcDebug.JDBCRMIInternal.debug("Exception received: " + exception);
                JDBCLogger.logStackTrace((Throwable)exception);
            }
            this.rmiSettings.setRowCacheSize(-1);
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException(exception.toString());
        }
        if (this.rmiSettings.isVerbose()) {
            JdbcDebug.JDBCRMIInternal.debug("isRowCaching: rmiSettings.rowCacheSize is " + this.rmiSettings.getRowCacheSize());
        }
        return this.rmiSettings.getRowCacheSize() > 1;
    }

    private boolean isResultSetCacheable() throws SQLException {
        block4: {
            try {
                if (this.t2_rs.getType() != 1003) {
                    return false;
                }
                if (this.t2_rs.getConcurrency() != 1007) {
                    return false;
                }
            }
            catch (SQLException sQLException) {
                if (!this.rmiSettings.isVerbose()) break block4;
                JdbcDebug.JDBCRMIInternal.debug("Trapped exception: " + sQLException);
                JDBCLogger.logStackTrace((Throwable)sQLException);
            }
        }
        return ResultSetRowCache.isCacheable(this.mdCache);
    }

    public ResultSetMetaDataCache getMetaDataCache() throws SQLException {
        if (this.mdCache == null) {
            this.mdCache = new ResultSetMetaDataCache(this.t2_rs);
        }
        return this.mdCache;
    }

    public ResultSetRowCache getNextRowCache() throws SQLException {
        ResultSetRowCache resultSetRowCache = this.nextRowCache;
        if (!resultSetRowCache.isTrueSetFinished()) {
            this.nextRowCache = new ResultSetRowCache(this.rmiSettings.getRowCacheSize(), this.t2_rs, this.mdCache);
            if (this.nextRowCache.getRowCount() < 1) {
                resultSetRowCache.setTrueSetFinished(true);
            }
        }
        return resultSetRowCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockGetter getBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        return this.bg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderBlockGetter getReaderBlockGetter() throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getReaderBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.rbg == null) {
                this.rbg = new ReaderBlockGetterImpl();
            }
        }
        return this.rbg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(int n, int n2) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (n2 == 4 || n2 == 5) {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            object = null;
            object = n2 == 4 ? this.t2_rs.getCharacterStream(n) : this.t2_rs.getNCharacterStream(n);
            if (object == null) {
                return -1;
            }
            return this.rbg.register((Reader)object, this.rmiSettings.getChunkSize());
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        if (n2 == 1) {
            object = this.t2_rs.getAsciiStream(n);
        } else if (n2 == 2) {
            object = this.t2_rs.getUnicodeStream(n);
        } else if (n2 == 3) {
            object = this.t2_rs.getBinaryStream(n);
        } else {
            throw new SQLException("Invalid stream type: " + n2);
        }
        if (object == null) {
            return -1;
        }
        int n3 = this.bg.register((InputStream)object, this.rmiSettings.getChunkSize());
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(String string, int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        if (n == 4 || n == 5) {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            object = null;
            object = n == 4 ? this.t2_rs.getCharacterStream(string) : this.t2_rs.getNCharacterStream(string);
            if (object == null) {
                return -1;
            }
            return this.rbg.register((Reader)object, this.rmiSettings.getChunkSize());
        }
        if (n == 1) {
            object = this.t2_rs.getAsciiStream(string);
        } else if (n == 2) {
            object = this.t2_rs.getUnicodeStream(string);
        } else if (n == 3) {
            object = this.t2_rs.getBinaryStream(string);
        } else {
            throw new SQLException("Invalid stream type: " + n);
        }
        if (object == null) {
            return -1;
        }
        int n2 = this.bg.register((InputStream)object, this.rmiSettings.getChunkSize());
        return n2;
    }

    public void close() throws SQLException {
        this.t2_rs.close();
        if (this.bg != null) {
            this.bg.close();
        }
        if (this.rbg != null) {
            this.rbg.close();
        }
        try {
            UnicastRemoteObject.unexportObject((Object)((Object)this), (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public Statement getStatement() throws SQLException {
        Statement statement = null;
        String string = "getStatement";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            statement = this.t2_rs.getStatement();
            if (statement != null) {
                statement = StatementImpl.makeStatementImpl(statement, this.rmiSettings);
            }
            this.postInvocationHandler(string, objectArray, statement);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return statement;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = null;
        String string = "getMetaData";
        Object[] objectArray = new Object[]{};
        try {
            this.preInvocationHandler(string, objectArray);
            resultSetMetaData = this.t2_rs.getMetaData();
            if (resultSetMetaData != null) {
                resultSetMetaData = new ResultSetMetaDataImpl(resultSetMetaData);
            }
            this.postInvocationHandler(string, objectArray, resultSetMetaData);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return resultSetMetaData;
    }

    public NClob getNClob(int n) throws SQLException {
        NClob nClob = null;
        String string = "getNClob";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            nClob = this.t2_rs.getNClob(n);
            if (nClob != null) {
                nClob = OracleTNClobImpl.makeOracleTNClobImpl(nClob, this.rmiSettings);
            }
            this.postInvocationHandler(string, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return nClob;
    }

    public NClob getNClob(String string) throws SQLException {
        NClob nClob = null;
        String string2 = "getNClob";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            nClob = this.t2_rs.getNClob(string);
            if (nClob != null) {
                nClob = OracleTNClobImpl.makeOracleTNClobImpl(nClob, this.rmiSettings);
            }
            this.postInvocationHandler(string2, objectArray, nClob);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return nClob;
    }

    public SQLXML getSQLXML(int n) throws SQLException {
        SQLXML sQLXML = null;
        String string = "getSQLXML";
        Object[] objectArray = new Object[]{new Integer(n)};
        try {
            this.preInvocationHandler(string, objectArray);
            sQLXML = this.t2_rs.getSQLXML(n);
            if (sQLXML != null) {
                sQLXML = SQLXMLImpl.makeSQLXMLImpl(sQLXML, this.rmiSettings);
            }
            this.postInvocationHandler(string, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return sQLXML;
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        SQLXML sQLXML = null;
        String string2 = "getSQLXML";
        Object[] objectArray = new Object[]{string};
        try {
            this.preInvocationHandler(string2, objectArray);
            sQLXML = this.t2_rs.getSQLXML(string);
            if (sQLXML != null) {
                sQLXML = SQLXMLImpl.makeSQLXMLImpl(sQLXML, this.rmiSettings);
            }
            this.postInvocationHandler(string2, objectArray, sQLXML);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string2, objectArray, exception);
        }
        return sQLXML;
    }

    public void updateNClob(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "updateNClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateNClob(n, (Reader)readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateNClob(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "updateNClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateNClob(n, (Reader)readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateClob(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "updateClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateClob(n, (Reader)readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateClob(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "updateClob";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateClob(n, (Reader)readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "updateCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateCharacterStream(n, (Reader)readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, int n3) throws SQLException {
        String string = "updateCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateCharacterStream(n, (Reader)readerHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "updateCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateCharacterStream(n, (Reader)readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateNCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "updateNCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateNCharacterStream(n, (Reader)readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateNCharacterStream(int n, ReaderBlockGetter readerBlockGetter, int n2, long l) throws SQLException {
        String string = "updateNCharacterStream";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateNCharacterStream(n, (Reader)readerHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateAsciiStream(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "updateAsciiStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateAsciiStream(n, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateAsciiStream(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        String string = "updateAsciiStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateAsciiStream(n, (InputStream)inputStreamHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateAsciiStream(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "updateAsciiStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateAsciiStream(n, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateBinaryStream(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "updateBinaryStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateBinaryStream(n, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateBinaryStream(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        String string = "updateBinaryStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateBinaryStream(n, (InputStream)inputStreamHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateBinaryStream(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "updateBinaryStream";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateBinaryStream(n, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateBlob(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "updateBlob";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateBlob(n, (InputStream)inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateBlob(int n, BlockGetter blockGetter, int n2, long l) throws SQLException {
        String string = "updateBlob";
        Object[] objectArray = new Object[]{n, blockGetter, n2, l};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateBlob(n, (InputStream)inputStreamHandler, l);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateObject(int n, ReaderBlockGetter readerBlockGetter, int n2) throws SQLException {
        String string = "updateObject";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateObject(n, (Object)readerHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateObject(int n, ReaderBlockGetter readerBlockGetter, int n2, int n3) throws SQLException {
        String string = "updateObject";
        Object[] objectArray = new Object[]{n, readerBlockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            ReaderHandler readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter(readerBlockGetter, n2);
            this.t2_rs.updateObject(n, (Object)readerHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateObject(int n, BlockGetter blockGetter, int n2) throws SQLException {
        String string = "updateObject";
        Object[] objectArray = new Object[]{n, blockGetter, n2};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateObject(n, (Object)inputStreamHandler);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }

    public void updateObject(int n, BlockGetter blockGetter, int n2, int n3) throws SQLException {
        String string = "updateObject";
        Object[] objectArray = new Object[]{n, blockGetter, n2, n3};
        try {
            this.preInvocationHandler(string, objectArray);
            InputStreamHandler inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter(blockGetter, n2);
            this.t2_rs.updateObject(n, (Object)inputStreamHandler, n3);
            this.postInvocationHandler(string, objectArray, null);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
    }
}

