/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class ResultSetMetaDataCache
implements Serializable {
    private int[] cachedTypes;
    private HashMap nameColLookup;
    private static final int INITIAL_HASH_SIZE = 89;

    ResultSetMetaDataCache() {
    }

    ResultSetMetaDataCache(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return;
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.cachedTypes = new int[n];
        this.nameColLookup = new HashMap(89);
        for (int i = 0; i < n; ++i) {
            this.cachedTypes[i] = resultSetMetaData.getColumnType(i + 1);
            String string = resultSetMetaData.getColumnName(i + 1);
            this.nameColLookup.put(string.toLowerCase(), new Integer(i + 1));
        }
    }

    int getColumnCount() {
        return this.cachedTypes.length;
    }

    int getColumnType(int n) {
        return this.cachedTypes[n - 1];
    }

    int getColumnTypeZeroBased(int n) {
        return this.cachedTypes[n];
    }

    int getColumnType(String string) throws SQLException {
        return this.getColumnType(this.findColumn(string));
    }

    public int findColumn(String string) throws SQLException {
        String string2 = string.toLowerCase();
        Integer n = (Integer)this.nameColLookup.get(string2);
        if (n == null) {
            throw new SQLException("no such column in this ResultSet:" + string);
        }
        return n;
    }
}

