/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.PrintStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataCache;

public class ResultSetRowCache
implements Serializable {
    static final long serialVersionUID = 819366818399178928L;
    private boolean isTrueSetFinished = false;
    private int cacheRows;
    private final int cacheCols;
    private Object[] recordCache;
    private transient int currRowIdx = 0;
    private transient boolean wasNullFlag = false;
    private transient boolean haveCalledGet = false;
    private transient ResultSetMetaDataCache mdCache = null;
    private static final String CONVERSIONERR = "this type conversion is unsupported when row caching is on";

    public ResultSetRowCache() {
        this.cacheCols = 0;
    }

    public ResultSetRowCache(int n, ResultSet resultSet, ResultSetMetaDataCache resultSetMetaDataCache) throws SQLException {
        this.cacheRows = 0;
        this.cacheCols = resultSetMetaDataCache.getColumnCount();
        this.recordCache = new Object[n * this.cacheCols];
        for (int i = 0; i < n; ++i) {
            if (resultSet.next()) {
                int n2 = i * this.cacheCols;
                for (int j = 0; j < this.cacheCols; ++j) {
                    this.recordCache[n2 + j] = ResultSetRowCache.getFieldAsObject(resultSetMetaDataCache.getColumnTypeZeroBased(j), j + 1, resultSet);
                }
                ++this.cacheRows;
                continue;
            }
            this.isTrueSetFinished = true;
            break;
        }
    }

    static boolean isCacheable(ResultSetMetaDataCache resultSetMetaDataCache) {
        int n = resultSetMetaDataCache.getColumnCount();
        for (int i = 0; i < n; ++i) {
            int n2 = resultSetMetaDataCache.getColumnTypeZeroBased(i);
            if (ResultSetRowCache.isCacheable(n2)) continue;
            return false;
        }
        return true;
    }

    void setMetaDataCache(ResultSetMetaDataCache resultSetMetaDataCache) {
        this.mdCache = resultSetMetaDataCache;
    }

    synchronized void beforeFirstRow() {
        this.currRowIdx = -1;
    }

    synchronized int getRowCount() {
        return this.cacheRows;
    }

    synchronized boolean wasNull() throws SQLException {
        if (!this.haveCalledGet) {
            throw new SQLException("No getXXX() has been called on a column of the current row");
        }
        return this.wasNullFlag;
    }

    String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    synchronized String getString(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        return object.toString();
    }

    synchronized boolean getBoolean(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return false;
        }
        String string = object.toString();
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            return false;
        }
        if ((string = string.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("yes")) {
            return true;
        }
        if (string.equalsIgnoreCase("no")) {
            return false;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            if (string.indexOf(".") != -1) {
                double d = new Double(string);
                return d != 0.0;
            }
            long l = new Long(string);
            return l != 0L;
        }
        catch (Exception exception) {
            return false;
        }
    }

    synchronized byte getByte(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Byte.parseByte((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Integer)object).byteValue();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).byteValue();
            }
            case -5: {
                return ((Long)object).byteValue();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized short getShort(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Short.parseShort((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Integer)object).shortValue();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).shortValue();
            }
            case -5: {
                return ((Long)object).shortValue();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized int getInt(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Integer.parseInt((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return (Integer)object;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).intValue();
            }
            case -5: {
                return ((Long)object).intValue();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1;
                }
                return 0;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized long getLong(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0L;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Long.parseLong((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Integer)object).longValue();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).longValue();
            }
            case -5: {
                return (Long)object;
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0.0f;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Float.parseFloat((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Integer)object).floatValue();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).floatValue();
            }
            case -5: {
                return ((Long)object).floatValue();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1.0f;
                }
                return 0.0f;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return 0.0;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Double.parseDouble((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return ((Integer)object).doubleValue();
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return ((BigDecimal)object).doubleValue();
            }
            case -5: {
                return ((Long)object).doubleValue();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return new BigDecimal((String)object);
            }
            case -6: 
            case 4: 
            case 5: {
                return new BigDecimal(((Integer)object).doubleValue());
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return (BigDecimal)object;
            }
            case -5: {
                return new BigDecimal(((Long)object).doubleValue());
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return new BigDecimal(1.0);
                }
                return new BigDecimal(0.0);
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        return bigDecimal.setScale(n2);
    }

    synchronized byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        switch (this.mdCache.getColumnType(n)) {
            case -3: 
            case -2: {
                return (byte[])object;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized Date getDate(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Date.valueOf((String)object);
            }
            case 91: {
                return (Date)object;
            }
            case 93: {
                return new Date(((Timestamp)object).getTime());
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized Time getTime(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Time.valueOf((String)object);
            }
            case 92: {
                return (Time)object;
            }
            case 93: {
                return new Time(((Timestamp)object).getTime());
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized Timestamp getTimestamp(int n) throws SQLException {
        Object object = this.getObject(n);
        if (this.checkNull(object)) {
            return null;
        }
        switch (this.mdCache.getColumnType(n)) {
            case 1: 
            case 12: {
                return Timestamp.valueOf((String)object);
            }
            case 91: {
                if (object instanceof Timestamp) {
                    return (Timestamp)object;
                }
                return new Timestamp(((Date)object).getTime());
            }
            case 92: {
                return new Timestamp(((Time)object).getTime());
            }
            case 93: {
                return (Timestamp)object;
            }
        }
        throw new SQLException(CONVERSIONERR);
    }

    synchronized Object getObject(int n) throws SQLException {
        if (n < 1 || n > this.cacheCols) {
            String string = "Invalid column index: " + n;
            throw new SQLException(string);
        }
        this.haveCalledGet = true;
        int n2 = this.currRowIdx * this.cacheCols + (n - 1);
        return this.recordCache[n2];
    }

    synchronized boolean isTrueSetFinished() {
        return this.isTrueSetFinished;
    }

    synchronized void setTrueSetFinished(boolean bl) {
        this.isTrueSetFinished = bl;
    }

    synchronized boolean next() {
        this.haveCalledGet = false;
        ++this.currRowIdx;
        return this.currRowIdx < this.cacheRows;
    }

    public synchronized void dumpCache(PrintStream printStream) {
        for (int i = 0; i < this.cacheRows; ++i) {
            for (int j = 0; j < this.cacheCols; ++j) {
                printStream.print("ROW: " + i + "\tCOL: " + j + "\tOBJ: ");
                if (this.recordCache[i * this.cacheCols + j] != null) {
                    System.out.println(this.recordCache[i * this.cacheCols + j]);
                    continue;
                }
                System.out.println("NULL");
            }
        }
    }

    private static Object getFieldAsObject(int n, int n2, ResultSet resultSet) throws SQLException {
        Object object;
        switch (n) {
            case 1: 
            case 12: {
                object = resultSet.getString(n2);
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(resultSet.getInt(n2));
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                try {
                    object = resultSet.getBigDecimal(n2);
                }
                catch (SQLException sQLException) {
                    object = new BigDecimal(resultSet.getString(n2));
                }
                break;
            }
            case -5: {
                object = new Long(resultSet.getLong(n2));
                break;
            }
            case 91: {
                object = resultSet.getDate(n2);
                Timestamp timestamp = resultSet.getTimestamp(n2);
                if (object == null || timestamp == null || timestamp.getTime() == ((Date)object).getTime()) break;
                object = timestamp;
                break;
            }
            case 92: {
                object = resultSet.getTime(n2);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(n2);
                break;
            }
            case -7: 
            case 16: {
                object = new Boolean(resultSet.getBoolean(n2));
                break;
            }
            case -3: 
            case -2: {
                object = resultSet.getBytes(n2);
                break;
            }
            case -15: 
            case -9: {
                object = resultSet.getNString(n2);
                break;
            }
            default: {
                object = null;
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    private static boolean isCacheable(int n) {
        switch (n) {
            case -15: 
            case -9: 
            case -7: 
            case -6: 
            case -5: 
            case -3: 
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private boolean checkNull(Object object) {
        this.wasNullFlag = object == null;
        return this.wasNullFlag;
    }
}

