/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.internal.ResultSet;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataCache;
import weblogic.jdbc.rmi.internal.ResultSetMetaDataImpl;
import weblogic.jdbc.rmi.internal.ResultSetRowCache;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.RemoteHelper;

public class ResultSetStub
extends RMIStubWrapperImpl
implements Serializable {
    private static final long serialVersionUID = 3023484301546933309L;
    ResultSet remoteRs;
    private RmiDriverSettings rmiSettings;
    private transient ResultSetRowCache currRowCache;
    private transient BlockGetter bg = null;
    private transient ReaderBlockGetter rbg = null;

    public ResultSetStub() {
    }

    public ResultSetStub(ResultSet resultSet, RmiDriverSettings rmiDriverSettings) {
        this.init(resultSet, rmiDriverSettings);
    }

    public void init(ResultSet resultSet, RmiDriverSettings rmiDriverSettings) {
        this.remoteRs = resultSet;
        this.rmiSettings = rmiDriverSettings;
    }

    public Object readResolve() throws ObjectStreamException {
        ResultSetStub resultSetStub = null;
        try {
            resultSetStub = (ResultSetStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.ResultSetStub", (Object)this.remoteRs, (boolean)false);
            resultSetStub.init(this.remoteRs, this.rmiSettings);
            return (java.sql.ResultSet)((Object)resultSetStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return resultSetStub;
        }
    }

    public Object getStub() {
        if (this.rmiSettings.isVerbose()) {
            JdbcDebug.JDBCRMIInternal.debug("getStub remoteRs: " + this.remoteRs);
        }
        return this.remoteRs;
    }

    public boolean isRowCaching() throws SQLException {
        if (RemoteHelper.isCollocated((Object)this.remoteRs)) {
            this.rmiSettings.setRowCacheSize(0);
            return false;
        }
        return this.remoteRs.isRowCaching();
    }

    public int getRowCacheSize() {
        return this.rmiSettings.getRowCacheSize();
    }

    public ResultSetRowCache getNextRowCache() throws SQLException {
        return this.remoteRs.getNextRowCache();
    }

    public ResultSetMetaDataCache getMetaDataCache() throws SQLException {
        return this.remoteRs.getMetaDataCache();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.remoteRs.getMetaData();
        if (resultSetMetaData == null) {
            return null;
        }
        return new ResultSetMetaDataImpl(resultSetMetaData);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n2 = this.remoteRs.registerStream(n, 1);
        if (n2 == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n2);
        return inputStreamHandler;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n = this.remoteRs.registerStream(string, 1);
        if (n == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n);
        return inputStreamHandler;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getUnicodeStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n2 = this.remoteRs.registerStream(n, 2);
        if (n2 == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n2);
        return inputStreamHandler;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n = this.remoteRs.registerStream(string, 2);
        if (n == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n);
        return inputStreamHandler;
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n2 = this.remoteRs.registerStream(n, 3);
        if (n2 == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n2);
        return inputStreamHandler;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getBlockGetter();
        int n = this.remoteRs.registerStream(string, 3);
        if (n == -1) {
            return null;
        }
        InputStreamHandler inputStreamHandler = new InputStreamHandler();
        inputStreamHandler.setBlockGetter((BlockGetter)object, n);
        return inputStreamHandler;
    }

    public Reader getCharacterStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getReaderBlockGetter();
        int n2 = this.remoteRs.registerStream(n, 4);
        if (n2 == -1) {
            return null;
        }
        ReaderHandler readerHandler = new ReaderHandler();
        readerHandler.setReaderBlockGetter((ReaderBlockGetter)object, n2);
        return readerHandler;
    }

    public Reader getCharacterStream(String string) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getReaderBlockGetter();
        int n = this.remoteRs.registerStream(string, 4);
        if (n == -1) {
            return null;
        }
        ReaderHandler readerHandler = new ReaderHandler();
        readerHandler.setReaderBlockGetter((ReaderBlockGetter)object, n);
        return readerHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        ResultSetStub resultSetStub;
        if (this.rmiSettings.isVerbose()) {
            String string = "time=" + System.currentTimeMillis() + " : close";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        try {
            this.remoteRs.close();
            Object var3_2 = null;
            resultSetStub = this;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ResultSetStub resultSetStub2 = this;
            synchronized (resultSetStub2) {
                if (this.bg != null) {
                    this.bg.close();
                    this.bg = null;
                }
                if (this.rbg != null) {
                    this.rbg.close();
                    this.rbg = null;
                }
            }
            throw throwable;
        }
        synchronized (resultSetStub) {
            if (this.bg != null) {
                this.bg.close();
                this.bg = null;
            }
            if (this.rbg != null) {
                this.rbg.close();
                this.rbg = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNClob(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateNClob(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateNClob(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateNClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateNClob(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateNClob(n, this.rbg, n2, l);
        }
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.remoteRs.findColumn(string), reader);
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.remoteRs.findColumn(string), reader, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateClob(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateClob(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateClob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateClob(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateClob(n, this.rbg, n2, l);
        }
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.remoteRs.findColumn(string), reader);
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.remoteRs.findColumn(string), reader, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateCharacterStream(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateCharacterStream(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateCharacterStream(n, reader, n2);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n3 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateCharacterStream(n, this.rbg, n3, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateCharacterStream(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateCharacterStream(n, this.rbg, n2, l);
        }
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.remoteRs.findColumn(string), reader);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.remoteRs.findColumn(string), reader, n);
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.remoteRs.findColumn(string), reader, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateNCharacterStream(n, reader);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateNCharacterStream(n, this.rbg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (reader == null) {
            this.remoteRs.updateNCharacterStream(n, reader, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateNCharacterStream(n, this.rbg, n2, l);
        }
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.remoteRs.findColumn(string), reader);
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.remoteRs.findColumn(string), reader, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateAsciiStream(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateAsciiStream(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateAsciiStream(n, inputStream, n2);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateAsciiStream(n, this.bg, n3, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateAsciiStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateAsciiStream(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateAsciiStream(n, this.bg, n2, l);
        }
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.remoteRs.findColumn(string), inputStream);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.remoteRs.findColumn(string), inputStream, n);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.remoteRs.findColumn(string), inputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateBinaryStream(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateBinaryStream(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateBinaryStream(n, inputStream, n2);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateBinaryStream(n, this.bg, n3, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateBinaryStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateBinaryStream(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateBinaryStream(n, this.bg, n2, l);
        }
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.remoteRs.findColumn(string), inputStream);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.remoteRs.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.remoteRs.findColumn(string), inputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateBlob(n, inputStream);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateBlob(n, this.bg, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : updateBlob";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        if (inputStream == null) {
            this.remoteRs.updateBlob(n, inputStream, l);
        } else {
            object = this;
            synchronized (object) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n2 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateBlob(n, this.bg, n2, l);
        }
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.remoteRs.findColumn(string), inputStream);
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.remoteRs.findColumn(string), inputStream, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.remoteRs.updateObject(n, object);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : updateObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n2 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateObject(n, this.rbg, n2);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : updateObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n3 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateObject(n, this.bg, n3);
        } else {
            this.remoteRs.updateObject(n, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObject(int n, Object object, int n2) throws SQLException {
        if (object == null) {
            this.remoteRs.updateObject(n, object, n2);
        } else if (object instanceof Reader) {
            Object object2;
            Reader reader = (Reader)object;
            if (this.rmiSettings.isVerbose()) {
                object2 = "time=" + System.currentTimeMillis() + " : updateObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object2);
            }
            object2 = this;
            synchronized (object2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            }
            int n3 = this.rbg.register(reader, this.rmiSettings.getChunkSize());
            this.remoteRs.updateObject(n, this.rbg, n3, n2);
        } else if (object instanceof InputStream) {
            Object object3;
            InputStream inputStream = (InputStream)object;
            if (this.rmiSettings.isVerbose()) {
                object3 = "time=" + System.currentTimeMillis() + " : updateObject";
                JdbcDebug.JDBCRMIInternal.debug((String)object3);
            }
            object3 = this;
            synchronized (object3) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            }
            int n4 = this.bg.register(inputStream, this.rmiSettings.getChunkSize());
            this.remoteRs.updateObject(n, this.bg, n4, n2);
        } else {
            this.remoteRs.updateObject(n, object, n2);
        }
    }

    public void updateObject(String string, Object object) throws SQLException {
        if (object == null) {
            this.remoteRs.updateObject(string, object);
        } else if (object instanceof Reader || object instanceof InputStream) {
            this.updateObject(this.remoteRs.findColumn(string), object);
        } else {
            this.remoteRs.updateObject(string, object);
        }
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        if (object == null) {
            this.remoteRs.updateObject(string, object, n);
        } else if (object instanceof Reader || object instanceof InputStream) {
            this.updateObject(this.remoteRs.findColumn(string), object, n);
        } else {
            this.remoteRs.updateObject(string, object, n);
        }
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getReaderBlockGetter();
        int n2 = this.remoteRs.registerStream(n, 5);
        if (n2 == -1) {
            return null;
        }
        ReaderHandler readerHandler = new ReaderHandler();
        readerHandler.setReaderBlockGetter((ReaderBlockGetter)object, n2);
        return readerHandler;
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        Object object;
        if (this.rmiSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getNCharacterStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this.remoteRs.getReaderBlockGetter();
        int n = this.remoteRs.registerStream(string, 5);
        if (n == -1) {
            return null;
        }
        ReaderHandler readerHandler = new ReaderHandler();
        readerHandler.setReaderBlockGetter((ReaderBlockGetter)object, n);
        return readerHandler;
    }
}

