/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.sql.SQLException;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.BlockGetterImpl;
import weblogic.jdbc.common.internal.JDBCOutputStreamImpl;
import weblogic.jdbc.common.internal.JDBCWriterImpl;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderBlockGetterImpl;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.SQLXML;
import weblogic.jdbc.rmi.internal.SQLXMLStub;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.server.UnicastRemoteObject;

public class SQLXMLImpl
extends RMISkelWrapperImpl
implements InteropWriteReplaceable {
    public static final int BINARY_STREAM = 1;
    public static final int CHARACTER_STREAM = 2;
    private java.sql.SQLXML t2_sqlxml = null;
    private RmiDriverSettings rmiDriverSettings = null;
    private BlockGetterImpl bg = null;
    private ReaderBlockGetterImpl rbg = null;
    private transient Object interop = null;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        if (object == null) {
            super.postInvocationHandler(string, objectArray, null);
            return null;
        }
        try {
            if (object instanceof Writer) {
                Writer writer = (Writer)object;
                JDBCWriterImpl jDBCWriterImpl = new JDBCWriterImpl(writer, this.rmiDriverSettings.isVerbose(), this.rmiDriverSettings.getChunkSize());
                object = jDBCWriterImpl;
            } else if (object instanceof OutputStream) {
                OutputStream outputStream = (OutputStream)object;
                JDBCOutputStreamImpl jDBCOutputStreamImpl = new JDBCOutputStreamImpl(outputStream, this.rmiDriverSettings.isVerbose(), this.rmiDriverSettings.getChunkSize());
                object = jDBCOutputStreamImpl;
            }
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            throw exception;
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public void init(java.sql.SQLXML sQLXML, RmiDriverSettings rmiDriverSettings) {
        this.t2_sqlxml = sQLXML;
        this.rmiDriverSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public static java.sql.SQLXML makeSQLXMLImpl(java.sql.SQLXML sQLXML, RmiDriverSettings rmiDriverSettings) {
        SQLXMLImpl sQLXMLImpl = (SQLXMLImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.SQLXMLImpl", (Object)sQLXML, (boolean)true));
        sQLXMLImpl.init(sQLXML, rmiDriverSettings);
        return (java.sql.SQLXML)((Object)sQLXMLImpl);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new SQLXMLStub((SQLXML)object, this.rmiDriverSettings);
        }
        return this.interop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerStream(int n) throws SQLException {
        int n2;
        Object object;
        if (this.rmiDriverSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : registerStream";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (n == 1) {
                if (this.bg == null) {
                    this.bg = new BlockGetterImpl();
                }
            } else if (n == 2) {
                if (this.rbg == null) {
                    this.rbg = new ReaderBlockGetterImpl();
                }
            } else {
                throw new SQLException("Invalid stream type: " + n);
            }
        }
        if (n == 1) {
            InputStream inputStream = this.t2_sqlxml.getBinaryStream();
            n2 = this.bg.register(inputStream, this.rmiDriverSettings.getChunkSize());
        } else if (n == 2) {
            Reader reader = this.t2_sqlxml.getCharacterStream();
            n2 = this.rbg.register(reader, this.rmiDriverSettings.getChunkSize());
        } else {
            throw new SQLException("Invalid stream type: " + n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockGetter getBlockGetter() throws SQLException {
        Object object;
        if (this.rmiDriverSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.bg == null) {
                this.bg = new BlockGetterImpl();
            }
        }
        return this.bg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReaderBlockGetter getReaderBlockGetter() throws SQLException {
        Object object;
        if (this.rmiDriverSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : getReaderBlockGetter";
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        object = this;
        synchronized (object) {
            if (this.rbg == null) {
                this.rbg = new ReaderBlockGetterImpl();
            }
        }
        return this.rbg;
    }

    public void internalClose() {
        try {
            UnicastRemoteObject.unexportObject((Object)((Object)this), (boolean)true);
            this.t2_sqlxml = null;
            this.rmiDriverSettings = null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

