/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Reader;
import java.io.Serializable;
import java.sql.SQLException;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.InputStreamHandler;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.common.internal.ReaderBlockGetter;
import weblogic.jdbc.common.internal.ReaderHandler;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.SQLXML;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;

public class SQLXMLStub
extends RMIStubWrapperImpl
implements Serializable {
    private SQLXML remoteSQLXML = null;
    private RmiDriverSettings rmiDriverSettings = null;

    public SQLXMLStub() {
    }

    public SQLXMLStub(SQLXML sQLXML, RmiDriverSettings rmiDriverSettings) {
        this.init(sQLXML, rmiDriverSettings);
    }

    public void init(SQLXML sQLXML, RmiDriverSettings rmiDriverSettings) {
        this.remoteSQLXML = sQLXML;
        this.rmiDriverSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object readResolve() throws ObjectStreamException {
        SQLXMLStub sQLXMLStub = null;
        try {
            sQLXMLStub = (SQLXMLStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.SQLXMLStub", (Object)this.remoteSQLXML, (boolean)false);
            sQLXMLStub.init(this.remoteSQLXML, this.rmiDriverSettings);
            return (java.sql.SQLXML)((Object)sQLXMLStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.remoteSQLXML;
        }
    }

    public void internalClose() {
        this.remoteSQLXML.internalClose();
    }

    public InputStream getBinaryStream() throws SQLException {
        Object object;
        InputStreamHandler inputStreamHandler = null;
        String string = "getBinaryStream";
        Object[] objectArray = new Object[]{};
        if (this.rmiDriverSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : " + string;
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        try {
            this.preInvocationHandler(string, objectArray);
            object = this.remoteSQLXML.getBlockGetter();
            int n = this.remoteSQLXML.registerStream(1);
            inputStreamHandler = new InputStreamHandler();
            inputStreamHandler.setBlockGetter((BlockGetter)object, n);
            this.postInvocationHandler(string, objectArray, inputStreamHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return inputStreamHandler;
    }

    public Reader getCharacterStream() throws SQLException {
        Object object;
        ReaderHandler readerHandler = null;
        String string = "getCharacterStream";
        Object[] objectArray = new Object[]{};
        if (this.rmiDriverSettings.isVerbose()) {
            object = "time=" + System.currentTimeMillis() + " : " + string;
            JdbcDebug.JDBCRMIInternal.debug((String)object);
        }
        try {
            this.preInvocationHandler(string, objectArray);
            object = this.remoteSQLXML.getReaderBlockGetter();
            int n = this.remoteSQLXML.registerStream(2);
            readerHandler = new ReaderHandler();
            readerHandler.setReaderBlockGetter((ReaderBlockGetter)object, n);
            this.postInvocationHandler(string, objectArray, readerHandler);
        }
        catch (Exception exception) {
            this.invocationExceptionHandler(string, objectArray, exception);
        }
        return readerHandler;
    }
}

