/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import weblogic.common.internal.InteropWriteReplaceable;
import weblogic.common.internal.PeerInfo;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.rmi.internal.ArrayImpl;
import weblogic.jdbc.rmi.internal.OracleTBlobImpl;
import weblogic.jdbc.rmi.internal.OracleTClobImpl;
import weblogic.jdbc.rmi.internal.RMISkelWrapperImpl;
import weblogic.jdbc.rmi.internal.RefImpl;
import weblogic.jdbc.rmi.internal.ResultSetImpl;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.rmi.internal.Statement;
import weblogic.jdbc.rmi.internal.StatementStub;
import weblogic.jdbc.rmi.internal.StructImpl;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.jdbc.wrapper.JDBCWrapperImpl;
import weblogic.jdbc.wrapper.ResultSet;
import weblogic.rmi.extensions.StubFactory;
import weblogic.rmi.server.UnicastRemoteObject;

public class StatementImpl
extends RMISkelWrapperImpl
implements InteropWriteReplaceable {
    private java.sql.Statement t2_stmt = null;
    RmiDriverSettings rmiSettings = null;
    private java.sql.ResultSet curr_remote_rs = null;
    private ResultSet curr_rs = null;
    transient Object interop = null;

    public Object postInvocationHandler(String string, Object[] objectArray, Object object) throws Exception {
        block17: {
            if (object == null) {
                super.postInvocationHandler(string, objectArray, null);
                return null;
            }
            try {
                if (object instanceof java.sql.ResultSet) {
                    if (this.curr_rs != null && !this.curr_rs.internalIsClosed() && this.curr_remote_rs != null) {
                        try {
                            if (((JDBCWrapperImpl)this.curr_remote_rs).getVendorObj() == ((JDBCWrapperImpl)object).getVendorObj()) {
                                super.postInvocationHandler(string, objectArray, this.curr_remote_rs);
                                return this.curr_remote_rs;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.curr_rs = object instanceof ResultSet ? (ResultSet)object : null;
                    this.curr_remote_rs = ResultSetImpl.makeResultSetImpl((java.sql.ResultSet)object, this.rmiSettings);
                    object = this.curr_remote_rs;
                    break block17;
                }
                if (object instanceof Blob) {
                    object = OracleTBlobImpl.makeOracleTBlobImpl((Blob)object, this.rmiSettings);
                } else if (object instanceof Clob) {
                    object = OracleTClobImpl.makeOracleTClobImpl((Clob)object, this.rmiSettings);
                } else if (object instanceof Struct) {
                    object = StructImpl.makeStructImpl((Struct)object, this.rmiSettings);
                } else if (object instanceof Ref) {
                    object = RefImpl.makeRefImpl((Ref)object, this.rmiSettings);
                } else if (object instanceof Array) {
                    object = ArrayImpl.makeArrayImpl((Array)object, this.rmiSettings);
                }
            }
            catch (Exception exception) {
                JDBCLogger.logStackTrace((Throwable)exception);
                throw exception;
            }
        }
        super.postInvocationHandler(string, objectArray, object);
        return object;
    }

    public StatementImpl() {
        this.rmiSettings = new RmiDriverSettings();
    }

    public StatementImpl(java.sql.Statement statement, RmiDriverSettings rmiDriverSettings) {
        this.init(statement, rmiDriverSettings);
    }

    public void init(java.sql.Statement statement, RmiDriverSettings rmiDriverSettings) {
        this.t2_stmt = statement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public java.sql.Statement getImplDelegate() {
        return this.t2_stmt;
    }

    public static java.sql.Statement makeStatementImpl(java.sql.Statement statement, RmiDriverSettings rmiDriverSettings) {
        if (statement == null) {
            return null;
        }
        StatementImpl statementImpl = (StatementImpl)((Object)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.StatementImpl", (Object)statement, (boolean)true));
        statementImpl.init(statement, rmiDriverSettings);
        return (java.sql.Statement)((Object)statementImpl);
    }

    public Object interopWriteReplace(PeerInfo peerInfo) throws IOException {
        if (this.interop == null) {
            Object object = StubFactory.getStub((Remote)((Remote)((Object)this)));
            this.interop = new StatementStub((Statement)object, this.rmiSettings);
        }
        return this.interop;
    }

    public int getRmiFetchSize() throws SQLException {
        return this.rmiSettings.getRowCacheSize();
    }

    public void setRmiFetchSize(int n) throws SQLException {
        this.rmiSettings.setRowCacheSize(n);
    }

    public void close() throws SQLException {
        this.t2_stmt.close();
        try {
            UnicastRemoteObject.unexportObject((Object)((Object)this), (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

