/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rmi.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.JdbcDebug;
import weblogic.jdbc.rmi.RMIStubWrapperImpl;
import weblogic.jdbc.rmi.RmiStatement;
import weblogic.jdbc.rmi.internal.RmiDriverSettings;
import weblogic.jdbc.wrapper.JDBCWrapperFactory;
import weblogic.rmi.extensions.server.StubDelegateInfo;

public class StatementStub
extends RMIStubWrapperImpl
implements Serializable,
StubDelegateInfo {
    private static final long serialVersionUID = 3782203674892516357L;
    RmiDriverSettings rmiSettings = null;
    Statement stmt;

    public StatementStub() {
    }

    public StatementStub(Statement statement, RmiDriverSettings rmiDriverSettings) {
        this.init(statement, rmiDriverSettings);
    }

    public void init(Statement statement, RmiDriverSettings rmiDriverSettings) {
        this.stmt = statement;
        this.rmiSettings = new RmiDriverSettings(rmiDriverSettings);
    }

    public Object readResolve() throws ObjectStreamException {
        StatementStub statementStub = null;
        try {
            statementStub = (StatementStub)JDBCWrapperFactory.getWrapper((String)"weblogic.jdbc.rmi.internal.StatementStub", (Object)this.stmt, (boolean)false);
            statementStub.init(this.stmt, this.rmiSettings);
            return (Statement)((Object)statementStub);
        }
        catch (Exception exception) {
            JDBCLogger.logStackTrace((Throwable)exception);
            return this.stmt;
        }
    }

    public Object getStubDelegate() {
        return this.stmt;
    }

    public int getRmiFetchSize() throws SQLException {
        return this.rmiSettings.getRowCacheSize();
    }

    public void setRmiFetchSize(int n) throws SQLException {
        ((RmiStatement)((Object)this.stmt)).setRmiFetchSize(n);
        this.rmiSettings.setRowCacheSize(n);
    }

    public void close() throws SQLException {
        if (this.rmiSettings.isVerbose()) {
            String string = "time=" + System.currentTimeMillis() + " : close";
            JdbcDebug.JDBCRMIInternal.debug(string);
        }
        this.stmt.close();
    }
}

