/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.RowSetMetaData;
import javax.sql.RowSetReader;
import javax.sql.RowSetWriter;
import javax.sql.rowset.Joinable;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.spi.SyncFactory;
import javax.sql.rowset.spi.SyncProvider;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetJDBCReader;
import weblogic.jdbc.rowset.CachedRowSetJDBCWriter;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.LifeCycle;
import weblogic.jdbc.rowset.RowSetBlob;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.RowSetNClob;
import weblogic.jdbc.rowset.WLParameter;
import weblogic.jdbc.rowset.WLSyncProvider;
import weblogic.utils.StackTraceUtils;

public abstract class BaseRowSet
implements Serializable,
Joinable {
    private static final long serialVersionUID = 496582906625949131L;
    String url;
    String userName;
    String password;
    String dataSourceName;
    boolean preferDataSource;
    transient DataSource dataSource;
    transient Connection cachedConnection;
    String command;
    transient ArrayList params = new ArrayList();
    int isolationLevel;
    int fetchDirection;
    int fetchSize;
    int concurrency = 1008;
    int resultSetType = 1004;
    Map typeMap;
    int queryTimeout;
    int maxRows;
    int maxFieldSize;
    boolean escapeProcessing;
    boolean showDeleted;
    boolean isComplete;
    boolean wasNull;
    transient String providerID;
    transient SyncProvider provider = new WLSyncProvider();
    transient RowSetWriter writer = new CachedRowSetJDBCWriter();
    transient RowSetReader reader = new CachedRowSetJDBCReader();
    transient boolean locked = false;
    CachedRowSetMetaData metaData;
    LifeCycle.State state;
    List rowSetListeners = new ArrayList();
    int rowIndex;
    boolean isClosed = false;
    private static final int BUFFER_SIZE = 8192;

    protected void setIsClosed(boolean bl) {
        this.isClosed = bl;
    }

    void keepRowIndexValid() {
        if (this.rowIndex < -1) {
            this.rowIndex = -1;
        }
        if (this.rowIndex > this.size()) {
            this.rowIndex = this.size();
        }
    }

    public abstract int size();

    public int getRow() {
        return this.rowIndex + 1;
    }

    public boolean absolute(int n) throws SQLException {
        this.checkIterator();
        int n2 = this.rowIndex;
        this.rowIndex = n < 0 ? this.size() + n : n - 1;
        this.keepRowIndexValid();
        if (n2 != this.rowIndex) {
            this.cursorMoved();
        }
        return this.rowIndex >= 0 && this.rowIndex < this.size();
    }

    public boolean relative(int n) throws SQLException {
        this.checkIterator();
        int n2 = this.rowIndex;
        this.rowIndex += n;
        this.keepRowIndexValid();
        if (n2 != this.rowIndex) {
            this.cursorMoved();
        }
        return this.rowIndex >= 0 && this.rowIndex < this.size();
    }

    public void beforeFirst() throws SQLException {
        this.absolute(0);
    }

    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    public boolean next() throws SQLException {
        return this.relative(1);
    }

    public boolean previous() throws SQLException {
        return this.relative(-1);
    }

    public boolean last() throws SQLException {
        return this.absolute(this.size());
    }

    public void afterLast() throws SQLException {
        this.absolute(this.size() + 1);
    }

    public boolean isBeforeFirst() throws SQLException {
        this.checkIterator();
        return this.rowIndex == -1;
    }

    public boolean isAfterLast() throws SQLException {
        this.checkIterator();
        return this.size() > 0 && this.rowIndex >= this.size();
    }

    public boolean isFirst() throws SQLException {
        this.checkIterator();
        return this.size() > 0 && this.rowIndex == 0;
    }

    public boolean isLast() throws SQLException {
        this.checkIterator();
        return this.size() > 0 && this.rowIndex == this.size() - 1;
    }

    public boolean rowUpdated() throws SQLException {
        return this.currentRow().isUpdatedRow();
    }

    public boolean rowInserted() throws SQLException {
        return this.currentRow().isInsertRow();
    }

    public boolean rowDeleted() throws SQLException {
        return this.currentRow().isDeletedRow();
    }

    public boolean columnUpdated(int n) throws SQLException {
        return this.currentRow().isModified(n);
    }

    public boolean columnUpdated(String string) throws SQLException {
        return this.currentRow().isModified(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    public void setMetaData(RowSetMetaData rowSetMetaData) throws SQLException {
        this.checkOp();
        if (rowSetMetaData == null) {
            return;
        }
        if (rowSetMetaData instanceof CachedRowSetMetaData) {
            this.metaData = (CachedRowSetMetaData)((CachedRowSetMetaData)rowSetMetaData).clone();
        } else {
            this.metaData = new CachedRowSetMetaData();
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = this.getConnection().getMetaData();
            }
            catch (Exception exception) {
                JDBCLogger.logStackTrace((Throwable)exception);
            }
            this.metaData.initialize(rowSetMetaData, databaseMetaData);
        }
    }

    public boolean isReadOnly() {
        return this.metaData.isReadOnly();
    }

    public void setReadOnlyInternal(boolean bl) {
        this.checkOp();
        this.metaData.setReadOnly(bl);
    }

    public void setReadOnly(boolean bl) {
        this.checkOp(3);
        this.metaData.setReadOnly(bl);
    }

    public void setTableName(String string) throws SQLException {
        this.checkOp();
        this.metaData.setWriteTableName(string);
    }

    public String getTableName() throws SQLException {
        return this.metaData.getWriteTableName();
    }

    public int[] getKeyColumns() throws SQLException {
        return this.metaData.getKeyColumns();
    }

    public void setKeyColumns(int[] nArray) throws SQLException {
        this.checkOp();
        this.metaData.setKeyColumns(nArray);
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.checkOp();
        this.showDeleted = bl;
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public RowSetWarning getRowSetWarnings() {
        return null;
    }

    public String getCursorName() throws SQLException {
        return null;
    }

    public Statement getStatement() throws SQLException {
        return null;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.checkOp();
        this.dataSourceName = string;
        this.preferDataSource = true;
    }

    private DataSource lookupDataSource() throws SQLException {
        InitialContext initialContext = null;
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            if (this.userName != null) {
                hashtable.put("java.naming.security.principal", this.userName);
            }
            if (this.password != null) {
                hashtable.put("java.naming.security.credentials", this.password);
            }
            initialContext = new InitialContext(hashtable);
        }
        catch (NamingException namingException) {
            throw new SQLException("Unable to access JNDI with username: " + this.userName + ". Please ensure that your username and password are correct.", StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
        try {
            this.dataSource = (DataSource)initialContext.lookup(this.dataSourceName);
            return this.dataSource;
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("The name: " + this.dataSourceName + " was found in the JNDI tree, but this is not a javax.sql.DataSource.");
        }
        catch (NamingException namingException) {
            throw new SQLException("Unable to locate a DataSource with the name: " + this.dataSourceName + ".  Please check your configuration and make sure that this DataSource has been deployed.", StackTraceUtils.throwable2StackTrace((Throwable)namingException));
        }
    }

    public DataSource getDataSource() throws SQLException {
        if (this.dataSource != null) {
            return this.dataSource;
        }
        if (this.dataSourceName != null) {
            return this.lookupDataSource();
        }
        return null;
    }

    public void setDataSource(DataSource dataSource) {
        this.checkOp();
        this.dataSource = dataSource;
        this.preferDataSource = true;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.checkOp();
        this.url = string;
        this.preferDataSource = false;
    }

    boolean isPreferDataSource() {
        return this.preferDataSource;
    }

    public String getUsername() {
        return this.userName;
    }

    public void setUsername(String string) {
        this.checkOp();
        this.userName = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.checkOp();
        this.password = string;
    }

    public Connection getConnection() throws SQLException {
        if (this.cachedConnection == null) {
            if (this.preferDataSource) {
                if (this.dataSource == null) {
                    if (this.dataSourceName == null) {
                        throw new SQLException("You must call setDataSourceName and provide a valid DataSource JNDI name before attempting JDBC commands.");
                    }
                    this.lookupDataSource();
                }
                this.cachedConnection = this.dataSource.getConnection();
            } else {
                Properties properties = new Properties();
                properties.setProperty("user", this.userName);
                properties.setProperty("password", this.password);
                if (this.url != null && this.url.toLowerCase().matches(".*protocol\\s*=\\s*sdp.*")) {
                    properties.put("oracle.net.SDP", "true");
                }
                this.cachedConnection = DriverManager.getConnection(this.url, properties);
            }
        }
        if (this.isolationLevel != -1) {
            this.cachedConnection.setTransactionIsolation(this.isolationLevel);
        }
        return this.cachedConnection;
    }

    public int getTransactionIsolation() {
        return this.isolationLevel;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.toDesign();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolationLevel = n;
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new SQLException("Invalid value for setTransactionIsolation: " + n);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.toDesign();
        this.command = string;
        this.clearParameters();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.toDesign();
        this.queryTimeout = n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.toDesign();
        this.maxRows = n;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) {
        this.toDesign();
        this.maxFieldSize = n;
    }

    public boolean getEscapeProcessing() {
        return this.escapeProcessing;
    }

    public void setEscapeProcessing(boolean bl) {
        this.toDesign();
        this.escapeProcessing = bl;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void setConcurrency(int n) {
        this.toDesign();
        this.concurrency = n;
    }

    public int getType() {
        return this.resultSetType;
    }

    public void setType(int n) {
        this.toDesign();
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.toDesign();
        switch (n) {
            case 1001: {
                if (this.getType() == 1003) {
                    throw new SQLException("Cannot set FETCH_REVERSE on a TYPE_FORWARD_ONLY RowSet.");
                }
            }
            case 1000: 
            case 1002: {
                this.fetchDirection = n;
                break;
            }
            default: {
                throw new SQLException("Unknown value for setFetchDirection:" + n);
            }
        }
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.toDesign();
        this.fetchSize = n;
    }

    public Map getTypeMap() {
        return this.typeMap;
    }

    public void setTypeMap(Map map) {
        this.toDesign();
        this.typeMap = map;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void setIsComplete(boolean bl) {
        this.checkOp();
        this.isComplete = bl;
    }

    ArrayList getParameters() {
        return this.params;
    }

    public void clearParameters() {
        this.checkOp();
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        Object[] objectArray = new Object[this.params.size()];
        for (int i = 0; i < this.params.size(); ++i) {
            objectArray[i] = ((WLParameter)this.params.get(i)).getObject();
        }
        return objectArray;
    }

    public void setString(int n, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 39, new Object[]{string}));
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 10, new Object[]{new Boolean(bl)}));
    }

    public void setLong(int n, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 23, new Object[]{new Long(l)}));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 22, new Object[]{new Integer(n2)}));
    }

    public void setShort(int n, short s) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 37, new Object[]{new Short(s)}));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 20, new Object[]{new Double(d)}));
    }

    public void setFloat(int n, float f) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 21, new Object[]{new Float(f)}));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 4, new Object[]{bigDecimal}));
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 6, new Object[]{inputStream, new Integer(n2)}));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 11, new Object[]{new Byte(by)}));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 12, new Object[]{byArray}));
    }

    public void setNull(int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 30, new Object[]{new Integer(n2)}));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 31, new Object[]{new Integer(n2), string}));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 32, new Object[]{object}));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 33, new Object[]{object, new Integer(n2)}));
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 34, new Object[]{object, new Integer(n2), new Integer(n3)}));
    }

    public void setDate(int n, Date date) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 18, new Object[]{date}));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 19, new Object[]{date, calendar}));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 40, new Object[]{time}));
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 41, new Object[]{time, calendar}));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 42, new Object[]{timestamp}));
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 43, new Object[]{timestamp, calendar}));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 3, new Object[]{inputStream, new Integer(n2)}));
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 14, new Object[]{reader, new Integer(n2)}));
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 7, new Object[]{blob}));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 15, new Object[]{clob}));
    }

    public void setArray(int n, Array array) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 1, new Object[]{array}));
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 35, new Object[]{ref}));
    }

    public int findColumn(String string) throws SQLException {
        return this.metaData.findColumn(string);
    }

    abstract CachedRow currentRow() throws SQLException;

    public boolean wasNull() {
        return this.wasNull;
    }

    public String getString(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof String) {
                this.wasNull = false;
                return (String)object;
            }
            if (object == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return object.toString().trim();
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a String");
        }
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Boolean) {
                this.wasNull = false;
                return (Boolean)object;
            }
            if (object == null) {
                this.wasNull = true;
                return false;
            }
            this.wasNull = false;
            return Boolean.getBoolean(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a boolean");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a boolean");
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Long) {
                this.wasNull = false;
                return (Long)object;
            }
            if (object == null) {
                this.wasNull = true;
                return 0L;
            }
            this.wasNull = false;
            return Long.parseLong(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a long");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a long");
        }
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Integer) {
                this.wasNull = false;
                return (Integer)object;
            }
            if (object == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Integer.parseInt(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to an int");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to an int");
        }
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public short getShort(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Short) {
                this.wasNull = false;
                return (Short)object;
            }
            if (object == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Short.parseShort(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a short");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a short");
        }
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Byte) {
                this.wasNull = false;
                return (Byte)object;
            }
            if (object == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            return Byte.parseByte(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a byte");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a byte");
        }
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public double getDouble(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Double) {
                this.wasNull = false;
                return (Double)object;
            }
            if (object == null) {
                this.wasNull = true;
                return 0.0;
            }
            this.wasNull = false;
            return Double.parseDouble(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a double");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a double");
        }
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof Float) {
                this.wasNull = false;
                return ((Float)object).floatValue();
            }
            if (object == null) {
                this.wasNull = true;
                return 0.0f;
            }
            this.wasNull = false;
            return Float.parseFloat(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a float");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a float");
        }
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.checkOp();
        try {
            Object object = this.currentRow().getColumn(n);
            if (object instanceof BigDecimal) {
                this.wasNull = false;
                return (BigDecimal)object;
            }
            if (object == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new BigDecimal(object.toString().trim());
        }
        catch (ClassCastException classCastException) {
            throw new SQLException("This column cannot be converted to a boolean");
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("This column cannot be converted to a boolean");
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2);
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public byte[] getBytes(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof byte[]) {
            this.wasNull = false;
            return (byte[])object;
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        throw new SQLException("This column cannot be converted to a byte[]");
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Object getObject(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        this.wasNull = object == null;
        return object;
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Date) {
            this.wasNull = false;
            return (Date)object;
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        if (object instanceof java.util.Date) {
            this.wasNull = false;
            return new Date(((java.util.Date)object).getTime());
        }
        this.wasNull = false;
        try {
            java.util.Date date = DateFormat.getDateInstance().parse(object.toString());
            return new Date(date.getTime());
        }
        catch (ParseException parseException) {
            throw new SQLException(parseException.getMessage());
        }
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Time) {
            this.wasNull = false;
            return (Time)object;
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        if (object instanceof java.util.Date) {
            this.wasNull = false;
            return new Time(((java.util.Date)object).getTime());
        }
        try {
            java.util.Date date = DateFormat.getDateInstance().parse(object.toString());
            return new Time(date.getTime());
        }
        catch (ParseException parseException) {
            throw new SQLException(parseException.getMessage());
        }
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Timestamp) {
            this.wasNull = false;
            return (Timestamp)object;
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        if (object instanceof java.util.Date) {
            this.wasNull = false;
            return new Timestamp(((java.util.Date)object).getTime());
        }
        try {
            java.util.Date date = DateFormat.getDateInstance().parse(object.toString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException parseException) {
            throw new SQLException(parseException.getMessage());
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        this.checkOp();
        Date date = this.getDate(n);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date);
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        return new Date(calendar2.getTime().getTime());
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        this.checkOp();
        Time time = this.getTime(n);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(time);
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        return new Time(calendar2.getTime().getTime());
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        this.checkOp();
        Timestamp timestamp = this.getTimestamp(n);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(timestamp);
        calendar2.set(1, calendar.get(1));
        calendar2.set(2, calendar.get(2));
        calendar2.set(5, calendar.get(5));
        return new Timestamp(calendar2.getTime().getTime());
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof byte[]) {
            this.wasNull = false;
            return new ByteArrayInputStream((byte[])object);
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        throw new SQLException("This column cannot be converted to a BinaryStream");
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof char[]) {
            this.wasNull = false;
            return new CharArrayReader((char[])object);
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return new StringReader(object.toString());
    }

    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public Blob getBlob(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        boolean bl = this.wasNull = object == null;
        if (!this.wasNull && object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof String) {
            return new RowSetBlob(((String)object).getBytes());
        }
        if (object instanceof byte[]) {
            return new RowSetBlob((byte[])object);
        }
        this.currentRow().getColumn(n).getClass();
        throw new SQLException("This column values are " + object.getClass().getName() + " by default. " + "This column cannot be converted to a java.sql.Blob");
    }

    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new RowSetClob(object.toString());
        }
        throw new SQLException("This column values are " + object.getClass().getName() + " by default. " + "This column cannot be converted to a java.sql.Clob");
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof byte[]) {
            this.wasNull = false;
            try {
                return new ByteArrayInputStream(new String((byte[])object).getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.toString());
            }
        }
        if (object instanceof char[]) {
            this.wasNull = false;
            try {
                return new ByteArrayInputStream(new String((char[])object).getBytes("US-ASCII"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLException(unsupportedEncodingException.toString());
            }
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        throw new SQLException("This column cannot be converted to a AsciiStream");
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof char[]) {
            this.wasNull = false;
            return new ByteArrayInputStream(new String((char[])object).getBytes());
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        return new ByteArrayInputStream(object.toString().getBytes());
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Array || object instanceof SerialArray) {
            this.wasNull = false;
            return (Array)object;
        }
        throw new SQLException("This column cannot be converted to a Array");
    }

    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    public Ref getRef(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof Ref || object instanceof SerialRef) {
            this.wasNull = false;
            return (Ref)object;
        }
        if (object == null) {
            this.wasNull = true;
            return null;
        }
        throw new SQLException("This column cannot be converted to a Ref");
    }

    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    public URL getURL(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof URL || object instanceof SerialDatalink) {
            this.wasNull = false;
            return (URL)object;
        }
        if (object instanceof SerialDatalink) {
            this.wasNull = false;
            return ((SerialDatalink)object).getDatalink();
        }
        throw new SQLException("This column cannot be converted to a URL");
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    abstract void updateCurrent(int var1, Object var2) throws SQLException;

    public void updateNull(int n) throws SQLException {
        this.updateCurrent(n, null);
    }

    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    public void updateObject(int n, Object object) throws SQLException {
        this.updateCurrent(n, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        this.metaData.setColumnType(n, n2);
        this.updateCurrent(n, object);
    }

    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateString(int n, String string) throws SQLException {
        this.updateCurrent(n, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBoolean(int n, boolean bl) throws SQLException {
        this.updateCurrent(n, new Boolean(bl));
    }

    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateLong(int n, long l) throws SQLException {
        this.updateCurrent(n, new Long(l));
    }

    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    public void updateInt(int n, int n2) throws SQLException {
        this.updateCurrent(n, new Integer(n2));
    }

    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    public void updateShort(int n, short s) throws SQLException {
        this.updateCurrent(n, new Short(s));
    }

    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    public void updateByte(int n, byte by) throws SQLException {
        this.updateCurrent(n, new Byte(by));
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateDouble(int n, double d) throws SQLException {
        this.updateCurrent(n, new Double(d));
    }

    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateFloat(int n, float f) throws SQLException {
        this.updateCurrent(n, new Float(f));
    }

    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        this.updateCurrent(n, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.updateCurrent(n, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateDate(int n, Date date) throws SQLException {
        this.updateCurrent(n, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(int n, Time time) throws SQLException {
        this.updateCurrent(n, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.updateCurrent(n, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    private byte[] drain(InputStream inputStream, byte[] byArray) throws SQLException {
        int n;
        for (int i = 0; i < byArray.length; i += n) {
            try {
                n = inputStream.read(byArray, i, byArray.length - i);
                if (n == -1) break;
                continue;
            }
            catch (IOException iOException) {
                JDBCLogger.logStackTrace((Throwable)iOException);
                throw new SQLException(iOException.getMessage());
            }
        }
        return byArray;
    }

    private char[] drain(Reader reader, char[] cArray) throws SQLException {
        int n;
        for (int i = 0; i < cArray.length; i += n) {
            try {
                n = reader.read(cArray, i, cArray.length - i);
                if (n == -1) break;
                continue;
            }
            catch (IOException iOException) {
                JDBCLogger.logStackTrace((Throwable)iOException);
                throw new SQLException(iOException.getMessage());
            }
        }
        return cArray;
    }

    /*
     * Loose catch block
     */
    private byte[] drain(InputStream inputStream) throws SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        Object var6_7 = null;
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray2;
        catch (IOException iOException) {
            try {
                JDBCLogger.logStackTrace((Throwable)iOException);
                throw new SQLException(iOException.getMessage());
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
    }

    private char[] drain(Reader reader) throws SQLException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[8192];
        try {
            int n;
            while ((n = reader.read(cArray)) != -1) {
                charArrayWriter.write(cArray, 0, n);
            }
            char[] cArray2 = charArrayWriter.toCharArray();
            Object var6_7 = null;
            charArrayWriter.close();
            return cArray2;
        }
        catch (IOException iOException) {
            try {
                JDBCLogger.logStackTrace((Throwable)iOException);
                throw new SQLException(iOException.getMessage());
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                charArrayWriter.close();
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private String drainContent(InputStream inputStream) throws SQLException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        String string = byteArrayOutputStream.toString();
        Object var6_7 = null;
        try {
            byteArrayOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
        catch (IOException iOException) {
            try {
                JDBCLogger.logStackTrace((Throwable)iOException);
                throw new SQLException(iOException.getMessage());
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            throw new SQLException("updateAsciiStream's InputStream was null");
        }
        if (n2 <= 0) {
            throw new SQLException("updateAsciiStream's length must be > 0");
        }
        this.updateCurrent(n, new String(this.drain(inputStream, new byte[n2]), 0, n2));
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            throw new SQLException("updateBinaryStream's InputStream was null");
        }
        if (n2 <= 0) {
            throw new SQLException("updateBinaryStream's length must be > 0");
        }
        this.updateCurrent(n, this.drain(inputStream, new byte[n2]));
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            throw new SQLException("updateCharacterStream's reader was null");
        }
        if (n2 <= 0) {
            throw new SQLException("updateCharacterStream's length must be > 0");
        }
        this.updateCurrent(n, this.drain(reader, new char[n2]));
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        this.updateCurrent(n, blob);
    }

    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        this.updateCurrent(n, clob);
    }

    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateRef(int n, Ref ref) throws SQLException {
        this.updateCurrent(n, ref);
    }

    public void updateRef(String string, Ref ref) throws SQLException {
        this.updateRef(this.findColumn(string), ref);
    }

    public void updateArray(int n, Array array) throws SQLException {
        this.updateCurrent(n, array);
    }

    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        this.rowSetListeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        this.rowSetListeners.remove(rowSetListener);
    }

    void cursorMoved() {
        RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.cursorMoved(rowSetEvent);
        }
    }

    void rowChanged() {
        RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.rowChanged(rowSetEvent);
        }
    }

    void rowSetChanged() {
        RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
        for (RowSetListener rowSetListener : this.rowSetListeners) {
            rowSetListener.rowSetChanged(rowSetEvent);
        }
    }

    public void setWriter(RowSetWriter rowSetWriter) {
        this.writer = rowSetWriter;
    }

    public SyncProvider getSyncProvider() throws SQLException {
        return this.provider;
    }

    public void setSyncProvider(String string) throws SQLException {
        if (string == null) {
            this.provider = new WLSyncProvider();
        } else {
            this.provider = SyncFactory.getInstance(string);
            if (this.provider == null) {
                throw new SQLException("Can not find SyncProvider for " + string + ".");
            }
        }
        this.reader = this.provider.getRowSetReader();
        this.writer = this.provider.getRowSetWriter();
    }

    public int[] getMatchColumnIndexes() throws SQLException {
        return this.metaData.getMatchColumns();
    }

    public String[] getMatchColumnNames() throws SQLException {
        int[] nArray = this.metaData.getMatchColumns();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            stringArray[i] = this.metaData.getColumnName(nArray[i]);
        }
        return stringArray;
    }

    public void setMatchColumn(int n) throws SQLException {
        this.checkOp();
        this.metaData.setMatchColumn(n, true);
    }

    public void setMatchColumn(String string) throws SQLException {
        this.metaData.setMatchColumn(this.findColumn(string), true);
    }

    public void setMatchColumn(int[] nArray) throws SQLException {
        this.checkOp();
        for (int i = 0; i < nArray.length; ++i) {
            this.setMatchColumn(nArray[i]);
        }
    }

    public void setMatchColumn(String[] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setMatchColumn(stringArray[i]);
        }
    }

    public void unsetMatchColumn(int n) throws SQLException {
        this.checkOp();
        this.metaData.setMatchColumn(n, false);
    }

    public void unsetMatchColumn(String string) throws SQLException {
        this.metaData.setMatchColumn(this.findColumn(string), false);
    }

    public void unsetMatchColumn(int[] nArray) throws SQLException {
        for (int i = 0; i < nArray.length; ++i) {
            this.unsetMatchColumn(nArray[i]);
        }
    }

    public void unsetMatchColumn(String[] stringArray) throws SQLException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.unsetMatchColumn(stringArray[i]);
        }
    }

    void checkOp() {
        if (this.locked) {
            throw new RuntimeException("This operation is disabled because there are open SharedRowSet objects associated with this CachedRowSet object. Please call SharedRowSet.close() to detach it.");
        }
    }

    void checkOp(int n) {
        this.checkOp();
        this.state = this.state.checkOp(n);
    }

    void checkIterator() throws SQLException {
        this.checkOp(4);
    }

    void toConfigQuery() {
        this.checkOp(1);
    }

    void toDesign() {
        this.checkOp(0);
    }

    void isJoinable(Class clazz) throws SQLException {
        if (!(Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || java.util.Date.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz))) {
            throw new SQLException(clazz + " is not a supported Joinable data type");
        }
    }

    void isJoinable(Class clazz, Class clazz2) throws SQLException {
        if (Number.class.isAssignableFrom(clazz)) {
            if (Boolean.class.isAssignableFrom(clazz2) || java.util.Date.class.isAssignableFrom(clazz2)) {
                throw new SQLException(clazz2 + " can not be joined with " + clazz);
            }
            if (Number.class.isAssignableFrom(clazz2) || String.class.isAssignableFrom(clazz2)) {
                return;
            }
            throw new SQLException(clazz2 + " is not a supported Joinable data type");
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            if (Number.class.isAssignableFrom(clazz2) || java.util.Date.class.isAssignableFrom(clazz2)) {
                throw new SQLException(clazz2 + " can not be compared with " + clazz);
            }
            if (Boolean.class.isAssignableFrom(clazz2) || String.class.isAssignableFrom(clazz2)) {
                return;
            }
            throw new SQLException(clazz2 + " is not a supported Joinable data type");
        }
        if (java.util.Date.class.isAssignableFrom(clazz)) {
            if (Number.class.isAssignableFrom(clazz2) || Boolean.class.isAssignableFrom(clazz2)) {
                throw new SQLException(clazz2 + " can not be compared with " + clazz);
            }
            if (java.util.Date.class.isAssignableFrom(clazz2) || String.class.isAssignableFrom(clazz2)) {
                return;
            }
            throw new SQLException(clazz2 + " is not a supported Joinable data type");
        }
        if (String.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new SQLException(clazz + " is not a supported Joinable data type");
    }

    public RowId getRowId(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof RowId) {
            this.wasNull = false;
            return (RowId)object;
        }
        throw new SQLException("This column cannot be converted to a RowId");
    }

    public RowId getRowId(String string) throws SQLException {
        return this.getRowId(this.findColumn(string));
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public NClob getNClob(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof NClob) {
            this.wasNull = false;
            return (NClob)object;
        }
        if (object instanceof String) {
            return new RowSetNClob(object.toString());
        }
        throw new SQLException("This column values are " + object.getClass().getName() + " by default. " + "This column cannot be converted to a NClob");
    }

    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    public SQLXML getSQLXML(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof SQLXML) {
            this.wasNull = false;
            return (SQLXML)object;
        }
        throw new SQLException("This column cannot be converted to a SQLXML");
    }

    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    public String getNString(int n) throws SQLException {
        this.checkOp();
        Object object = this.currentRow().getColumn(n);
        if (object instanceof String) {
            this.wasNull = false;
            return (String)object;
        }
        throw new SQLException("This column cannot be converted to a String");
    }

    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    public void updateRowId(int n, RowId rowId) throws SQLException {
        throw new SQLException("RowId is only valid within the transaction it is created.");
    }

    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw new SQLException("RowId is only valid within the transaction it is created.");
    }

    public void updateNString(int n, String string) throws SQLException {
        this.updateCurrent(n, string);
    }

    public void updateNString(String string, String string2) throws SQLException {
        this.updateNString(this.findColumn(string), string2);
    }

    public void updateNClob(int n, NClob nClob) throws SQLException {
        this.updateClob(n, (Clob)nClob);
    }

    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateNClob(this.findColumn(string), nClob);
    }

    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.updateCurrent(n, sQLXML);
    }

    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    public void updateNCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (reader == null) {
            throw new SQLException("updateCharacterStream's reader was null");
        }
        if (n2 <= 0) {
            throw new SQLException("updateCharacterStream's length must be > 0");
        }
        this.updateCurrent(n, this.drain(reader, new char[n2]));
    }

    public void updateNCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, n);
    }

    public void setNClob(int n, NClob nClob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 26, new Object[]{nClob}));
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 25, new Object[]{reader, l}));
    }

    public void setNString(int n, String string) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 29, new Object[]{string}));
    }

    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 38, new Object[]{sQLXML}));
    }

    public void setRowId(int n, RowId rowId) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, 36, new Object[]{rowId}));
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 38, new Object[]{sQLXML}));
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 36, new Object[]{rowId}));
    }

    public void setNString(String string, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 29, new Object[]{string2}));
    }

    public void setNClob(String string, NClob nClob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 26, new Object[]{nClob}));
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 25, new Object[]{reader, new Long(l)}));
    }

    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            throw new SQLException("updateAsciiStream's InputStream was null");
        }
        this.updateCurrent(n, this.drainContent(inputStream));
    }

    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("updateAsciiStream's length must be <= 2147483647");
        }
        this.updateAsciiStream(n, inputStream, (int)l);
    }

    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            throw new SQLException("updateBinaryStream's InputStream was null");
        }
        this.updateCurrent(n, this.drain(inputStream));
    }

    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("updateBinaryStream's length must be <= 2147483647");
        }
        this.updateBinaryStream(n, inputStream, (int)l);
    }

    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        this.updateBinaryStream(n, inputStream);
    }

    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.updateBinaryStream(n, inputStream, l);
    }

    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream);
    }

    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (reader == null) {
            throw new SQLException("updateCharacterStream's reader was null");
        }
        this.updateCurrent(n, this.drain(reader));
    }

    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (l > Integer.MAX_VALUE) {
            throw new SQLException("updateCharacterStream's length must be <= 2147483647");
        }
        this.updateCharacterStream(n, reader, (int)l);
    }

    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    public void updateClob(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    public void updateClob(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    public void updateClob(String string, Reader reader) throws SQLException {
        this.updateClob(this.findColumn(string), reader);
    }

    public void updateClob(String string, Reader reader, long l) throws SQLException {
        this.updateClob(this.findColumn(string), reader, l);
    }

    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        this.updateCharacterStream(n, reader);
    }

    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.updateCharacterStream(n, reader, l);
    }

    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    public void updateNClob(int n, Reader reader) throws SQLException {
        this.updateClob(n, reader);
    }

    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        this.updateClob(n, reader, l);
    }

    public void updateNClob(String string, Reader reader) throws SQLException {
        this.updateNClob(this.findColumn(string), reader);
    }

    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        this.updateNClob(this.findColumn(string), reader, l);
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 2, new Object[]{inputStream}));
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 2, new Object[]{inputStream}));
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 3, new Object[]{inputStream, new Integer(n)}));
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 4, new Object[]{bigDecimal}));
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 5, new Object[]{inputStream}));
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(string, 5, new Object[]{inputStream}));
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 6, new Object[]{inputStream, new Integer(n)}));
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 8, new Object[]{inputStream}));
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 9, new Object[]{inputStream, new Long(l)}));
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 7, new Object[]{blob}));
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 8, new Object[]{inputStream}));
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 9, new Object[]{inputStream, new Long(l)}));
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 10, new Object[]{new Boolean(bl)}));
    }

    public void setByte(String string, byte by) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 11, new Object[]{new Byte(by)}));
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 12, new Object[]{byArray}));
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 13, new Object[]{reader}));
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 13, new Object[]{reader}));
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 14, new Object[]{reader, new Integer(n)}));
    }

    public void setClob(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 16, new Object[]{reader}));
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 17, new Object[]{reader, new Long(l)}));
    }

    public void setClob(String string, Clob clob) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 15, new Object[]{clob}));
    }

    public void setClob(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 16, new Object[]{reader}));
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 17, new Object[]{reader, new Long(l)}));
    }

    public void setDate(String string, Date date) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 18, new Object[]{date}));
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 19, new Object[]{date, calendar}));
    }

    public void setDouble(String string, double d) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 20, new Object[]{new Double(d)}));
    }

    public void setFloat(String string, float f) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 21, new Object[]{new Float(f)}));
    }

    public void setInt(String string, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 22, new Object[]{new Integer(n)}));
    }

    public void setLong(String string, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 23, new Object[]{new Long(l)}));
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 24, new Object[]{reader}));
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 24, new Object[]{reader}));
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 27, new Object[]{reader}));
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 28, new Object[]{reader, new Long(l)}));
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 27, new Object[]{reader}));
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 28, new Object[]{reader, new Long(l)}));
    }

    public void setNull(String string, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 30, new Object[]{new Integer(n)}));
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 31, new Object[]{new Integer(n), string2}));
    }

    public void setObject(String string, Object object) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 32, new Object[]{object}));
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 33, new Object[]{object, new Integer(n)}));
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 34, new Object[]{object, new Integer(n), new Integer(n2)}));
    }

    public void setShort(String string, short s) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 37, new Object[]{new Short(s)}));
    }

    public void setString(String string, String string2) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 39, new Object[]{string2}));
    }

    public void setTime(String string, Time time) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 40, new Object[]{time}));
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 41, new Object[]{time, calendar}));
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 42, new Object[]{timestamp}));
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(0, string, 43, new Object[]{timestamp, calendar}));
    }

    public void setURL(int n, URL uRL) throws SQLException {
        this.toConfigQuery();
        this.params.add(new WLParameter(n, null, 44, new Object[]{uRL}));
    }
}

