/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSetMetaData;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.spi.SyncProviderException;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.RowNotFoundException;
import weblogic.jdbc.rowset.RowSetBlob;
import weblogic.jdbc.rowset.RowSetClob;
import weblogic.jdbc.rowset.RowSetNClob;

public final class CachedRow
extends AbstractMap
implements Serializable,
Map,
Cloneable {
    private static final long serialVersionUID = -8966306632273347421L;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = true;
    private CachedRowSetMetaData metaData;
    private Object[] oldColumns;
    private Object[] columns;
    private transient Object[] conflicts;
    private BitSet modifiedCols;
    private boolean isUpdatedRow;
    private boolean isInsertRow;
    private boolean isDeletedRow;
    private transient CachedRow baseRow;
    private transient Map typeMap;
    private int columnCount;
    private int status = 3;

    public CachedRow(RowSetMetaData rowSetMetaData) throws SQLException {
        this.metaData = (CachedRowSetMetaData)rowSetMetaData;
        this.columnCount = rowSetMetaData.getColumnCount();
        this.columns = new Object[this.columnCount];
        this.modifiedCols = new BitSet(this.columnCount);
        this.isUpdatedRow = false;
        this.isInsertRow = false;
        this.isDeletedRow = false;
    }

    protected Object clone(CachedRowSetMetaData cachedRowSetMetaData) {
        CachedRow cachedRow = null;
        try {
            cachedRow = (CachedRow)super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
        cachedRow.metaData = cachedRowSetMetaData;
        cachedRow.columns = new Object[this.columns.length];
        System.arraycopy(this.columns, 0, cachedRow.columns, 0, this.columns.length);
        cachedRow.modifiedCols = (BitSet)this.modifiedCols.clone();
        if (this.oldColumns != null) {
            cachedRow.oldColumns = new Object[this.oldColumns.length];
            System.arraycopy(this.oldColumns, 0, cachedRow.oldColumns, 0, this.oldColumns.length);
        }
        return cachedRow;
    }

    protected CachedRow createShared(CachedRowSetMetaData cachedRowSetMetaData) throws SyncProviderException {
        CachedRow cachedRow;
        if (this.baseRow != null) {
            cachedRow = (CachedRow)this.baseRow.clone(cachedRowSetMetaData);
            cachedRow.baseRow = this.baseRow;
        } else {
            cachedRow = (CachedRow)this.clone(cachedRowSetMetaData);
            cachedRow.baseRow = this;
        }
        if (cachedRow.oldColumns != null) {
            cachedRow.columns = cachedRow.oldColumns;
        }
        cachedRow.acceptChanges();
        return cachedRow;
    }

    CachedRow getBaseRow() {
        return this.baseRow;
    }

    void copyFrom(CachedRow cachedRow) {
        if (cachedRow == null) {
            return;
        }
        System.arraycopy(cachedRow.columns, 0, this.columns, 0, cachedRow.columns.length);
    }

    void copyFrom(int n, CachedRow cachedRow) {
        if (cachedRow == null) {
            return;
        }
        int[] nArray = new int[cachedRow.getMetaData().getColumnCount()];
        for (int i = 0; i < cachedRow.getMetaData().getColumnCount(); ++i) {
            nArray[i] = i + 1;
        }
        this.copyFrom(n, cachedRow, nArray);
    }

    void copyFrom(int n, CachedRow cachedRow, int[] nArray) {
        if (cachedRow == null) {
            return;
        }
        int n2 = 0;
        for (int i = n; i < n + nArray.length; ++i) {
            this.columns[i] = cachedRow.columns[nArray[n2++] - 1];
        }
    }

    public CachedRow(ResultSet resultSet, RowSetMetaData rowSetMetaData, Map map) throws SQLException {
        this(rowSetMetaData);
        this.typeMap = map;
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns[i] = this.retrieveData(resultSet, i);
        }
    }

    private Object retrieveData(ResultSet resultSet, int n) throws SQLException {
        Object object = null;
        object = this.typeMap == null ? resultSet.getObject(n + 1) : resultSet.getObject(n + 1, this.typeMap);
        if (this.metaData.getColumnType(n + 1) == 93) {
            object = resultSet.getTimestamp(n + 1);
        }
        if (object instanceof NClob) {
            object = new RowSetNClob((NClob)object);
        } else if (object instanceof Clob) {
            object = new RowSetClob((Clob)object);
        } else if (object instanceof Blob) {
            object = new RowSetBlob((Blob)object);
        } else if (object instanceof Array && !(object instanceof SerialArray)) {
            object = new SerialArray((Array)object);
        } else if (object instanceof Ref) {
            object = new SerialRef((Ref)object);
        } else if (object instanceof URL) {
            object = new SerialDatalink((URL)object);
        }
        return object;
    }

    public CachedRowSetMetaData getMetaData() {
        return this.metaData;
    }

    public void setMetaData(CachedRowSetMetaData cachedRowSetMetaData) {
        this.metaData = cachedRowSetMetaData;
    }

    public Object[] getOldColumns() {
        return this.oldColumns;
    }

    public void clearModified() {
        this.modifiedCols.clear();
    }

    public BitSet getModifiedColumns() {
        return this.modifiedCols;
    }

    public boolean isModified(int n) throws SQLException {
        if (n > 0 && n <= this.columnCount) {
            return this.modifiedCols.get(n - 1);
        }
        throw new SQLException("There is no column: " + n + " in this RowSet");
    }

    public void setModified(int n, boolean bl) throws SQLException {
        if (n > 0 && n <= this.columnCount) {
            if (bl) {
                this.modifiedCols.set(n - 1);
            } else {
                this.modifiedCols.clear(n - 1);
            }
        } else {
            throw new SQLException("There is no column: " + n + " in this RowSet");
        }
    }

    public void mergeOriginalValues(CachedRow cachedRow, BitSet bitSet) throws SQLException {
        this.modifiedCols = bitSet;
        Object[] objectArray = cachedRow.getColumns();
        this.oldColumns = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.oldColumns[i] = bitSet.get(i) ? objectArray[i] : this.columns[i];
        }
    }

    public void mergeNewValues(CachedRow cachedRow, BitSet bitSet) throws SQLException {
        this.modifiedCols = bitSet;
        Object[] objectArray = cachedRow.getColumns();
        this.oldColumns = new Object[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            this.oldColumns[i] = bitSet.get(i) ? objectArray[i] : this.columns[i];
        }
        System.arraycopy(objectArray, 0, this.columns, 0, this.columnCount);
    }

    public void cancelRowUpdates() {
        if (!this.isUpdatedRow) {
            return;
        }
        this.columns = this.oldColumns;
        this.oldColumns = null;
        this.isUpdatedRow = false;
    }

    public void acceptChanges() throws SyncProviderException {
        this.oldColumns = null;
        this.isUpdatedRow = false;
        this.isInsertRow = false;
        this.isDeletedRow = false;
        for (int i = 0; i < this.modifiedCols.length(); ++i) {
            this.modifiedCols.clear(i);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("[CachedRow]: [" + System.identityHashCode(this) + "] columnCount: " + this.columnCount + " isUpdatedRow: " + this.isUpdatedRow + " modifiedCols: " + this.modifiedCols + " isInsertRow: " + this.isInsertRow + " isDeletedRow: " + this.isDeletedRow);
        stringBuffer.append("\nColumns:\n");
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                stringBuffer.append("[" + this.metaData.getColumnName(i + 1) + " = " + this.columns[i]);
                if (this.oldColumns != null && this.isModified(i + 1)) {
                    stringBuffer.append(", old value = " + this.oldColumns[i]);
                }
            }
            catch (SQLException sQLException) {
                throw new AssertionError((Object)sQLException);
            }
            stringBuffer.append("] ");
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    public boolean isDeletedRow() {
        return this.isDeletedRow;
    }

    public void setDeletedRow(boolean bl) throws SQLException {
        if (this.metaData.isReadOnly()) {
            throw new SQLException("This RowSet is Read-Only.  You must  setReadOnly(false) before attempting to delete a row.");
        }
        this.isDeletedRow = bl;
    }

    public boolean isInsertRow() {
        return this.isInsertRow;
    }

    public void setInsertRow(boolean bl) {
        this.isInsertRow = bl;
    }

    public boolean isUpdatedRow() {
        return this.isUpdatedRow;
    }

    public void setUpdatedRow(boolean bl) {
        this.isUpdatedRow = bl;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getColumn(int n) throws SQLException {
        try {
            return this.columns[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("There is no column: " + n + " in this RowSet");
        }
    }

    public Object getOldColumn(int n) throws SQLException {
        try {
            return this.oldColumns[n - 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("There is no column: " + n + " in this RowSet");
        }
    }

    private void copyColumns() {
        this.oldColumns = this.columns;
        this.columns = new Object[this.columnCount];
        System.arraycopy(this.oldColumns, 0, this.columns, 0, this.columnCount);
    }

    void setOriginal(int n, Object object) {
        this.columns[n - 1] = object;
        if (this.oldColumns != null) {
            this.oldColumns[n - 1] = object;
        }
    }

    public void setColumn(int n, Object object) {
        this.columns[n - 1] = object;
    }

    private boolean isVersionColumn(int n) throws SQLException {
        return this.metaData.getOptimisticPolicy() == 6 && this.metaData.isVersionColumn(n);
    }

    public Object updateColumn(int n, Object object) throws SQLException {
        try {
            if (this.metaData.isReadOnly()) {
                throw new SQLException("This RowSet is Read-Only and cannot be updated.");
            }
            if (!this.isInsertRow && this.metaData.isReadOnly(n)) {
                throw new SQLException("Column: " + this.metaData.getColumnName(n) + " is marked as read-only and cannot be updated.");
            }
            if (this.isInsertRow) {
                this.columns[n - 1] = this.typeConvert(n, object);
                this.modifiedCols.set(n - 1);
                return null;
            }
            if (this.isVersionColumn(n)) {
                Object object2 = this.columns[n - 1];
                this.columns[n - 1] = this.typeConvert(n, object);
                if (this.isUpdatedRow) {
                    this.oldColumns[n - 1] = this.columns[n - 1];
                }
                return object2;
            }
            if (!this.isUpdatedRow) {
                this.copyColumns();
                this.isUpdatedRow = true;
            }
            Object object3 = this.columns[n - 1];
            this.columns[n - 1] = this.typeConvert(n, object);
            this.modifiedCols.set(n - 1);
            return object3;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SQLException("There is no column: " + n + " in this RowSet");
        }
    }

    private Object typeConvert(int n, Object object) throws SQLException {
        if (this.metaData != null) {
            switch (this.metaData.getColumnType(n)) {
                case 2011: {
                    if (object instanceof String) {
                        return new RowSetNClob((String)object);
                    }
                    if (object instanceof char[]) {
                        return new RowSetNClob((char[])object);
                    }
                    if (!(object instanceof NClob) || object instanceof RowSetNClob) break;
                    return new RowSetNClob((NClob)object);
                }
                case 2005: {
                    if (object instanceof String) {
                        return new RowSetClob((String)object);
                    }
                    if (object instanceof char[]) {
                        return new RowSetClob((char[])object);
                    }
                    if (object instanceof NClob && !(object instanceof RowSetNClob)) {
                        return new RowSetNClob((NClob)object);
                    }
                    if (!(object instanceof Clob) || object instanceof RowSetClob) break;
                    return new RowSetClob((Clob)object);
                }
                case 2004: {
                    if (object instanceof byte[]) {
                        return new RowSetBlob((byte[])object);
                    }
                    if (!(object instanceof Blob) || object instanceof RowSetBlob) break;
                    return new RowSetBlob((Blob)object);
                }
            }
        }
        return object;
    }

    Object getConflictValue(int n) {
        if (n < 1 || n > this.columnCount) {
            throw new RuntimeException("Invalid column index.");
        }
        if (this.conflicts == null) {
            if (this.status == 1 || this.status == 0) {
                throw new RowNotFoundException("No conflict value available since the corresponding row has already been deleted in the datasource.");
            }
            throw new RuntimeException("No conflict has been detected.");
        }
        return this.conflicts[n - 1];
    }

    void setConflictValue(int n, Object object) {
        if (n < 1 || n > this.columnCount) {
            throw new RuntimeException("Invalid column index.");
        }
        if (this.conflicts == null) {
            this.conflicts = new Object[this.columns.length];
        }
        this.conflicts[n - 1] = object;
    }

    boolean setConflictValue(ResultSet resultSet, int[] nArray) throws SQLException {
        boolean bl = false;
        if (this.conflicts == null) {
            this.conflicts = new Object[this.columns.length];
        }
        int n = -1;
        for (int i = 0; i < nArray.length && (n = nArray[i]) != -1; ++i) {
            Object object;
            this.conflicts[n] = object = this.retrieveData(resultSet, i);
            try {
                if (object == null) {
                    if (this.columns[n] == null) continue;
                    bl = true;
                    continue;
                }
                if (object.equals(this.columns[n])) continue;
                bl = true;
                continue;
            }
            catch (Exception exception) {
                bl = true;
            }
        }
        if (!bl) {
            this.conflicts = null;
        }
        return bl;
    }

    int getStatus() {
        return this.status;
    }

    void setStatus(int n) {
        this.status = n;
    }

    void setResolvedValue(int n, Object object) {
        if (n < 1 || n > this.columnCount) {
            throw new RuntimeException("Invalid column index.");
        }
        this.columns[n - 1] = object;
        if (this.oldColumns != null) {
            this.oldColumns[n - 1] = this.conflicts[n - 1];
        }
    }

    public Object[] getColumns() {
        return this.columns;
    }

    public int size() {
        return this.columnCount;
    }

    public boolean isEmpty() {
        return this.columnCount == 0;
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean containsValue(Object object) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (!(this.columns[i] == null ? object == null : this.columns[i].equals(object))) continue;
            return true;
        }
        return false;
    }

    public Object get(Object object) {
        try {
            return this.getColumn(this.metaData.findColumn((String)object));
        }
        catch (SQLException sQLException) {
            return null;
        }
        catch (ClassCastException classCastException) {
            throw new SQLRuntimeException("Key class: " + object.getClass().getName() + " was not java.lang.String", classCastException);
        }
    }

    public Object put(Object object, Object object2) {
        try {
            return this.updateColumn(this.metaData.findColumn((String)object), object2);
        }
        catch (SQLException sQLException) {
            throw new SQLRuntimeException(sQLException);
        }
        catch (ClassCastException classCastException) {
            throw new SQLRuntimeException("Key class: " + object.getClass().getName() + " was not java.lang.String", classCastException);
        }
    }

    public Object remove(Object object) {
        return this.put(object, (Object)null);
    }

    public void clear() {
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                this.put(this.metaData.getColumnName(i + 1), (Object)null);
                continue;
            }
            catch (SQLException sQLException) {
                throw new AssertionError((Object)sQLException);
            }
        }
    }

    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>(this.columnCount);
        for (int i = 0; i < this.columnCount; ++i) {
            try {
                hashSet.add(new Entry(this.metaData.getColumnName(i + 1), this.columns[i]));
                continue;
            }
            catch (SQLException sQLException) {
                throw new AssertionError((Object)sQLException);
            }
        }
        return hashSet;
    }

    private static class SQLRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1444694475457733067L;

        SQLRuntimeException(Throwable throwable) {
            super(throwable);
        }

        SQLRuntimeException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    private static final class Entry
    implements Map.Entry {
        private final Object key;
        private Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (this.key.equals(entry.key)) {
                if (this.value == null) {
                    return entry.value == null;
                }
                return this.value.equals(entry.value);
            }
            return false;
        }

        public int hashCode() {
            if (this.value == null) {
                return this.key.hashCode();
            }
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

