/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.Predicate;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.SyncResolver;
import javax.transaction.Transaction;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.rowset.BaseRowSet;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetJDBCReader;
import weblogic.jdbc.rowset.CachedRowSetJDBCWriter;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.LifeCycle;
import weblogic.jdbc.rowset.SharedRowSetImpl;
import weblogic.jdbc.rowset.TableNameParser;
import weblogic.jdbc.rowset.WLCachedRowSet;
import weblogic.jdbc.rowset.WLParameter;
import weblogic.jdbc.rowset.WLRowSetInternal;
import weblogic.jdbc.rowset.WLSyncProvider;
import weblogic.jdbc.rowset.WebRowSetReader;
import weblogic.jdbc.rowset.WebRowSetWriter;
import weblogic.jdbc.rowset.XMLInstanceReader;
import weblogic.jdbc.rowset.XMLInstanceWriter;
import weblogic.transaction.TransactionHelper;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedRowSetImpl
extends BaseRowSet
implements WLCachedRowSet,
WLRowSetInternal,
SyncResolver,
Serializable,
Cloneable {
    private static final long serialVersionUID = -7682272538461932607L;
    private static final String DEBUGSTR = "weblogic.jdbc.rowset.CachedRowSet.debug";
    private static final String VERBOSESTR = "weblogic.jdbc.rowset.CachedRowSet.debug";
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.jdbc.rowset.CachedRowSet.debug");
    private static final boolean VERBOSE = Boolean.getBoolean("weblogic.jdbc.rowset.CachedRowSet.debug");
    private static final Pattern FROM_PATTERN = Pattern.compile("(?i)\\bfrom\\s+([a-zA-Z_0-9.]+)");
    CachedRow insertRow;
    ArrayList allrows = new ArrayList();
    transient ArrayList rows = new ArrayList();
    transient Predicate filter;
    transient Comparator sorter;
    transient CachedRowSetImpl baseRowSet;
    volatile transient Object lock = null;
    transient int lockNum = 0;
    transient int currentPage = 0;
    transient Connection txConnection = null;
    transient Connection pendingConnection = null;
    transient ResultSet pendingResultSet = null;
    transient boolean populateFromResultSet = true;
    private transient int sc = 0;
    private boolean isPopulated = false;
    RowSetCacheKey key = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lock() {
        if (this.lock == Thread.currentThread()) {
            ++this.lockNum;
            return;
        }
        boolean bl = false;
        while (true) {
            if (this.lock != null) {
                continue;
            }
            CachedRowSetImpl cachedRowSetImpl = this;
            synchronized (cachedRowSetImpl) {
                if (this.lock == null) {
                    this.lock = Thread.currentThread();
                    bl = true;
                }
            }
            if (bl) break;
        }
        ++this.lockNum;
    }

    void unlock() {
        if (this.lock == Thread.currentThread()) {
            --this.lockNum;
            if (this.lockNum == 0) {
                this.lock = null;
            }
        } else {
            throw new RuntimeException("============================Internal Error: CachedRowSetImpl sync lock is broken. lock: " + this.lock + " current: " + Thread.currentThread());
        }
    }

    public CachedRowSetImpl() {
        try {
            this.metaData = new CachedRowSetMetaData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reset();
    }

    public CachedRowSetImpl(Hashtable hashtable) {
        try {
            this.metaData = new CachedRowSetMetaData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.reset();
    }

    @Override
    public void populate(ResultSetMetaData resultSetMetaData) throws SQLException {
        this.checkOp(2);
        this.clearData();
        if (resultSetMetaData instanceof CachedRowSetMetaData) {
            this.metaData = (CachedRowSetMetaData)((CachedRowSetMetaData)resultSetMetaData).clone();
        } else {
            DatabaseMetaData databaseMetaData = null;
            try {
                databaseMetaData = this.getConnection().getMetaData();
            }
            catch (Exception exception) {
                JDBCLogger.logStackTrace((Throwable)exception);
            }
            this.metaData.initialize(resultSetMetaData, databaseMetaData);
        }
        this.rowSetChanged();
    }

    void populateInternal(ResultSet resultSet) throws SQLException {
        this.populate(resultSet);
        this.populateFromResultSet = false;
        this.pendingResultSet = null;
        this.setIsClosed(false);
    }

    @Override
    public void populate(ResultSet resultSet) throws SQLException {
        int n = this.currentPage * this.maxRows + 1;
        this.populate(resultSet, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void populate(ResultSet resultSet, int n) throws SQLException {
        block40: {
            int n2;
            boolean bl;
            block39: {
                bl = true;
                if (n < 0) {
                    throw new SQLException(n + " is not a valid start position.");
                }
                this.checkOp(2);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                if (resultSetMetaData instanceof CachedRowSetMetaData) {
                    this.metaData = (CachedRowSetMetaData)((CachedRowSetMetaData)resultSetMetaData).clone();
                } else {
                    DatabaseMetaData databaseMetaData = null;
                    try {
                        databaseMetaData = resultSet.getStatement().getConnection().getMetaData();
                    }
                    catch (Exception exception) {
                        JDBCLogger.logStackTrace((Throwable)exception);
                    }
                    if (databaseMetaData == null) {
                        try {
                            databaseMetaData = this.getConnection().getMetaData();
                        }
                        catch (Exception exception) {
                            JDBCLogger.logStackTrace((Throwable)exception);
                        }
                    }
                    this.metaData.initialize(resultSetMetaData, databaseMetaData);
                }
                n2 = -1;
                boolean bl2 = false;
                try {
                    n2 = resultSet.getRow();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (n2 == -1 && resultSet.isBeforeFirst()) {
                        n2 = 0;
                    }
                }
                catch (Throwable throwable) {
                    n2 = 0;
                }
                try {
                    if (resultSet.getType() != 1003) {
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (bl) {
                        if (n2 < 0 || n2 > n) throw new SQLException("absolute not supported on ResultSet.TYPE_FORWARD_ONLY; ResultSet position is " + n2 + "; populate position is " + n);
                        for (int i = 0; i < n - n2; ++i) {
                            bl2 = resultSet.next();
                        }
                    } else {
                        bl2 = resultSet.absolute(n);
                    }
                }
                catch (SQLException sQLException) {
                    if (n2 < 0 || n2 > n) throw sQLException;
                    for (int i = 0; i < n - n2; ++i) {
                        bl2 = resultSet.next();
                    }
                }
                try {
                    int n3 = 0;
                    if (bl2) {
                        this.clearData();
                        this.pendingResultSet = resultSet;
                        this.populateFromResultSet = true;
                        do {
                            if (this.maxRows != 0 && ++n3 > this.maxRows) {
                                this.setIsComplete(false);
                                break;
                            }
                            this.allrows.add(new CachedRow(resultSet, this.metaData, this.getTypeMap()));
                            this.isPopulated = true;
                        } while (resultSet.next());
                    } else if (n == 1) {
                        this.clearData();
                    }
                    Object var10_19 = null;
                    if (n2 > 0) break block39;
                }
                catch (Throwable throwable) {
                    Object var10_20 = null;
                    if (n2 <= 0) {
                        try {
                            if (bl) throw throwable;
                            resultSet.beforeFirst();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        if (bl) throw throwable;
                        resultSet.absolute(n2);
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (!bl) {
                        resultSet.beforeFirst();
                    }
                    break block40;
                }
                catch (Exception exception) {}
                break block40;
            }
            try {
                if (!bl) {
                    resultSet.absolute(n2);
                }
            }
            catch (Exception exception) {}
        }
        this.filter();
        this.rowSetChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws SQLException {
        block7: {
            if (this.command == null || this.command.equals("")) {
                throw new SQLException("You must call setCommand with a SQL string before calling execute().");
            }
            Connection connection = this.getConnection();
            if (connection == null) {
                throw new SQLException("Can not get a connection.");
            }
            try {
                this.execute(connection);
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cachedConnection = null;
                this.pendingConnection = null;
                throw throwable;
            }
            try {
                connection.close();
                break block7;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
            }
        }
        this.cachedConnection = null;
        this.pendingConnection = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Connection connection) throws SQLException {
        if (connection == null) {
            throw new SQLException("Can not calling execute with null connection");
        }
        Connection connection2 = this.cachedConnection;
        this.cachedConnection = connection;
        try {
            this.reader.readData(this);
            this.pendingConnection = connection;
            Object var4_3 = null;
            this.cachedConnection = connection2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.cachedConnection = connection2;
            throw throwable;
        }
    }

    @Override
    public String executeAndGuessTableName() throws SQLException {
        this.execute();
        Matcher matcher = FROM_PATTERN.matcher(this.command);
        if (!matcher.find()) {
            return null;
        }
        String string = matcher.group(1);
        this.metaData.setTableName(string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public boolean executeAndGuessTableNameAndPrimaryKeys() throws SQLException {
        Exception exception322;
        boolean bl;
        ResultSet resultSet;
        Connection connection;
        block31: {
            block28: {
                Exception exception2222;
                boolean bl2;
                block29: {
                    String string = this.executeAndGuessTableName();
                    if (string == null) {
                        return false;
                    }
                    connection = null;
                    resultSet = null;
                    connection = this.getConnection();
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    TableNameParser tableNameParser = new TableNameParser(string, new DatabaseMetaDataHolder(databaseMetaData));
                    String[] stringArray = tableNameParser.parse();
                    String string2 = "".equals(stringArray[0]) ? null : stringArray[0];
                    String string3 = "".equals(stringArray[1]) ? null : stringArray[1];
                    String string4 = stringArray[2];
                    resultSet = databaseMetaData.getPrimaryKeys(string2, string3, string4);
                    if (resultSet.next()) break block28;
                    if (string2 != null) {
                        string2 = string2.toUpperCase();
                    }
                    if (string3 != null) {
                        string3 = string3.toUpperCase();
                    }
                    if (string4 != null) {
                        string4 = string4.toUpperCase();
                    }
                    if ((resultSet = databaseMetaData.getPrimaryKeys(string2, string3, string4)).next()) break block28;
                    if (string2 != null) {
                        string2 = string2.toLowerCase();
                    }
                    if (string3 != null) {
                        string3 = string3.toLowerCase();
                    }
                    if (string4 != null) {
                        string4 = string4.toLowerCase();
                    }
                    if ((resultSet = databaseMetaData.getPrimaryKeys(string2, string3, string4)).next()) break block28;
                    bl2 = false;
                    Object var12_14 = null;
                    if (resultSet == null) break block29;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                this.cachedConnection = null;
                return bl2;
            }
            do {
                this.metaData.setPrimaryKeyColumn(resultSet.getString("COLUMN_NAME"), true);
            } while (resultSet.next());
            bl = true;
            Object var12_15 = null;
            if (resultSet == null) break block31;
            try {
                resultSet.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception322) {
                // empty catch block
            }
        }
        this.cachedConnection = null;
        return bl;
        catch (SQLException sQLException) {
            Exception exception4222;
            boolean bl3;
            block33: {
                try {
                    JDBCLogger.logStackTrace((Throwable)sQLException);
                    bl3 = false;
                    Object var12_16 = null;
                    if (resultSet == null) break block33;
                }
                catch (Throwable throwable) {
                    Exception exception5222;
                    Object var12_17 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Exception exception5222) {
                            // empty catch block
                        }
                    }
                    this.cachedConnection = null;
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception4222) {
                    // empty catch block
                }
            }
            this.cachedConnection = null;
            return bl3;
        }
    }

    void refresh() throws SyncProviderException {
        for (CachedRow cachedRow : this.rows) {
            if (cachedRow.isDeletedRow()) {
                this.allrows.remove(cachedRow);
            }
            cachedRow.acceptChanges();
        }
        this.filter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLException sync(Connection connection) {
        SQLException sQLException = null;
        Connection connection2 = this.cachedConnection;
        this.cachedConnection = connection;
        try {
            try {
                this.writer.writeData(this);
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
                Object var6_5 = null;
                this.cachedConnection = connection2;
            }
            Object var6_4 = null;
            this.cachedConnection = connection2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.cachedConnection = connection2;
            throw throwable;
        }
        return sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void acceptChanges() throws SyncProviderException {
        block29: {
            if (this.isReadOnly()) {
                return;
            }
            Connection connection = null;
            Throwable throwable = null;
            boolean bl = false;
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            try {
                if (transaction != null && transaction.getStatus() == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                if (this.cachedConnection != null) {
                    try {
                        this.cachedConnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.cachedConnection = null;
                }
                if ((connection = this.getConnection()) == null) {
                    throw new SQLException("Can not get a connection");
                }
                this.checkOp(9);
                throwable = this.sync(connection);
                if (throwable != null) {
                    try {
                        transaction.setRollbackOnly();
                    }
                    catch (Exception exception) {}
                }
            } else {
                connection = this.getConnection();
                connection.setAutoCommit(false);
                this.checkOp(10);
                this.lock();
                try {
                    throwable = this.sync(connection);
                    if (throwable == null) {
                        connection.commit();
                        this.refresh();
                    } else {
                        connection.rollback();
                    }
                    Object var7_9 = null;
                    this.unlock();
                }
                catch (Throwable throwable2) {
                    Object var7_10 = null;
                    this.unlock();
                    throw throwable2;
                }
            }
            Object var9_12 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.cachedConnection = null;
            if (throwable != null) {
                if (throwable instanceof SyncProviderException) {
                    throw (SyncProviderException)throwable;
                }
                throw new SyncProviderException(throwable.toString());
            }
            break block29;
            {
                catch (Exception exception) {
                    throw new SyncProviderException(exception.toString());
                }
            }
            catch (Throwable throwable3) {
                Object var9_13 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.cachedConnection = null;
                if (throwable != null) {
                    if (throwable instanceof SyncProviderException) {
                        throw (SyncProviderException)throwable;
                    }
                    throw new SyncProviderException(throwable.toString());
                }
                throw throwable3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void acceptChanges(Connection connection) throws SyncProviderException {
        block22: {
            if (this.isReadOnly()) {
                return;
            }
            if (connection == null) {
                throw new SyncProviderException("acceptChanges(java.sql.Connection conn) can not be invoked with null conn");
            }
            SQLException sQLException = null;
            boolean bl = false;
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            try {
                if (transaction != null && transaction.getStatus() == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                throw new SyncProviderException("failed");
            }
            try {
                block21: {
                    try {
                        if (bl) {
                            this.checkOp(9);
                            sQLException = this.sync(connection);
                            if (sQLException == null) break block21;
                            try {
                                transaction.setRollbackOnly();
                                break block21;
                            }
                            catch (Exception exception) {
                                throw new SyncProviderException("failed");
                            }
                        }
                        if (connection == null) {
                            throw new SyncProviderException("Can not calling acceptChanges with null connection");
                        }
                        if (connection.getAutoCommit()) {
                            connection.setAutoCommit(false);
                            this.checkOp(10);
                            this.lock();
                            try {
                                sQLException = this.sync(connection);
                                if (sQLException == null) {
                                    connection.commit();
                                    this.refresh();
                                } else {
                                    connection.rollback();
                                }
                                Object var7_8 = null;
                                this.unlock();
                            }
                            catch (Throwable throwable) {
                                Object var7_9 = null;
                                this.unlock();
                                connection.setAutoCommit(true);
                                throw throwable;
                            }
                            connection.setAutoCommit(true);
                            break block21;
                        }
                        this.checkOp(9);
                        sQLException = this.sync(connection);
                        this.txConnection = connection;
                    }
                    catch (Exception exception) {
                        throw new SyncProviderException(exception.toString());
                    }
                }
                Object var9_11 = null;
                if (sQLException == null) break block22;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                if (sQLException == null) {
                    throw throwable;
                }
                if (sQLException instanceof SyncProviderException) {
                    throw (SyncProviderException)sQLException;
                }
                throw new SyncProviderException(sQLException.toString());
            }
            if (sQLException instanceof SyncProviderException) {
                throw (SyncProviderException)sQLException;
            }
            throw new SyncProviderException(sQLException.toString());
        }
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkOp(8);
        if (this.insertRow == null) {
            throw new SQLException("There is no data to insert");
        }
        if (this.filter != null && !this.filter.evaluate(this)) {
            throw new SQLException("Inserted row violates the criteria of the current filter.");
        }
        this.rows.add(this.insertRow);
        this.allrows.add(this.insertRow);
        this.insertRow = null;
        this.rowChanged();
    }

    @Override
    public void undoInsert() throws SQLException {
        this.checkOp(4);
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isInsertRow()) {
            try {
                this.rows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.allrows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.rowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkOp(4);
        this.currentRow().setDeletedRow(true);
        this.rowChanged();
    }

    @Override
    public void undoDelete() throws SQLException {
        this.checkOp(4);
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isDeletedRow()) {
            cachedRow.setDeletedRow(false);
        }
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkOp(8);
        if (this.filter != null && !this.filter.evaluate(this)) {
            throw new SQLException("Updated row violates the criteria of the current filter.");
        }
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isInsertRow()) {
            if (cachedRow.isUpdatedRow() && this.rows.indexOf(cachedRow) != -1) {
                this.rows.add(cachedRow);
                this.allrows.add(cachedRow);
                this.insertRow = null;
            }
        } else {
            cachedRow.setUpdatedRow(true);
        }
        this.rowChanged();
    }

    @Override
    public void undoUpdate() throws SQLException {
        this.checkOp(4);
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isInsertRow() && cachedRow.isUpdatedRow()) {
            try {
                this.rows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.allrows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {}
        } else if (cachedRow.isUpdatedRow()) {
            cachedRow.cancelRowUpdates();
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkOp(8);
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isInsertRow()) {
            this.insertRow = null;
        } else {
            cachedRow.cancelRowUpdates();
        }
    }

    @Override
    public void setOriginalRow() throws SQLException {
        this.checkOp(4);
        CachedRow cachedRow = this.currentRow();
        if (cachedRow.isInsertRow()) {
            try {
                this.rows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                this.allrows.remove(this.rows.indexOf(cachedRow));
            }
            catch (Throwable throwable) {}
        } else {
            if (cachedRow.isDeletedRow()) {
                cachedRow.setDeletedRow(false);
            }
            if (cachedRow.isUpdatedRow()) {
                cachedRow.cancelRowUpdates();
            }
        }
        this.rowSetChanged();
    }

    @Override
    public void restoreOriginal() throws SQLException {
        this.checkOp(4);
        for (int i = 0; i < this.rows.size(); ++i) {
            CachedRow cachedRow = (CachedRow)this.rows.get(i);
            if (cachedRow.isInsertRow()) {
                try {
                    this.rows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.allrows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (cachedRow.isDeletedRow()) {
                cachedRow.setDeletedRow(false);
            }
            if (!cachedRow.isUpdatedRow()) continue;
            cachedRow.cancelRowUpdates();
        }
        this.rowIndex = -1;
        this.isComplete = true;
        this.txConnection = null;
        this.cachedConnection = null;
        this.pendingResultSet = null;
        this.pendingConnection = null;
        this.state = LifeCycle.POPULATING;
        this.rowSetChanged();
    }

    @Override
    public ResultSet getOriginal() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.clone();
        cachedRowSetImpl.resetState();
        cachedRowSetImpl.rowIndex = -1;
        cachedRowSetImpl.state = LifeCycle.MANIPULATING;
        cachedRowSetImpl.restoreOriginal();
        return cachedRowSetImpl;
    }

    @Override
    public ResultSet getOriginalRow() throws SQLException {
        CachedRow cachedRow = this.currentRow();
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.createCopySchema();
        if (!cachedRow.isInsertRow()) {
            cachedRow = (CachedRow)cachedRow.clone((CachedRowSetMetaData)cachedRowSetImpl.getMetaData());
            cachedRow.setDeletedRow(false);
            cachedRow.cancelRowUpdates();
            cachedRowSetImpl.rows.add(cachedRow);
            cachedRowSetImpl.allrows.add(cachedRow);
        }
        cachedRowSetImpl.resetState();
        cachedRowSetImpl.rowIndex = -1;
        cachedRowSetImpl.state = LifeCycle.MANIPULATING;
        return cachedRowSetImpl;
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("refreshRow is not supported.");
    }

    @Override
    public void moveToInsertRow() {
        this.checkOp(5);
    }

    @Override
    public void moveToCurrentRow() {
        this.checkOp(6);
    }

    @Override
    public void moveToUpdateRow() {
        this.checkOp(5);
        try {
            this.currentRow().setUpdatedRow(true);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable.toString());
        }
    }

    @Override
    public void setRowSynced() throws SQLException {
        CachedRow cachedRow = this.currentRow();
        if (!cachedRow.isDeletedRow() || !cachedRow.isInsertRow()) {
            if (cachedRow.isDeletedRow()) {
                try {
                    this.rows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.allrows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {}
            } else {
                cachedRow.acceptChanges();
            }
        }
    }

    @Override
    public void setRowSetSynced() throws SQLException {
        for (int i = 0; i < this.rows.size(); ++i) {
            CachedRow cachedRow = (CachedRow)this.rows.get(i);
            if (cachedRow.isDeletedRow() && cachedRow.isInsertRow()) continue;
            if (cachedRow.isDeletedRow()) {
                try {
                    this.rows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.allrows.remove(this.rows.indexOf(cachedRow));
                }
                catch (Throwable throwable) {}
                continue;
            }
            cachedRow.acceptChanges();
        }
    }

    @Override
    public void setFilter(Predicate predicate) {
        this.checkOp(2);
        this.filter = predicate;
        this.filter();
    }

    @Override
    public Predicate getFilter() {
        return this.filter;
    }

    void filter() throws RuntimeException {
        int n = this.rowIndex;
        ArrayList arrayList = this.rows;
        LifeCycle.State state = this.state;
        this.rows = this.allrows;
        try {
            this.allrows = new ArrayList(this.rows.size());
            for (int i = 0; i < this.rows.size(); ++i) {
                this.rowIndex = i;
                if (this.filter != null && !this.filter.evaluate(this)) continue;
                this.allrows.add(this.rows.get(i));
            }
            arrayList = this.rows;
            this.rows = this.allrows;
            this.allrows = arrayList;
        }
        catch (Throwable throwable) {
            this.allrows = this.rows;
            this.rows = arrayList;
            this.rowIndex = n;
            throw new RuntimeException(throwable.getMessage());
        }
        this.rowIndex = -1;
        if (this.sorter != null) {
            this.sort();
        }
        this.state = state;
    }

    @Override
    public void setSorter(Comparator comparator) {
        this.checkOp(2);
        this.sorter = comparator;
        this.sort();
    }

    @Override
    public Comparator getSorter() {
        return this.sorter;
    }

    void sort() throws RuntimeException {
        if (this.sorter != null) {
            Collections.sort(this.rows, this.sorter);
        } else {
            this.filter();
        }
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public Map getCurrentRow() throws SQLException {
        return this.currentRow();
    }

    @Override
    public Map getRow(int n) throws SQLException {
        try {
            return (Map)this.rows.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException("getRow(" + n + ") is not a valid row index");
        }
    }

    @Override
    public Map[] getRows(int n, int n2) throws SQLException {
        if (n < 0 || n >= this.rows.size()) {
            throw new SQLException("startIndex must be > 0 or < CachedRowSet.size()");
        }
        if (n > n2) {
            throw new SQLException("startIndex cannot be > endIndex");
        }
        if (n2 < 0 || n2 > this.rows.size()) {
            throw new SQLException("endIndex cannot be < 0 or > CachedRowSet.size()");
        }
        ArrayList arrayList = new ArrayList();
        for (int i = n; i < n2; ++i) {
            arrayList.add(this.rows.get(i));
        }
        Map[] mapArray = new Map[arrayList.size()];
        return arrayList.toArray(mapArray);
    }

    @Override
    public Map[] getRows() throws SQLException {
        Map[] mapArray = new Map[this.rows.size()];
        return this.rows.toArray(mapArray);
    }

    public List getAllCachedRows() {
        return this.allrows;
    }

    @Override
    public List getCachedRows() {
        return this.rows;
    }

    @Override
    public void setCachedRows(ArrayList arrayList) {
        this.allrows = arrayList;
        this.filter();
        this.rowIndex = 0;
    }

    public Collection toCollection() throws SQLException {
        ArrayList arrayList = new ArrayList(this.rows.size());
        arrayList.addAll(this.rows);
        return arrayList;
    }

    public Collection toCollection(int n) throws SQLException {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.rows.size());
        for (int i = 0; i < this.rows.size(); ++i) {
            arrayList.add(((CachedRow)this.rows.get(i)).getColumn(n));
        }
        return arrayList;
    }

    public Collection toCollection(String string) throws SQLException {
        int n = this.findColumn(string);
        ArrayList<Object> arrayList = new ArrayList<Object>(this.rows.size());
        for (int i = 0; i < this.rows.size(); ++i) {
            arrayList.add(((CachedRow)this.rows.get(i)).getColumn(n));
        }
        return arrayList;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        CachedRow cachedRow;
        this.isComplete = true;
        objectInputStream.defaultReadObject();
        this.params = new ArrayList();
        this.rows = new ArrayList();
        this.provider = new WLSyncProvider();
        this.writer = new CachedRowSetJDBCWriter();
        this.reader = new CachedRowSetJDBCReader();
        this.locked = false;
        Iterator iterator = this.allrows.iterator();
        while (iterator.hasNext() && (cachedRow = (CachedRow)iterator.next()).getMetaData() == null) {
            cachedRow.setMetaData(this.metaData);
        }
        this.filter();
    }

    @Override
    public void loadXML(XMLInputStream xMLInputStream) throws IOException, SQLException {
        if (this.metaData == null || this.metaData.getColumnCount() == 0) {
            throw new SQLException("You must either use CachedRowSetMetaData.loadSchema toload an XML schema or set the RowSet's metadata before calling loadXML.");
        }
        this.checkOp(2);
        XMLInstanceReader xMLInstanceReader = new XMLInstanceReader(this);
        xMLInstanceReader.loadXML(xMLInputStream);
        this.allrows.clear();
        this.allrows.addAll(this.rows);
        this.state = LifeCycle.POPULATING;
    }

    @Override
    public void writeXML(XMLOutputStream xMLOutputStream) throws IOException, SQLException {
        this.writeXML(xMLOutputStream, 32);
    }

    @Override
    public void writeXML(XMLOutputStream xMLOutputStream, int n) throws IOException, SQLException {
        XMLInstanceWriter xMLInstanceWriter = new XMLInstanceWriter(this);
        xMLInstanceWriter.writeXML(xMLOutputStream, n);
    }

    public void readXml(XMLInputStream xMLInputStream) throws IOException, SQLException {
        this.checkOp(2);
        WebRowSetReader webRowSetReader = new WebRowSetReader(this);
        webRowSetReader.loadXML(xMLInputStream);
        this.allrows.clear();
        this.allrows.addAll(this.rows);
        this.state = LifeCycle.POPULATING;
    }

    @Override
    public void readXml(Reader reader) throws SQLException {
        try {
            this.readXml(XMLInputStreamFactory.newInstance().newInputStream(reader));
        }
        catch (NullPointerException nullPointerException) {
            throw nullPointerException;
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.toString());
        }
    }

    @Override
    public void readXml(InputStream inputStream) throws SQLException, IOException {
        this.readXml(XMLInputStreamFactory.newInstance().newInputStream(inputStream));
    }

    @Override
    public void writeXml(Writer writer) throws SQLException {
        WebRowSetWriter webRowSetWriter = new WebRowSetWriter(this);
        try {
            webRowSetWriter.writeXML(XMLOutputStreamFactory.newInstance().newDebugOutputStream(writer), 32);
        }
        catch (Throwable throwable) {
            throw new SQLException(throwable.toString());
        }
    }

    @Override
    public void writeXml(OutputStream outputStream) throws SQLException, IOException {
        WebRowSetWriter webRowSetWriter = new WebRowSetWriter(this);
        webRowSetWriter.writeXML(XMLOutputStreamFactory.newInstance().newDebugOutputStream(outputStream), 32);
    }

    @Override
    public void writeXml(ResultSet resultSet, Writer writer) throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.populate(resultSet);
        cachedRowSetImpl.writeXml(writer);
    }

    @Override
    public void writeXml(ResultSet resultSet, OutputStream outputStream) throws SQLException, IOException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.populate(resultSet);
        cachedRowSetImpl.writeXml(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() {
        this.lock();
        CachedRowSetImpl cachedRowSetImpl = null;
        try {
            cachedRowSetImpl = (CachedRowSetImpl)super.clone();
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Object var5_6 = null;
            this.unlock();
            return var3_5;
        }
        try {
            cachedRowSetImpl.metaData = (CachedRowSetMetaData)this.metaData.clone();
            cachedRowSetImpl.allrows = new ArrayList(this.allrows.size());
            for (int i = 0; i < this.allrows.size(); ++i) {
                cachedRowSetImpl.allrows.add(((CachedRow)this.allrows.get(i)).clone(this.metaData));
            }
            if (this.insertRow != null) {
                cachedRowSetImpl.insertRow = (CachedRow)this.insertRow.clone(this.metaData);
            }
            cachedRowSetImpl.rowSetListeners = (List)((ArrayList)this.rowSetListeners).clone();
            cachedRowSetImpl.cachedConnection = null;
            cachedRowSetImpl.params = (ArrayList)this.params.clone();
            cachedRowSetImpl.filter();
            CachedRowSetImpl cachedRowSetImpl2 = cachedRowSetImpl;
            Object var5_7 = null;
            this.unlock();
            return cachedRowSetImpl2;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach(SharedRowSetImpl sharedRowSetImpl) {
        this.lock();
        try {
            --this.sc;
            this.locked = this.sc > 0;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attach(SharedRowSetImpl sharedRowSetImpl) {
        this.lock();
        try {
            ++this.sc;
            this.locked = this.sc > 0;
            Object var3_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    @Override
    public RowSet createShared() throws SQLException {
        SharedRowSetImpl sharedRowSetImpl = null;
        this.lock();
        try {
            try {
                sharedRowSetImpl = new SharedRowSetImpl(this);
            }
            catch (Throwable throwable) {
                throw new SQLException(this + " can not be shared because of " + throwable);
            }
            Object var4_2 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.unlock();
            throw throwable;
        }
        return sharedRowSetImpl;
    }

    @Override
    public CachedRowSet createCopy() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)this.clone();
        cachedRowSetImpl.rowSetListeners.clear();
        return cachedRowSetImpl;
    }

    @Override
    public CachedRowSet createCopySchema() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.populate(this.getMetaData());
        return cachedRowSetImpl;
    }

    @Override
    public CachedRowSet createCopyNoConstraints() throws SQLException {
        CachedRowSetImpl cachedRowSetImpl = new CachedRowSetImpl();
        cachedRowSetImpl.populate(this);
        return cachedRowSetImpl;
    }

    @Override
    public void close() {
        this.reset();
        this.setIsClosed(true);
    }

    @Override
    public void release() throws SQLException {
        this.reset();
    }

    private void reset() {
        this.clearData();
        this.resetState();
    }

    private void clearData() {
        this.rows.clear();
        this.allrows.clear();
        this.rowIndex = -1;
        this.isComplete = true;
        this.txConnection = null;
        this.pendingResultSet = null;
        this.pendingConnection = null;
    }

    private void resetState() {
        this.command = "";
        this.dataSourceName = null;
        this.dataSource = null;
        this.url = "";
        this.userName = null;
        this.password = null;
        this.isolationLevel = -1;
        this.fetchDirection = 1002;
        this.fetchSize = 0;
        this.typeMap = null;
        this.queryTimeout = 0;
        this.maxRows = 0;
        this.maxFieldSize = 0;
        this.escapeProcessing = true;
        this.concurrency = 1008;
        this.resultSetType = 1004;
        this.preferDataSource = true;
        this.cachedConnection = null;
        this.rowSetListeners.clear();
        this.state = LifeCycle.DESIGNING;
        this.params.clear();
        this.metaData.setReadOnly(false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[CachedRowSet]: [" + System.identityHashCode(this) + "] rowIndex: " + this.rowIndex);
        if (this.metaData == null) {
            stringBuffer.append("\nMETADATA: <NULL>");
        } else {
            stringBuffer.append("\nMETADATA: " + this.metaData);
        }
        stringBuffer.append("\n\nROWS:\n\n");
        Iterator iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public Object getConflictValue(int n) {
        try {
            return this.currentRow().getConflictValue(n);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Object getConflictValue(String string) {
        try {
            return this.currentRow().getConflictValue(this.findColumn(string));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public int getStatus() {
        try {
            return this.currentRow().getStatus();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setResolvedValue(int n, Object object) {
        try {
            this.currentRow().setResolvedValue(n, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void setResolvedValue(String string, Object object) {
        try {
            this.currentRow().setResolvedValue(this.findColumn(string), object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean nextConflict() throws SQLException {
        boolean bl = false;
        while (this.next()) {
            if (this.currentRow().getStatus() == 3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public boolean previousConflict() throws SQLException {
        boolean bl = false;
        while (this.previous()) {
            if (this.currentRow().getStatus() == 3) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    CachedRow currentRow() throws SQLException {
        if (this.state == LifeCycle.INSERTING) {
            if (this.insertRow == null) {
                this.insertRow = new CachedRow(this.metaData);
                this.insertRow.setInsertRow(true);
            }
            return this.insertRow;
        }
        try {
            return (CachedRow)this.rows.get(this.rowIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new SQLException("The cursor " + this.rowIndex + " is not positioned over a valid row");
        }
    }

    @Override
    void updateCurrent(int n, Object object) throws SQLException {
        this.checkOp(7);
        this.currentRow().updateColumn(n, object);
    }

    @Override
    public boolean previousPage() throws SQLException {
        if (this.populateFromResultSet && this.pendingResultSet == null) {
            throw new SQLException("execute() or populate() must be called before previousPage() can be invoked.");
        }
        boolean bl = false;
        --this.currentPage;
        if (this.currentPage < 0) {
            this.currentPage = 0;
        } else {
            try {
                if (this.populateFromResultSet) {
                    this.populate(this.pendingResultSet);
                } else if (this.pendingConnection != null) {
                    this.execute(this.pendingConnection);
                } else {
                    this.execute();
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                ++this.currentPage;
            }
        }
        return bl;
    }

    @Override
    public boolean nextPage() throws SQLException {
        if (this.populateFromResultSet && this.pendingResultSet == null) {
            throw new SQLException("execute() or populate() must be called before nextPage() can be invoked.");
        }
        boolean bl = false;
        ++this.currentPage;
        try {
            this.isPopulated = false;
            if (this.populateFromResultSet) {
                this.populate(this.pendingResultSet);
            } else if (this.pendingConnection != null) {
                this.execute(this.pendingConnection);
            } else {
                this.execute();
            }
            if (this.isPopulated) {
                bl = true;
            } else {
                --this.currentPage;
            }
        }
        catch (SQLException sQLException) {
            --this.currentPage;
        }
        return bl;
    }

    @Override
    public int getPageSize() {
        return this.getMaxRows();
    }

    @Override
    public void setPageSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException(n + " is not a valid PageSize.");
        }
        this.setMaxRows(n);
    }

    @Override
    public void rowSetPopulated(RowSetEvent rowSetEvent, int n) throws SQLException {
        if (n > 0 && n > this.getFetchSize() && this.size() % n == 0) {
            this.rowSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOp();
        boolean bl = false;
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
        try {
            if (transaction != null && transaction.getStatus() == 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new SyncProviderException("Rollback failed because the status of the current transaction is unknown.");
        }
        if (bl) {
            throw new SQLException("This operation is not supported since there is an active global transaction on the current thread.");
        }
        if (this.txConnection != null) {
            try {
                this.txConnection.rollback(savepoint);
                this.state = LifeCycle.POPULATING;
                Object var6_5 = null;
                this.txConnection = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.txConnection = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        this.checkOp();
        boolean bl = false;
        Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
        try {
            if (transaction != null && transaction.getStatus() == 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new SyncProviderException("Rollback failed because the status of the current transaction is unknown.");
        }
        if (bl) {
            try {
                transaction.rollback();
                this.state = LifeCycle.POPULATING;
            }
            catch (Exception exception) {
                throw new SQLException(exception.toString());
            }
        }
        if (this.txConnection != null) {
            try {
                this.txConnection.rollback();
                this.state = LifeCycle.POPULATING;
                Object var5_5 = null;
                this.txConnection = null;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.txConnection = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        block11: {
            this.checkOp();
            boolean bl = false;
            Transaction transaction = TransactionHelper.getTransactionHelper().getTransaction();
            try {
                if (transaction != null && transaction.getStatus() == 0) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                throw new SyncProviderException("Rollback failed because the status of the current transaction is unknown.");
            }
            if (bl) {
                this.lock();
                try {
                    try {
                        transaction.commit();
                        this.refresh();
                        this.state = LifeCycle.POPULATING;
                    }
                    catch (Exception exception) {
                        throw new SQLException(exception.toString());
                    }
                    Object var5_5 = null;
                    this.unlock();
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    this.unlock();
                    throw throwable;
                }
            }
            if (this.txConnection != null) {
                this.lock();
                try {
                    this.txConnection.commit();
                    this.refresh();
                    this.state = LifeCycle.POPULATING;
                    Object var7_8 = null;
                    this.unlock();
                    this.txConnection = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    this.unlock();
                    this.txConnection = null;
                    throw throwable;
                }
            }
        }
    }

    @Override
    public Object getCacheKey() {
        if (this.key == null) {
            this.key = new RowSetCacheKey(this);
            return this.key;
        }
        return this.key;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new SQLException(this + " is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    class RowSetCacheKey {
        CachedRowSetImpl crs = null;

        RowSetCacheKey(CachedRowSetImpl cachedRowSetImpl2) {
            this.crs = cachedRowSetImpl2;
        }

        public boolean equals(Object object) {
            try {
                block14: {
                    if (this == object) {
                        return true;
                    }
                    CachedRowSetImpl cachedRowSetImpl = ((RowSetCacheKey)object).crs;
                    if (!this.crs.getCommand().equals(cachedRowSetImpl.getCommand())) {
                        return false;
                    }
                    ArrayList arrayList = this.crs.getParameters();
                    ArrayList arrayList2 = cachedRowSetImpl.getParameters();
                    if (arrayList.size() != arrayList2.size()) {
                        return false;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (((WLParameter)arrayList.get(i)).getObject().equals(((WLParameter)arrayList.get(i)).getObject())) continue;
                        return false;
                    }
                    if (this.crs.isPreferDataSource()) {
                        if (cachedRowSetImpl.isPreferDataSource()) {
                            try {
                                if (!this.crs.getDataSourceName().equals(cachedRowSetImpl.getDataSourceName())) {
                                    return false;
                                }
                                break block14;
                            }
                            catch (NullPointerException nullPointerException) {
                                if (this.crs.getDataSource() != cachedRowSetImpl.getDataSource()) {
                                    return false;
                                }
                                break block14;
                            }
                        }
                        return false;
                    }
                    if (cachedRowSetImpl.isPreferDataSource()) {
                        return false;
                    }
                    if (!this.crs.getUrl().equals(cachedRowSetImpl.getUrl())) {
                        return false;
                    }
                }
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public int hashCode() {
            String string = this.crs.getCommand();
            if (string == null) {
                return 0;
            }
            return string.hashCode();
        }
    }
}

