/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSetInternal;
import javax.sql.RowSetReader;
import weblogic.jdbc.rowset.CachedRowSetImpl;
import weblogic.jdbc.rowset.WLParameter;

public final class CachedRowSetJDBCReader
implements RowSetReader,
Serializable {
    private static final long serialVersionUID = 8780947650868222680L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(RowSetInternal rowSetInternal) throws SQLException {
        if (!(rowSetInternal instanceof CachedRowSetImpl)) {
            throw new SQLException("WLSyncProvider only supports WLS CachedRowSet Implmentation.");
        }
        CachedRowSetImpl cachedRowSetImpl = (CachedRowSetImpl)rowSetInternal;
        Connection connection = cachedRowSetImpl.getConnection();
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        try {
            try {
                callableStatement = connection.prepareCall(cachedRowSetImpl.getCommand(), 1004, 1008);
            }
            catch (SQLException sQLException) {
                callableStatement = connection.prepareCall(cachedRowSetImpl.getCommand());
            }
            for (WLParameter wLParameter : cachedRowSetImpl.getParameters()) {
                wLParameter.setParam(callableStatement);
            }
            int n = cachedRowSetImpl.getQueryTimeout();
            if (n != 0) {
                callableStatement.setQueryTimeout(n);
            }
            if (!cachedRowSetImpl.getEscapeProcessing()) {
                callableStatement.setEscapeProcessing(false);
            }
            callableStatement.execute();
            resultSet = callableStatement.getResultSet();
            if (resultSet != null) {
                cachedRowSetImpl.populateInternal(resultSet);
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (callableStatement != null) {
                callableStatement.close();
            }
        }
        catch (Exception exception) {}
    }
}

