/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.rowset;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import weblogic.jdbc.rowset.CachedRow;
import weblogic.jdbc.rowset.CachedRowSetMetaData;
import weblogic.jdbc.rowset.DatabaseMetaDataHolder;
import weblogic.jdbc.rowset.NullUpdateException;
import weblogic.jdbc.rowset.OciTableWriter;
import weblogic.jdbc.rowset.OracleTableWriter;
import weblogic.jdbc.rowset.TableNameParser;
import weblogic.jdbc.rowset.TableWriter;
import weblogic.jdbc.rowset.ThinOracleTableWriter;
import weblogic.jdbc.rowset.WLRowSetInternal;
import weblogic.jdbc.rowset.WLRowSetMetaData;
import weblogic.utils.Debug;

public final class CachedRowSetJDBCWriter
implements RowSetWriter,
Serializable {
    private static final long serialVersionUID = 2948281081383306001L;
    private static final String VERBOSE_JDBC_WRITER = "weblogic.jdbc.rowset.CachedRowSetJDBCWriter.verbose";
    private static final boolean VERBOSE = Boolean.getBoolean("weblogic.jdbc.rowset.CachedRowSetJDBCWriter.verbose");
    private static final String ORACLE_THIN_DRIVER_NAME = "Oracle JDBC driver";
    private static final String WL_OCI_DRIVER_NAME = "Weblogic, Inc. Java-OCI JDBC Driver (weblogicoci39)";

    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        WLRowSetInternal wLRowSetInternal;
        CachedRowSetMetaData cachedRowSetMetaData;
        if (VERBOSE) {
            Debug.say((String)"** BEGIN writeData");
        }
        if ((cachedRowSetMetaData = (CachedRowSetMetaData)(wLRowSetInternal = (WLRowSetInternal)rowSetInternal).getMetaData()).getOptimisticPolicy() == 3 && !cachedRowSetMetaData.hasSelectedColumn()) {
            throw new SQLException("There is no column selected to verify.");
        }
        List list = this.buildTableWriters(wLRowSetInternal);
        Connection connection = wLRowSetInternal.getConnection();
        Iterator iterator = list.iterator();
        if (!iterator.hasNext()) {
            for (CachedRow cachedRow : wLRowSetInternal.getCachedRows()) {
                if (!cachedRow.isInsertRow() && !cachedRow.isDeletedRow() && !cachedRow.isUpdatedRow()) continue;
                throw new NullUpdateException();
            }
        }
        while (iterator.hasNext()) {
            TableWriter tableWriter = (TableWriter)iterator.next();
            tableWriter.issueSQL(connection);
        }
        return true;
    }

    private String getTableName(WLRowSetMetaData wLRowSetMetaData, int n, boolean bl, boolean bl2, boolean bl3, String string) throws SQLException {
        String string2;
        String string3 = wLRowSetMetaData.getTableName(n + 1);
        if (string3 == null || "".equals(string3)) {
            String string4 = wLRowSetMetaData.getWriteTableName();
            if (string4 == null) {
                throw new SQLException("Unable to determine the table name for column: '" + wLRowSetMetaData.getColumnName(n + 1) + "'.  Please ensure that you've called " + "WLRowSetMetaData.setTableName  to set a table name " + "for this column.");
            }
            if (wLRowSetMetaData.isPrimaryKeyColumn(n + 1)) {
                return string4;
            }
            return null;
        }
        if (bl && (string2 = wLRowSetMetaData.getSchemaName(n + 1)) != null && !"".equals(string2)) {
            string3 = string2 + "." + string3;
        }
        if (bl2) {
            string2 = wLRowSetMetaData.getCatalogName(n + 1);
            if (bl3) {
                if (string2 != null && !"".equals(string2)) {
                    string3 = string2 + string + string3;
                }
            } else if (string2 != null && !"".equals(string2)) {
                string3 = string3 + string + string2;
            }
        }
        return string3;
    }

    private List buildTableWriters(WLRowSetInternal wLRowSetInternal) throws SQLException {
        Object object;
        Object object2;
        WLRowSetMetaData wLRowSetMetaData = (WLRowSetMetaData)wLRowSetInternal.getMetaData();
        String string = wLRowSetMetaData.getWriteTableName();
        DatabaseMetaData databaseMetaData = wLRowSetInternal.getConnection().getMetaData();
        boolean bl = databaseMetaData.supportsSchemasInDataManipulation();
        boolean bl2 = databaseMetaData.supportsCatalogsInDataManipulation();
        boolean bl3 = databaseMetaData.isCatalogAtStart();
        String string2 = databaseMetaData.getCatalogSeparator();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < wLRowSetMetaData.getColumnCount(); ++i) {
            object2 = this.getTableName(wLRowSetMetaData, i, bl, bl2, bl3, string2);
            if (string != null && !this.qualifiedTableEqual(wLRowSetMetaData, i, databaseMetaData, string)) continue;
            object = (BitSet)hashMap.get(object2);
            if (object == null) {
                object = new BitSet();
                hashMap.put(object2, object);
            }
            ((BitSet)object).set(i);
        }
        Iterator iterator = hashMap.keySet().iterator();
        object2 = new ArrayList();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            ((ArrayList)object2).add(this.createTableWriter(databaseMetaData, wLRowSetInternal, (String)object, (BitSet)hashMap.get(object)));
        }
        return object2;
    }

    private TableWriter createTableWriter(DatabaseMetaData databaseMetaData, WLRowSetInternal wLRowSetInternal, String string, BitSet bitSet) throws SQLException {
        if ("oracle".equalsIgnoreCase(databaseMetaData.getDatabaseProductName())) {
            if (WL_OCI_DRIVER_NAME.equals(databaseMetaData.getDriverName())) {
                return new OciTableWriter(wLRowSetInternal, string, bitSet);
            }
            if (ORACLE_THIN_DRIVER_NAME.equals(databaseMetaData.getDriverName())) {
                return new ThinOracleTableWriter(wLRowSetInternal, string, bitSet);
            }
            return new OracleTableWriter(wLRowSetInternal, string, bitSet);
        }
        if (databaseMetaData.getDriverName().startsWith("IBM DB2 JDBC")) {
            return new OracleTableWriter(wLRowSetInternal, string, bitSet);
        }
        return new TableWriter(wLRowSetInternal, string, bitSet);
    }

    private boolean qualifiedTableEqual(WLRowSetMetaData wLRowSetMetaData, int n, DatabaseMetaData databaseMetaData, String string) throws SQLException {
        String string2 = wLRowSetMetaData.getTableName(n + 1);
        String string3 = wLRowSetMetaData.getSchemaName(n + 1);
        String string4 = wLRowSetMetaData.getCatalogName(n + 1);
        TableNameParser tableNameParser = new TableNameParser(string, new DatabaseMetaDataHolder(databaseMetaData));
        String[] stringArray = tableNameParser.parse();
        return tableNameParser.identifierEqual(string2, stringArray[2]) && tableNameParser.identifierEqual(string3, stringArray[1]) && tableNameParser.identifierEqual(string4, stringArray[0]);
    }
}

